/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.BufferUnderflowException;
import tigase.io.IOInterface;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;
import tigase.stats.StatisticsList;

public class TLSIO
implements IOInterface {
    private static Logger log = Logger.getLogger(TLSIO.class.getName());
    private IOInterface io = null;
    private ByteBuffer tlsInput = null;
    private TLSWrapper tlsWrapper = null;

    public TLSIO(IOInterface ioi, TLSWrapper wrapper) throws IOException {
        this.io = ioi;
        this.tlsWrapper = wrapper;
        this.tlsInput = ByteBuffer.allocate(this.tlsWrapper.getAppBuffSize());
        if (log.isLoggable(Level.FINER)) {
            log.finer("TLS Socket created, connected: " + this.io.isConnected());
        }
        if (this.tlsWrapper.isClientMode()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("TLS - client mode, starting handshaking now...");
            }
            this.write(ByteBuffer.allocate(0));
            if (log.isLoggable(Level.FINER)) {
                log.finer("Handshaking completed, you can send data now.");
            }
        }
    }

    @Override
    public int bytesRead() {
        return this.io.bytesRead();
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.tlsWrapper.getPacketBuffSize();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        if (this.io != null) {
            this.io.getStatistics(list);
        }
    }

    @Override
    public boolean isConnected() {
        return this.io.isConnected();
    }

    @Override
    public boolean isRemoteAddress(String addr) {
        return this.io.isRemoteAddress(addr);
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        ByteBuffer tmpBuffer = this.io.read(buff);
        if (this.io.bytesRead() > 0) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Read bytes: " + this.io.bytesRead());
            }
            return this.decodeData(tmpBuffer);
        }
        return null;
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called...");
        }
        this.io.stop();
        this.tlsWrapper.close();
    }

    public String toString() {
        return "TLS: " + this.io.toString();
    }

    @Override
    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    @Override
    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        TLSStatus stat = this.tlsWrapper.getStatus();
        int loop_cnt = 0;
        int max_loop_runs = 1000;
        while ((stat == TLSStatus.NEED_WRITE || stat == TLSStatus.NEED_READ) && ++loop_cnt < max_loop_runs) {
            switch (stat) {
                case NEED_WRITE: {
                    this.writeBuff(ByteBuffer.allocate(0));
                    break;
                }
                case NEED_READ: {
                    ByteBuffer rbuff = this.read(ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize()));
                    break;
                }
            }
            stat = this.tlsWrapper.getStatus();
        }
        if (loop_cnt > max_loop_runs / 2) {
            log.warning("Infinite loop detected in write(buff) TLS code, tlsWrapper.getStatus(): " + (Object)((Object)this.tlsWrapper.getStatus()));
            throw new EOFException("Socket has been closed due to TLS problems.");
        }
        if (this.tlsWrapper.getStatus() == TLSStatus.CLOSED) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("TLS Socket closed...");
            }
            throw new EOFException("Socket has been closed.");
        }
        if (buff == null) {
            return this.io.write(null);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("TLS - Writing data, remaining: " + buff.remaining());
        }
        int result = this.writeBuff(buff);
        return result;
    }

    private ByteBuffer decodeData(ByteBuffer input) throws IOException {
        TLSStatus stat = null;
        do {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Decoding data: " + input.remaining());
                log.finer("input.capacity()=" + input.capacity());
                log.finer("input.remaining()=" + input.remaining());
                log.finer("input.limit()=" + input.limit());
                log.finer("input.position()=" + input.position());
            }
            this.tlsInput = this.tlsWrapper.unwrap(input, this.tlsInput);
            if (log.isLoggable(Level.FINEST)) {
                int netSize = this.tlsWrapper.getPacketBuffSize();
                log.finer("tlsWrapper.getStatus() = " + this.tlsWrapper.getStatus().name());
                log.finer("PacketBuffSize=" + netSize);
                log.finer("input.capacity()=" + input.capacity());
                log.finer("input.remaining()=" + input.remaining());
                log.finer("input.limit()=" + input.limit());
                log.finer("input.position()=" + input.position());
                log.finer("tlsInput.capacity()=" + this.tlsInput.capacity());
                log.finer("tlsInput.remaining()=" + this.tlsInput.remaining());
                log.finer("tlsInput.limit()=" + this.tlsInput.limit());
                log.finer("tlsInput.position()=" + this.tlsInput.position());
            }
            switch (this.tlsWrapper.getStatus()) {
                case NEED_WRITE: {
                    this.writeBuff(ByteBuffer.allocate(0));
                    break;
                }
                case UNDERFLOW: {
                    throw new BufferUnderflowException();
                }
                case CLOSED: {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("TLS Socket closed...");
                    }
                    throw new EOFException("Socket has been closed.");
                }
            }
        } while (((stat = this.tlsWrapper.getStatus()) == TLSStatus.NEED_READ || stat == TLSStatus.OK) && input.hasRemaining());
        if (input.hasRemaining()) {
            input.rewind();
        } else {
            input.clear();
        }
        this.tlsInput.flip();
        return this.tlsInput;
    }

    private int writeBuff(ByteBuffer buff) throws IOException {
        int result = 0;
        int wr = 0;
        int loop_cnt = 0;
        int max_loop_runs = 1000;
        do {
            ByteBuffer tlsOutput = ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize());
            tlsOutput.clear();
            this.tlsWrapper.wrap(buff, tlsOutput);
            if (this.tlsWrapper.getStatus() == TLSStatus.CLOSED) {
                throw new EOFException("Socket has been closed.");
            }
            tlsOutput.flip();
            wr = this.io.write(tlsOutput);
            result += wr;
        } while (buff.hasRemaining() && ++loop_cnt < max_loop_runs);
        if (loop_cnt > max_loop_runs / 2) {
            log.warning("Infinite loop detected in writeBuff(buff) TLS code, tlsWrapper.getStatus(): " + (Object)((Object)this.tlsWrapper.getStatus()));
            throw new EOFException("Socket has been closed due to TLS problems.");
        }
        if (this.tlsWrapper.getStatus() == TLSStatus.NEED_WRITE) {
            this.writeBuff(ByteBuffer.allocate(0));
        }
        return result;
    }
}

