/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserAuthRepositoryImpl;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.SimpleCache;

public class JDBCRepository
implements UserAuthRepository,
UserRepository {
    private static final Logger log = Logger.getLogger(JDBCRepository.class.getName());
    public static final String DEF_USERS_TBL = "tig_users";
    public static final String DEF_NODES_TBL = "tig_nodes";
    public static final String DEF_PAIRS_TBL = "tig_pairs";
    public static final String DEF_MAXIDS_TBL = "tig_max_ids";
    public static final String DEF_ROOT_NODE = "root";
    private static final String USER_STR = "User: ";
    public static final String DERBY_CONNVALID_QUERY = "values 1";
    public static final String JDBC_CONNVALID_QUERY = "select 1";
    public static final String DERBY_GETSCHEMAVER_QUERY = "values TigGetDBProperty('schema-version')";
    public static final String JDBC_GETSCHEMAVER_QUERY = "select TigGetDBProperty('schema-version')";
    private String nodes_tbl = "tig_nodes";
    private String pairs_tbl = "tig_pairs";
    private String root_node = "root";
    private UserAuthRepository auth = null;
    private String db_conn = null;
    private Connection conn = null;
    private CallableStatement uid_sp = null;
    private CallableStatement users_count_sp = null;
    private CallableStatement all_users_sp = null;
    private CallableStatement user_add_sp = null;
    private CallableStatement user_del_sp = null;
    private CallableStatement node_add_sp = null;
    private PreparedStatement users_domain_count_st = null;
    private PreparedStatement data_for_node_st = null;
    private PreparedStatement keys_for_node_st = null;
    private PreparedStatement nodes_for_node_st = null;
    private PreparedStatement insert_key_val_st = null;
    private PreparedStatement remove_key_data_st = null;
    private PreparedStatement conn_valid_st = null;
    private Map<String, Object> cache = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean autoCreateUser = false;
    private boolean derby_mode = false;

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    rs = this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserUID(String user_id, boolean autoCreate) throws SQLException, UserNotFoundException, TigaseDBException {
        Long cache_res = (Long)this.cache.get(user_id);
        if (cache_res != null) {
            return cache_res;
        }
        ResultSet rs = null;
        long result = -1L;
        try {
            CallableStatement callableStatement = this.uid_sp;
            synchronized (callableStatement) {
                this.uid_sp.setString(1, user_id);
                rs = this.uid_sp.executeQuery();
                result = rs.next() ? rs.getLong(1) : -1L;
                if (result <= 0L) {
                    if (autoCreate) {
                        result = this.addUserRepo(user_id);
                    } else {
                        throw new UserNotFoundException("User does not exist: " + user_id);
                    }
                }
            }
            this.release(null, rs);
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        this.cache.put(user_id, result);
        return result;
    }

    @Override
    public boolean userExists(String user) {
        try {
            this.getUserUID(user, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String buildNodeQuery(long uid, String node_path) {
        String query = "select nid as nid1 from " + this.nodes_tbl + " where (uid = " + uid + ")" + " AND (parent_nid is null)" + " AND (node = '" + this.root_node + "')";
        if (node_path == null) {
            return query;
        }
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        int cnt = 1;
        String subquery = query;
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            subquery = "select nid as nid" + ++cnt + ", node as node" + cnt + " from " + this.nodes_tbl + ", (" + subquery + ") nodes" + (cnt - 1) + " where (parent_nid = nid" + (cnt - 1) + ")" + " AND (node = '" + token + "')";
        }
        return subquery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNodeNID(long uid, String node_path) throws SQLException, TigaseDBException, UserNotFoundException {
        String query = this.buildNodeQuery(uid, node_path);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        long nid = -1L;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            nid = rs.next() ? rs.getLong(1) : -1L;
            if (nid <= 0L) {
                if (node_path == null) {
                    log.info("Missing root node, database upgrade or bug in the code? Adding missing root node now.");
                    nid = this.addNode(uid, -1L, DEF_ROOT_NODE);
                } else if (log.isLoggable(Level.FINEST)) {
                    log.finest("Missing nid for node path: " + node_path + " and uid: " + uid);
                }
            }
            long l = nid;
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            return l;
        }
        catch (Throwable throwable) {
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            throw throwable;
        }
    }

    private long getNodeNID(String user_id, String node_path) throws SQLException, UserNotFoundException, TigaseDBException {
        Long cache_res = (Long)this.cache.get(user_id + "/" + node_path);
        if (cache_res != null) {
            return cache_res;
        }
        long uid = this.getUserUID(user_id, this.autoCreateUser);
        long result = this.getNodeNID(uid, node_path);
        if (result > 0L) {
            this.cache.put(user_id + "/" + node_path, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long addNode(long uid, long parent_nid, String node_name) throws SQLException, TigaseDBException {
        ResultSet rs = null;
        long new_nid = -1L;
        CallableStatement callableStatement = this.node_add_sp;
        synchronized (callableStatement) {
            block7: {
                long l;
                try {
                    if (parent_nid < 0L) {
                        this.node_add_sp.setNull(1, -5);
                    } else {
                        this.node_add_sp.setLong(1, parent_nid);
                    }
                    this.node_add_sp.setLong(2, uid);
                    this.node_add_sp.setString(3, node_name);
                    rs = this.node_add_sp.executeQuery();
                    if (!rs.next()) break block7;
                    l = rs.getLong(1);
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
                return l;
            }
            log.warning("Missing NID after adding new node...");
            throw new TigaseDBException("Propeblem adding new node. The SP should return nid or fail");
        }
    }

    private long createNodePath(String user_id, String node_path) throws SQLException, UserNotFoundException, TigaseDBException {
        if (node_path == null) {
            return this.getNodeNID(user_id, null);
        }
        long uid = this.getUserUID(user_id, this.autoCreateUser);
        long nid = this.getNodeNID(uid, null);
        StringTokenizer strtok = new StringTokenizer(node_path, "/", false);
        StringBuilder built_path = new StringBuilder();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            built_path.append("/").append(token);
            long cur_nid = this.getNodeNID(uid, built_path.toString());
            if (cur_nid > 0L) {
                nid = cur_nid;
                continue;
            }
            nid = this.addNode(uid, nid, token);
        }
        return nid;
    }

    private void initPreparedStatements() throws SQLException {
        String query = "{ call TigGetUserDBUid(?) }";
        this.uid_sp = this.conn.prepareCall(query);
        query = "{ call TigAllUsersCount() }";
        this.users_count_sp = this.conn.prepareCall(query);
        query = "{ call TigAllUsers() }";
        this.all_users_sp = this.conn.prepareCall(query);
        query = "{ call TigAddUserPlainPw(?, ?) }";
        this.user_add_sp = this.conn.prepareCall(query);
        query = "{ call TigRemoveUser(?) }";
        this.user_del_sp = this.conn.prepareCall(query);
        query = "{ call TigAddNode(?, ?, ?) }";
        this.node_add_sp = this.conn.prepareCall(query);
        query = "select count(*) from tig_users where user_id like ?";
        this.users_domain_count_st = this.conn.prepareCall(query);
        query = "select pval from " + this.pairs_tbl + " where (nid = ?) AND (pkey = ?)";
        this.data_for_node_st = this.conn.prepareStatement(query);
        query = "select pkey from " + this.pairs_tbl + " where (nid = ?)";
        this.keys_for_node_st = this.conn.prepareStatement(query);
        query = "select nid, node from " + this.nodes_tbl + " where parent_nid = ?";
        this.nodes_for_node_st = this.conn.prepareStatement(query);
        query = "insert into " + this.pairs_tbl + " (nid, uid, pkey, pval) " + " values (?, ?, ?, ?)";
        this.insert_key_val_st = this.conn.prepareStatement(query);
        query = "delete from " + this.pairs_tbl + " where (nid = ?) AND (pkey = ?)";
        this.remove_key_data_st = this.conn.prepareStatement(query);
        query = this.derby_mode ? DERBY_CONNVALID_QUERY : JDBC_CONNVALID_QUERY;
        this.conn_valid_st = this.conn.prepareStatement(query);
    }

    private void checkDBSchema() throws SQLException {
        String schema_version = "1.0";
        String query = this.derby_mode ? DERBY_GETSCHEMAVER_QUERY : JDBC_GETSCHEMAVER_QUERY;
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next() && !"4.0".equals(schema_version = rs.getString(1))) {
            System.err.println("\n\nPlease upgrade database schema now.");
            System.err.println("Current scheme version is: " + schema_version + ", expected: 4.0");
            System.err.println("Check the schema upgrade guide at the address:");
            System.err.println("http://www.tigase.org/en/mysql-db-schema-upgrade-4-0");
            System.err.println("----");
            System.err.println("If you have upgraded your schema and you are still");
            System.err.println("experiencing this problem please contact support at");
            System.err.println("e-mail address: support@tigase.org");
            System.exit(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        Statement stmt = null;
        Object rs = null;
        try {
            String string = this.db_conn;
            synchronized (string) {
                this.conn = DriverManager.getConnection(this.db_conn);
                this.conn.setAutoCommit(true);
                this.derby_mode = this.db_conn.startsWith("jdbc:derby");
                this.checkDBSchema();
                this.initPreparedStatements();
                this.auth = new UserAuthRepositoryImpl(this);
                stmt = this.conn.createStatement();
                if (this.db_conn.contains("cacheRepo=off")) {
                    log.fine("Disabling cache.");
                    this.cache = Collections.synchronizedMap(new RepoCache(0, -1000L));
                } else {
                    this.cache = Collections.synchronizedMap(new RepoCache(10000, 60000L));
                }
            }
            this.release(stmt, rs);
            stmt = null;
            rs = null;
        }
        catch (Throwable throwable) {
            this.release(stmt, rs);
            stmt = null;
            rs = null;
            throw throwable;
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        this.db_conn = connection_str;
        if (this.db_conn.contains("autoCreateUser=true")) {
            this.autoCreateUser = true;
        }
        try {
            this.initRepo();
            log.info("Initialized database connection: " + connection_str);
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long users = -1L;
            CallableStatement callableStatement = this.users_count_sp;
            synchronized (callableStatement) {
                rs = this.users_count_sp.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.release(null, rs);
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        ResultSet rs = null;
        try {
            this.checkConnection();
            long users = -1L;
            PreparedStatement preparedStatement = this.users_domain_count_st;
            synchronized (preparedStatement) {
                this.users_domain_count_st.setString(1, "%@" + domain);
                rs = this.users_domain_count_st.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.release(null, rs);
            rs = null;
        }
    }

    @Override
    public List<String> getUsers() throws TigaseDBException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            rs = this.all_users_sp.executeQuery();
            ArrayList<String> users = new ArrayList<String>();
            while (rs.next()) {
                users.add(rs.getString(1));
            }
            ArrayList<String> arrayList = users;
            this.release(null, rs);
            rs = null;
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Problem loading user list from repository", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                rs = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserRepo(String user_id) throws SQLException, TigaseDBException {
        this.checkConnection();
        ResultSet rs = null;
        long uid = -1L;
        CallableStatement callableStatement = this.user_add_sp;
        synchronized (callableStatement) {
            try {
                this.user_add_sp.setString(1, user_id);
                this.user_add_sp.setNull(2, 12);
                rs = this.user_add_sp.executeQuery();
                if (!rs.next()) {
                    log.warning("Missing UID after adding new user...");
                    throw new TigaseDBException("Propeblem adding new user to repository. The SP should return uid or fail");
                }
                uid = rs.getLong(1);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
        this.cache.put(user_id, uid);
        return uid;
    }

    @Override
    public void addUser(String user_id) throws UserExistsException, TigaseDBException {
        try {
            this.addUserRepo(user_id);
        }
        catch (SQLException e) {
            throw new UserExistsException("Error adding user to repository: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(String user_id) throws UserNotFoundException, TigaseDBException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            this.checkConnection();
            stmt = this.conn.createStatement();
            long uid = this.getUserUID(user_id, this.autoCreateUser);
            query = "delete from " + this.pairs_tbl + " where uid = " + uid;
            stmt.executeUpdate(query);
            query = "delete from " + this.nodes_tbl + " where uid = " + uid;
            stmt.executeUpdate(query);
            CallableStatement callableStatement = this.user_del_sp;
            synchronized (callableStatement) {
                this.user_del_sp.setString(1, user_id);
                this.user_del_sp.executeUpdate();
            }
            this.release(stmt, rs);
            stmt = null;
            this.cache.remove(user_id);
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Error removing user from repository: " + query, e);
            }
            catch (Throwable throwable) {
                this.release(stmt, rs);
                stmt = null;
                this.cache.remove(user_id);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getDataList(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String[] stringArray;
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            PreparedStatement preparedStatement = this.data_for_node_st;
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    String[] result;
                    ArrayList<String> results = new ArrayList<String>();
                    this.data_for_node_st.setLong(1, nid);
                    this.data_for_node_st.setString(2, key);
                    rs = this.data_for_node_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    String[] stringArray2 = result = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var7_7
                    this.release(null, rs);
                    return stringArray2;
                }
                stringArray = null;
            }
            this.release(null, rs);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting data list.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getSubnodes(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String[] stringArray;
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            PreparedStatement preparedStatement = this.nodes_for_node_st;
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    ArrayList<String> results = new ArrayList<String>();
                    this.nodes_for_node_st.setLong(1, nid);
                    rs = this.nodes_for_node_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(2));
                    }
                    String[] stringArray2 = results.size() == 0 ? null : results.toArray(new String[results.size()]);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                    this.release(null, rs);
                    return stringArray2;
                }
                stringArray = null;
            }
            this.release(null, rs);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting subnodes list.", e);
            }
        }
    }

    @Override
    public String[] getSubnodes(String user_id) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user_id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubnode(long nid) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = this.conn.createStatement();
            query = "delete from " + this.pairs_tbl + " where nid = " + nid;
            stmt.executeUpdate(query);
            query = "delete from " + this.nodes_tbl + " where nid = " + nid;
            stmt.executeUpdate(query);
        }
        finally {
            this.release(stmt, rs);
        }
    }

    @Override
    public void removeSubnode(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        if (subnode == null) {
            return;
        }
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (nid > 0L) {
                this.deleteSubnode(nid);
                this.cache.remove(user_id + "/" + subnode);
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public void setDataList(String user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, subnode, key);
        this.addDataList(user_id, subnode, key, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataList(String user_id, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        long uid = -2L;
        long nid = -2L;
        try {
            this.checkConnection();
            uid = this.getUserUID(user_id, this.autoCreateUser);
            nid = this.getNodeNID(uid, subnode);
            if (nid < 0L) {
                try {
                    nid = this.createNodePath(user_id, subnode);
                }
                catch (SQLException e) {
                    nid = this.getNodeNID(uid, subnode);
                }
            }
            PreparedStatement e = this.insert_key_val_st;
            synchronized (e) {
                this.insert_key_val_st.setLong(1, nid);
                this.insert_key_val_st.setLong(2, uid);
                this.insert_key_val_st.setString(3, key);
                for (String val : list) {
                    this.insert_key_val_st.setString(4, val);
                    this.insert_key_val_st.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error adding data list, user_id: " + user_id + ", subnode: " + subnode + ", key: " + key + ", uid: " + uid + ", nid: " + nid + ", list: " + Arrays.toString(list), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getKeys(String user_id, String subnode) throws UserNotFoundException, TigaseDBException {
        rs = null;
        try {
            this.checkConnection();
            nid = this.getNodeNID(user_id, subnode);
            if (nid <= 0L) ** GOTO lbl-1000
            results = new ArrayList<String>();
            var7_8 = this.keys_for_node_st;
            synchronized (var7_8) {
                this.keys_for_node_st.setLong(1, nid);
                rs = this.keys_for_node_st.executeQuery();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                var8_9 = results.size() == 0 ? null : results.toArray(new String[results.size()]);
            }
            this.release(null, rs);
            return var8_9;
lbl-1000:
            // 1 sources

            {
                var6_7 = null;
            }
            this.release(null, rs);
            return var6_7;
        }
        catch (SQLException e) {
            try {
                throw new TigaseDBException("Error getting subnodes list.", e);
            }
            catch (Throwable var10_10) {
                this.release(null, rs);
                throw var10_10;
            }
        }
    }

    @Override
    public String[] getKeys(String user_id) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user_id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getData(String user_id, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Loading data for key: " + key + ", user: " + user_id + ", node: " + subnode + ", def: " + def + ", found nid: " + nid);
            }
            PreparedStatement preparedStatement = this.data_for_node_st;
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    String result = def;
                    this.data_for_node_st.setLong(1, nid);
                    this.data_for_node_st.setString(2, key);
                    rs = this.data_for_node_st.executeQuery();
                    if (rs.next()) {
                        result = rs.getString(1);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Found data: " + result);
                        }
                    }
                    String string2 = result;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl20 : MonitorExitStatement: MONITOREXIT : var8_8
                    this.release(null, rs);
                    return string2;
                }
                string = def;
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new TigaseDBException("Error getting data list.", e);
            }
        }
    }

    @Override
    public String getData(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, subnode, key, null);
    }

    @Override
    public String getData(String user_id, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user_id, null, key, null);
    }

    @Override
    public void setData(String user_id, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setDataList(user_id, subnode, key, new String[]{value});
    }

    @Override
    public void setData(String user_id, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user_id, null, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(String user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            long nid = this.getNodeNID(user_id, subnode);
            PreparedStatement preparedStatement = this.remove_key_data_st;
            synchronized (preparedStatement) {
                if (nid > 0L) {
                    this.remove_key_data_st.setLong(1, nid);
                    this.remove_key_data_st.setString(2, key);
                    this.remove_key_data_st.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error getting subnodes list.", e);
        }
    }

    @Override
    public void removeData(String user_id, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user_id, null, key);
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.plainAuth(user, password);
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.digestAuth(user, digest, id, alg);
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    public void updatePassword(String user, String password) throws TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    private class RepoCache
    extends SimpleCache<String, Object> {
        public RepoCache(int maxsize, long cache_time) {
            super(maxsize, cache_time);
        }

        public Object remove(Object key) {
            if (this.cache_off) {
                return null;
            }
            Object val = super.remove(key);
            String strk = key.toString();
            Iterator ks = this.keySet().iterator();
            while (ks.hasNext()) {
                String k = ((String)ks.next()).toString();
                if (!k.startsWith(strk)) continue;
                ks.remove();
            }
            return val;
        }
    }
}

