/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.util.SimpleCache;

public class UserRepositoryPool
implements UserRepository {
    private static final Logger log = Logger.getLogger(UserRepositoryPool.class.getName());
    private Map<String, Object> cache = null;
    private LinkedBlockingQueue<UserRepository> repoPool = new LinkedBlockingQueue();

    public void addRepo(UserRepository repo) {
        this.repoPool.offer(repo);
    }

    public UserRepository takeRepo() {
        try {
            return this.repoPool.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain user repository from the pool", ex);
            return null;
        }
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        if (resource_uri.contains("cacheRepo=off")) {
            log.fine("Disabling cache.");
            this.cache = Collections.synchronizedMap(new RepoCache(0, -1000L));
        } else {
            this.cache = Collections.synchronizedMap(new RepoCache(10000, 60000L));
        }
    }

    @Override
    public String getResourceUri() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsers() throws TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                List<String> list = repo.getUsers();
                return list;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount();
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean userExists(String user) {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.userExists(user);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(String user) throws UserExistsException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.addUser(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(String user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeUser(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDataList(String user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String[] stringArray = repo.getDataList(user, subnode, key);
                return stringArray;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getData(String user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        String data = (String)this.cache.get(user + "/" + subnode + "/" + key);
        if (data != null) {
            return data;
        }
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getData(user, subnode, key, def);
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getData(String user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        String data = (String)this.cache.get(user + "/" + subnode + "/" + key);
        if (data != null) {
            return data;
        }
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getData(user, subnode, key);
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getData(String user, String key) throws UserNotFoundException, TigaseDBException {
        String data = (String)this.cache.get(user + "/" + key);
        if (data != null) {
            return data;
        }
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getData(user, key);
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSubnodes(String user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String[] stringArray = repo.getSubnodes(user, subnode);
                return stringArray;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSubnodes(String user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String[] stringArray = repo.getSubnodes(user);
                return stringArray;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getKeys(String user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String[] stringArray = repo.getKeys(user, subnode);
                return stringArray;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getKeys(String user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String[] stringArray = repo.getKeys(user);
                return stringArray;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(String user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        this.cache.remove(user + "/" + subnode + "/" + key);
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeData(user, subnode, key);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(String user, String key) throws UserNotFoundException, TigaseDBException {
        this.cache.remove(user + "/" + key);
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeData(user, key);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubnode(String user, String subnode) throws UserNotFoundException, TigaseDBException {
        this.cache.remove(user + "/" + subnode);
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeSubnode(user, subnode);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.setData(user, subnode, key, value);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
        this.cache.put(user + "/" + subnode + "/" + key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String user, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.setData(user, key, value);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
        this.cache.put(user + "/" + key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.setDataList(user, subnode, key, list);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.addDataList(user, subnode, key, list);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        UserRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount(domain);
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return 0L;
    }

    private class RepoCache
    extends SimpleCache<String, Object> {
        public RepoCache(int maxsize, long cache_time) {
            super(maxsize, cache_time);
        }

        public Object remove(Object key) {
            if (this.cache_off) {
                return null;
            }
            Object val = super.remove(key);
            String strk = key.toString();
            Iterator ks = this.keySet().iterator();
            while (ks.hasNext()) {
                String k = ((String)ks.next()).toString();
                if (!k.startsWith(strk)) continue;
                ks.remove();
            }
            return val;
        }
    }
}

