/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterController;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.ServerConnectionManager;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ServerConnectionClustered
extends ServerConnectionManager
implements ClusteredComponent {
    private static final Logger log = Logger.getLogger("tigase.cluster.ServerConnectionClustered");
    private static final String CID_P = "cid";
    private static final String KEY_P = "key";
    private static final String FORKEY_SESSION_ID = "forkey_sessionId";
    private static final String ASKING_SESSION_ID = "asking_sessionId";
    private static final String VALID = "valid";
    private List<JID> cl_nodes_array = new CopyOnWriteArrayList<JID>();

    @Override
    public void nodeConnected(String node) {
        this.cl_nodes_array.add(JID.jidInstanceNS((String)this.getName(), (String)node, null));
    }

    @Override
    public void nodeDisconnected(String node) {
        this.cl_nodes_array.remove(JID.jidInstanceNS((String)this.getName(), (String)node, null));
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            this.processClusterPacket(packet);
            return;
        }
        super.processPacket(packet);
    }

    @Override
    public void setClusterController(ClusterController cl_controller) {
    }

    protected JID getFirstClusterNode() {
        JID cluster_node = null;
        for (JID node : this.cl_nodes_array) {
            if (node.equals((Object)this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    @Override
    protected String getLocalDBKey(CID cid, String key, String forkey_sessionId, String asking_sessionId) {
        String local_key = super.getLocalDBKey(cid, key, forkey_sessionId, asking_sessionId);
        if (local_key != null) {
            return local_key;
        }
        JID cluster_node = this.getFirstClusterNode();
        if (cluster_node != null) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put(CID_P, cid.toString());
            params.put(KEY_P, key);
            params.put(FORKEY_SESSION_ID, forkey_sessionId);
            params.put(ASKING_SESSION_ID, asking_sessionId);
            Element result = ClusterElement.createClusterMethodCall(this.getComponentId().toString(), cluster_node.toString(), StanzaType.set, ClusterMethods.CHECK_DB_KEY.toString(), params).getClusterElement();
            this.addOutPacket(Packet.packetInstance(result, this.getComponentId(), cluster_node));
        }
        return null;
    }

    protected void processClusterPacket(Packet packet) {
        ClusterElement clel = new ClusterElement(packet.getElement());
        clel.addVisitedNode(this.getComponentId().toString());
        switch (packet.getType()) {
            case set: {
                if (!ClusterMethods.CHECK_DB_KEY.toString().equals(clel.getMethodName())) break;
                String cid = clel.getMethodParam(CID_P);
                String key = clel.getMethodParam(KEY_P);
                String forkey_sessionId = clel.getMethodParam(FORKEY_SESSION_ID);
                String asking_sessionId = clel.getMethodParam(ASKING_SESSION_ID);
                String local_key = super.getLocalDBKey(new CID(cid), key, forkey_sessionId, asking_sessionId);
                ClusterElement result = null;
                boolean valid = false;
                if (local_key != null) {
                    valid = local_key.equals(key);
                } else {
                    result = ClusterElement.createForNextNode(clel, this.cl_nodes_array, this.getComponentId());
                }
                if (result == null) {
                    LinkedHashMap<String, String> res_vals = new LinkedHashMap<String, String>();
                    res_vals.put(VALID, "" + valid);
                    result = clel.createMethodResponse(this.getComponentId().toString(), StanzaType.result, res_vals);
                }
                try {
                    this.addOutPacket(Packet.packetInstance(result.getClusterElement()));
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Cluster packet addressing problem, stringprep failed for: " + result.getClusterElement());
                }
                break;
            }
            case get: {
                break;
            }
            case result: {
                if (!ClusterMethods.CHECK_DB_KEY.toString().equals(clel.getMethodName())) break;
                CID cid = new CID(clel.getMethodParam(CID_P));
                String key = clel.getMethodParam(KEY_P);
                String forkey_sessionId = clel.getMethodParam(FORKEY_SESSION_ID);
                String asking_sessionId = clel.getMethodParam(ASKING_SESSION_ID);
                boolean valid = "true".equals(clel.getMethodResultVal(VALID));
                String from = cid.getFromHost();
                String to = cid.getToHost();
                this.sendVerifyResult(from, to, forkey_sessionId, valid, this.getServerConnections(cid), asking_sessionId);
                break;
            }
            case error: {
                JID from = packet.getStanzaFrom();
                clel.addVisitedNode(from.toString());
                Element result = ClusterElement.createForNextNode(clel, this.cl_nodes_array, this.getComponentId()).getClusterElement();
                try {
                    this.addOutPacket(Packet.packetInstance(result));
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Cluster packet addressing problem, stringprep failed for: " + result);
                }
                break;
            }
        }
    }
}

