/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.util.Algorithms;
import tigase.xmpp.BareJID;

public class SaslPLAIN
implements SaslServer {
    public static final String ENCRYPTION_KEY = "password-encryption";
    public static final String ENCRYPTION_PLAIN = "PLAIN";
    public static final String ENCRYPTION_MD5 = "MD5";
    public static final String ENCRYPTION_LS_MD5 = "LS-MD5";
    public static final String ENCRYPTION_SHA = "SHA";
    private static final String MECHANISM = "PLAIN";
    private Map<? super String, ?> props = null;
    private CallbackHandler callbackHandler = null;
    private boolean auth_ok = false;

    public SaslPLAIN() {
    }

    protected SaslPLAIN(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        this.props = props;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public byte[] unwrap(byte[] byteArray, int n, int n1) throws SaslException {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] evaluateResponse(byte[] byteArray) throws SaslException {
        String alg;
        String passwd;
        int user_idx;
        int auth_idx;
        for (auth_idx = 0; byteArray[auth_idx] != 0 && auth_idx < byteArray.length; ++auth_idx) {
        }
        String authoriz = new String(byteArray, 0, auth_idx);
        for (user_idx = ++auth_idx; byteArray[user_idx] != 0 && user_idx < byteArray.length; ++user_idx) {
        }
        String user_id = new String(byteArray, auth_idx, user_idx - auth_idx);
        if ((passwd = new String(byteArray, ++user_idx, byteArray.length - user_idx)) != null && (alg = (String)this.props.get(ENCRYPTION_KEY)) != null) {
            try {
                if (alg.equals(ENCRYPTION_MD5) || alg.equals(ENCRYPTION_SHA)) {
                    passwd = Algorithms.hexDigest((String)"", (String)passwd, (String)alg);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Password encrypting algorithm is not supported.", e);
            }
        }
        if (this.callbackHandler == null) {
            throw new SaslException("Error: no CallbackHandler available.");
        }
        Callback[] callbacks = new Callback[3];
        NameCallback nc = new NameCallback("User name", user_id);
        PasswordCallback pc = new PasswordCallback("User password", false);
        RealmCallback rc = new RealmCallback("Put domain as realm.");
        callbacks[0] = nc;
        callbacks[1] = pc;
        callbacks[2] = rc;
        try {
            this.callbackHandler.handle(callbacks);
            char[] real_password = pc.getPassword();
            if (!Arrays.equals(real_password, passwd.toCharArray())) {
                throw new SaslException("Password missmatch.");
            }
            if (authoriz != null && !authoriz.isEmpty()) {
                String realm = rc.getText();
                callbacks = new Callback[1];
                AuthorizeCallback ac = new AuthorizeCallback(BareJID.toString((String)user_id, (String)realm), authoriz);
                callbacks[0] = ac;
                this.callbackHandler.handle(callbacks);
                if (!ac.isAuthorized()) throw new SaslException("Not authorized.");
                this.auth_ok = true;
                return null;
            } else {
                this.auth_ok = true;
            }
            return null;
        }
        catch (Exception e) {
            throw new SaslException("Authorization error.", e);
        }
    }

    @Override
    public String getAuthorizationID() {
        return null;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.auth_ok;
    }

    @Override
    public byte[] wrap(byte[] byteArray, int n, int n1) throws SaslException {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.props = null;
        this.callbackHandler = null;
    }
}

