/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1409 $
 * Last modified by $Author: kobit $
 * $Date: 2009-01-09 22:35:46 +0000 (Fri, 09 Jan 2009) $
 */

package tigase.server;

/**
 * Interface ComponentRegistrator
 *
 * Collects information about all ServerComponents connected to MessageRouter
 *
 * Created: Tue Nov 22 07:07:11 2005
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1409 $
 */
public interface ComponentRegistrator extends ServerComponent {

  /**
   *
   * @param component
   * @return a <code>boolean</code> value indicating whehether component has
   * been successfuly added or not.
   */
	boolean addComponent(ServerComponent component);

  /**
   *
	 * @param component 
	 * @return a <code>boolean</code> value indicating whehether component has
   * been successfuly removed or not.
   */
	boolean deleteComponent(ServerComponent component);

}