/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.HashSet;
import java.util.logging.Logger;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;

public class RosterElement {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterElement");
    private static final String ELEM_NAME = "contact";
    private static final String JID_ATT = "jid";
    private static final String NAME_ATT = "name";
    private static final String SUBS_ATT = "subs";
    private static final String GRP_ATT = "groups";
    private XMPPResourceConnection session = null;
    private RosterAbstract.SubscriptionType subscription = null;
    private String[] groups = null;
    private String name = null;
    private String jid = null;
    private boolean presence_sent = false;

    public boolean isPresence_sent() {
        return this.presence_sent;
    }

    public void setPresence_sent(boolean presence_sent) {
        this.presence_sent = presence_sent;
    }

    public RosterElement(String jid, String name, String[] groups, XMPPResourceConnection session) {
        this.session = session;
        this.setJid(jid);
        if (name == null) {
            this.name = JIDUtils.getNodeNick((String)this.jid);
            if (this.name == null || this.name.isEmpty()) {
                this.name = this.jid;
            }
        } else {
            this.name = name;
        }
        this.groups = groups;
        this.subscription = RosterAbstract.SubscriptionType.none;
    }

    public RosterElement(Element roster_el, XMPPResourceConnection session) {
        this.session = session;
        if (roster_el.getName() == ELEM_NAME) {
            this.setJid(roster_el.getAttribute(JID_ATT));
            this.name = roster_el.getAttribute(NAME_ATT);
            if (this.name == null || this.name.isEmpty()) {
                this.name = JIDUtils.getNodeNick((String)this.jid);
                if (this.name == null || this.name.isEmpty()) {
                    this.name = this.jid;
                }
            }
            this.subscription = roster_el.getAttribute(SUBS_ATT) == null ? RosterAbstract.SubscriptionType.none : RosterAbstract.SubscriptionType.valueOf(roster_el.getAttribute(SUBS_ATT));
        } else {
            log.warning("Incorrect roster data: " + roster_el.toString());
        }
        String grps = roster_el.getAttribute(GRP_ATT);
        if (grps != null && !grps.isEmpty()) {
            this.groups = grps.split(",");
        }
    }

    private void setJid(String jid) {
        this.jid = jid.toLowerCase();
        String buddy_domain = JIDUtils.getNodeHost((String)this.jid);
        if (this.session != null && this.session.isLocalDomain(buddy_domain, false)) {
            this.jid = this.jid.intern();
        }
    }

    public String getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public RosterAbstract.SubscriptionType getSubscription() {
        return this.subscription;
    }

    public void setSubscription(RosterAbstract.SubscriptionType subscription) {
        this.subscription = subscription == null ? RosterAbstract.SubscriptionType.none : subscription;
    }

    public Element getRosterElement() {
        Element elem = new Element(ELEM_NAME, new String[]{JID_ATT, SUBS_ATT, NAME_ATT}, new String[]{this.jid, this.subscription.toString(), this.name});
        if (this.groups != null && this.groups.length > 0) {
            String grps = "";
            for (String group : this.groups) {
                grps = grps + group + ",";
            }
            grps = grps.substring(0, grps.length() - 1);
            elem.setAttribute(GRP_ATT, grps);
        }
        return elem;
    }

    public Element getRosterItem() {
        Element item = new Element("item");
        item.setAttribute(JID_ATT, this.jid);
        item.addAttributes(this.subscription.getSubscriptionAttr());
        if (this.name != null) {
            item.setAttribute(NAME_ATT, XMLUtils.escape((String)this.name));
        }
        if (this.groups != null) {
            for (String gr : this.groups) {
                Element group = new Element("group");
                group.setCData(XMLUtils.escape((String)gr));
                item.addChild((XMLNodeIfc)group);
            }
        }
        return item;
    }

    void addGroups(String[] groups) {
        if (groups != null) {
            if (this.groups == null) {
                this.groups = groups;
            } else {
                HashSet<String> groupsSet = new HashSet<String>();
                for (String group : this.groups) {
                    groupsSet.add(group);
                }
                for (String group : groups) {
                    groupsSet.add(group);
                }
                this.groups = groupsSet.toArray(new String[groupsSet.size()]);
            }
        }
    }
}

