/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class StartTLS
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static Logger log = Logger.getLogger(StartTLS.class.getName());
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-tls";
    public static final String TLS_REQUIRED_KEY = "tls-required";
    private static final String ID = "starttls";
    private static final String[] ELEMENTS = new String[]{"starttls", "proceed", "failure"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls", "urn:ietf:params:xml:ns:xmpp-tls"};
    private static final Element[] F_REQUIRED = new Element[]{new Element("starttls", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private static final Element[] F_NOT_REQUIRED = new Element[]{new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"})};
    private Element proceed = new Element("proceed", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private Element failure = new Element("failure", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && session.getSessionData(ID) == null) {
            if (session.getSessionData(TLS_REQUIRED_KEY) != null && session.getSessionData(TLS_REQUIRED_KEY).equals("true")) {
                return F_REQUIRED;
            }
            return F_NOT_REQUIRED;
        }
        return null;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (packet.isElement(ID, XMLNS)) {
            session.putSessionData(ID, "true");
            Packet result = Command.STARTTLS.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId(), Command.DataType.submit);
            Command.setData(result, this.proceed);
            results.offer(result);
        } else {
            log.warning("Unknown TLS element: " + packet.getStringData());
            results.offer(packet.swapFromTo(this.failure));
            results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
        }
    }
}

