/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.JabberIqRoster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public abstract class Presence {
    public static final String DIRECT_PRESENCE = "direct-presences";
    public static final String PRESENCE_ELEMENT_NAME = "presence";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Presence");
    protected static final String XMLNS = "jabber:client";
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
    private static long requiredYes = 0L;
    private static long requiredNo = 0L;

    private static boolean requiresPresenceSending(String buddy, XMPPResourceConnection session) {
        boolean result;
        String buddy_domain = JIDUtils.getNodeHost((String)buddy);
        boolean bl = result = !runtime.hasCompleteJidsInfo() || !session.isLocalDomain(buddy_domain, false) || runtime.isJidOnline(buddy);
        if (log.isLoggable(Level.FINEST)) {
            if (result) {
                ++requiredYes;
            } else {
                ++requiredNo;
            }
            log.finest("Yes/No: " + requiredYes + " / " + requiredNo + ", buddy: " + buddy + ", result=" + result + ", !runtime.hasCompleteJidsInfo()=" + !runtime.hasCompleteJidsInfo() + ", !session.isLocalDomain(buddy_domain, false)=" + !session.isLocalDomain(buddy_domain, false) + ", runtime.isJidOnline(buddy)=" + runtime.isJidOnline(buddy));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block12: {
                Set direct_presences;
                try {
                    if (session.getSessionData("user-presence") != null) {
                        Presence.broadcastOffline(session, results, settings);
                        Presence.updateOfflineChange(session, results);
                    } else {
                        Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, null);
                    }
                }
                catch (NotAuthorizedException e) {
                }
                catch (TigaseDBException e) {
                    log.warning("Error accessing database for offline message: " + e);
                }
                if (session.isAnonymous() && (direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE)) != null) {
                    try {
                        for (String buddy : direct_presences) {
                            String peer = JIDUtils.getNodeID((String)buddy);
                            Packet roster_update = new Packet(JabberIqRoster.createRosterPacket("set", session.nextStanzaId(), peer, peer, session.getUserId(), null, null, "remove", "anon"));
                            results.offer(roster_update);
                        }
                    }
                    catch (NotAuthorizedException e) {
                        if (!log.isLoggable(Level.FINEST)) break block12;
                        log.finest("Anonymous user has logged out already: " + session.getConnectionId());
                    }
                }
            }
        }
    }

    protected static void broadcastOffline(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        Element pres = (Element)session.getSessionData("user-presence");
        if (pres != null) {
            pres.setAttribute("type", StanzaType.unavailable.toString());
        }
        String[] buddies = roster_util.getBuddies(session, RosterAbstract.FROM_SUBSCRIBED);
        if ((buddies = DynamicRoster.addBuddies(session, settings, buddies)) != null && pres != null) {
            for (String buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                Presence.sendPresence(StanzaType.unavailable, buddy, null, results, pres);
            }
        }
        Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, pres);
    }

    protected static void broadcastProbe(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        String[] buddies_from;
        String[] buddies_to;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Broadcasting probes for: " + session.getUserId());
        }
        Element presInit = (Element)session.getSessionData("user-presence");
        Element presProbe = new Element(PRESENCE_ELEMENT_NAME);
        presProbe.setXMLNS(XMLNS);
        presProbe.setAttribute("type", StanzaType.probe.toString());
        presProbe.setAttribute("from", session.getUserId());
        String[] buddies = roster_util.getBuddies(session, RosterAbstract.SUB_BOTH);
        buddies = DynamicRoster.addBuddies(session, settings, buddies);
        if (buddies != null) {
            for (String buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending probe and intial to: " + buddy);
                }
                Presence.sendPresence(null, buddy, null, results, presProbe);
                Presence.sendPresence(null, buddy, null, results, presInit);
            }
        }
        if ((buddies_to = roster_util.getBuddies(session, RosterAbstract.SUB_TO)) != null) {
            for (String buddy : buddies_to) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending probe to: " + buddy);
                }
                Presence.sendPresence(null, buddy, null, results, presProbe);
            }
        }
        if ((buddies_from = roster_util.getBuddies(session, RosterAbstract.SUB_FROM)) != null) {
            for (String buddy : buddies_from) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending initial to: " + buddy);
                }
                Presence.sendPresence(null, buddy, null, results, presInit);
            }
        }
    }

    protected static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<RosterAbstract.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        String[] buddies = roster_util.getBuddies(session, subscrs);
        if ((buddies = DynamicRoster.addBuddies(session, settings, buddies)) != null) {
            for (String buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                Presence.sendPresence(t, buddy, null, results, pres);
            }
        }
        Presence.broadcastDirectPresences(t, session, results, pres);
    }

    protected static void broadcastDirectPresences(StanzaType t, XMPPResourceConnection session, Queue<Packet> results, Element pres) throws NotAuthorizedException, TigaseDBException {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null && t != null && t == StanzaType.unavailable) {
            for (String buddy : direct_presences) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Updating direct presence for: " + buddy);
                }
                Presence.sendPresence(t, buddy, session.getJID(), results, pres);
            }
        }
    }

    protected static void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        String[] buddies = roster_util.getBuddies(session, RosterAbstract.PENDING_IN);
        if (buddies != null) {
            for (String buddy : buddies) {
                Element presence = new Element(PRESENCE_ELEMENT_NAME);
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setAttribute("from", buddy);
                presence.setXMLNS(XMLNS);
                Presence.updatePresenceChange(presence, session, results);
            }
        }
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn.getJID());
                }
                if (conn != session && conn.getResource() != null && !conn.getResource().equals(session.getResource())) {
                    Element pres_update = new Element(PRESENCE_ELEMENT_NAME);
                    pres_update.setAttribute("from", session.getJID());
                    pres_update.setAttribute("to", conn.getUserId());
                    pres_update.setAttribute("type", StanzaType.unavailable.toString());
                    pres_update.setXMLNS(XMLNS);
                    Packet pack_update = new Packet(pres_update);
                    pack_update.setTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    protected static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn.getJID());
                }
                if (conn != session && conn.isResourceSet()) {
                    Element pres_update = presence.clone();
                    pres_update.setAttribute("from", session.getJID());
                    pres_update.setAttribute("to", conn.getUserId());
                    Packet pack_update = new Packet(pres_update);
                    pack_update.setTo(conn.getConnectionId());
                    results.offer(pack_update);
                    Element presence_el = (Element)conn.getSessionData("user-presence");
                    if (presence_el == null) continue;
                    pres_update = presence_el.clone();
                    pres_update.setAttribute("to", session.getUserId());
                    pres_update.setAttribute("from", conn.getJID());
                    pack_update = new Packet(pres_update);
                    pack_update.setTo(session.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    protected static void updatePresenceChange(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean initial_p = presence.getAttribute("type") == null || "available".equals(presence.getAttribute("type")) || "unavailable".equals(presence.getAttribute("type"));
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (conn.getSessionData("user-presence") != null || !initial_p) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Update presence change to: " + conn.getUserId());
                    }
                    Element pres_update = presence.clone();
                    pres_update.setAttribute("to", conn.getUserId());
                    Packet pack_update = new Packet(pres_update);
                    pack_update.setTo(conn.getConnectionId());
                    results.offer(pack_update);
                }
                catch (Exception e) {}
                continue;
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.finest("Skipping update presence change for a resource which hasn't sent initial presence yet.");
        }
    }

    protected static void forwardPresence(Queue<Packet> results, Packet packet, String from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("\n\nFORWARD presence: " + result.toString());
        }
        results.offer(new Packet(result));
    }

    protected static void sendPresence(StanzaType t, String to, String from, Queue<Packet> results, Element pres) {
        Element presence = null;
        if (pres == null) {
            presence = new Element(PRESENCE_ELEMENT_NAME);
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
            presence.setAttribute("from", from);
            presence.setXMLNS(XMLNS);
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to);
        String[] connIds = runtime.getConnectionIdsForJid(to);
        if (connIds != null && connIds.length > 0) {
            for (String connId : connIds) {
                Packet packet = new Packet(presence);
                packet.setTo(connId);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending presence info: " + packet.getStringData());
                }
                results.offer(packet);
            }
        } else {
            Packet packet = new Packet(presence);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending presence info: " + packet.getStringData());
            }
            results.offer(packet);
        }
    }

    protected static void addDirectPresenceJID(String jid, XMPPResourceConnection session) {
        HashSet<String> direct_presences = (HashSet<String>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new HashSet<String>();
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        direct_presences.add(jid);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Added direct presence jid: " + jid);
        }
    }

    protected static void removeDirectPresenceJID(String jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Added direct presence jid: " + jid);
        }
    }

    protected static void outInitialAnonymous(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Anonymous session: " + session.getUserId());
        }
        String peer = JIDUtils.getNodeID((String)packet.getElemTo());
        String nick = packet.getElemCData("/presence/nick");
        if (nick == null) {
            nick = session.getUserName();
        }
        Packet rost_update = new Packet(JabberIqRoster.createRosterPacket("set", session.nextStanzaId(), peer, peer, session.getUserId(), nick, new String[]{"Anonymous peers"}, null, "anon"));
        results.offer(rost_update);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending roster update: " + rost_update.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                String jid = session.getJID();
                RosterAbstract.PresenceType pres_type = roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.warning("Invalid presence found: " + packet.toString());
                    return;
                }
                StanzaType type = packet.getType();
                if (type == null) {
                    type = StanzaType.available;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest((Object)((Object)pres_type) + " presence found: " + packet.toString());
                }
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getElemFrom() == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet.toString());
                            }
                            return;
                        }
                        if (!JIDUtils.getNodeID((String)packet.getElemFrom()).equals(session.getUserId())) break;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("'in' subscription to myself, not allowed, returning error for packet: " + packet.toString());
                        }
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                        return;
                    }
                }
                boolean subscr_changed = false;
                switch (pres_type) {
                    case out_initial: {
                        if (packet.getElemTo() != null) {
                            if (session.isAnonymous()) {
                                Presence.outInitialAnonymous(packet, session, results);
                            }
                            Element result = packet.getElement().clone();
                            results.offer(new Packet(result));
                            if (packet.getType() != null && packet.getType() == StanzaType.unavailable) {
                                Presence.removeDirectPresenceJID(packet.getElemTo(), session);
                                break;
                            }
                            Presence.addDirectPresenceJID(packet.getElemTo(), session);
                            break;
                        }
                        boolean first = false;
                        if (session.getSessionData("user-presence") == null) {
                            first = true;
                        }
                        packet.getElement().setAttribute("from", jid);
                        session.setPresence(packet.getElement());
                        if (type == StanzaType.available) {
                            if (first) {
                                Presence.broadcastProbe(session, results, settings);
                                Presence.resendPendingInRequests(session, results);
                            } else {
                                Presence.sendPresenceBroadcast(type, session, RosterAbstract.FROM_SUBSCRIBED, results, packet.getElement(), settings);
                            }
                        }
                        Presence.updateUserResources(packet.getElement(), session, results);
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: {
                        RosterAbstract.SubscriptionType current_subscription;
                        Presence.forwardPresence(results, packet, session.getUserId());
                        if (pres_type == RosterAbstract.PresenceType.out_subscribe && (current_subscription = roster_util.getBuddySubscription(session, packet.getElemTo())) == null) {
                            roster_util.addBuddy(session, packet.getElemTo(), null, null);
                        }
                        if (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getElemTo())) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getElemTo()));
                        }
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        Presence.forwardPresence(results, packet, session.getUserId());
                        String buddy = JIDUtils.getNodeID((String)packet.getElemTo());
                        subscr_changed = roster_util.updateBuddySubscription(session, pres_type, buddy);
                        if (subscr_changed) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, buddy));
                            if (pres_type == RosterAbstract.PresenceType.out_subscribed) {
                                Element presence = (Element)session.getSessionData("user-presence");
                                Presence.sendPresence(StanzaType.available, buddy, null, results, presence);
                                break;
                            }
                            Presence.sendPresence(StanzaType.unavailable, buddy, session.getJID(), results, null);
                        }
                        break;
                    }
                    case in_initial: {
                        if (packet.getElemFrom() == null) {
                            log.warning("Initial presence without from attribute set: " + packet.toString());
                            return;
                        }
                        String resource = JIDUtils.getNodeResource((String)packet.getElemTo());
                        if (resource != null && !resource.isEmpty()) {
                            XMPPResourceConnection direct = session.getParentSession().getResourceForResource(resource);
                            if (direct != null) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Received direct presence from: " + packet.getElemFrom() + " to: " + packet.getElemTo());
                                }
                                Element elem = packet.getElement().clone();
                                Packet result = new Packet(elem);
                                result.setTo(direct.getConnectionId());
                                result.setFrom(packet.getTo());
                                results.offer(result);
                                break;
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Ignoring direct presence from: " + packet.getElemFrom() + " to: " + packet.getElemTo() + ", resource gone.");
                            }
                        } else {
                            String presBuddy = JIDUtils.getNodeID((String)packet.getElemFrom());
                            if (roster_util.isSubscribedTo(session, presBuddy) || DynamicRoster.getBuddyItem(session, settings, presBuddy) != null) {
                                boolean online;
                                boolean bl = online = StanzaType.unavailable != packet.getType();
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Received initial presence, setting buddy: " + packet.getElemFrom() + " online status to: " + online);
                                }
                                Presence.updatePresenceChange(packet.getElement(), session, results);
                            }
                        }
                        break;
                    }
                    case in_subscribe: {
                        if (roster_util.isSubscribedFrom(session, packet.getElemFrom())) {
                            Presence.sendPresence(StanzaType.subscribed, JIDUtils.getNodeID((String)packet.getElemFrom()), session.getUserId(), results, null);
                            break;
                        }
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub == null) {
                            curr_sub = RosterAbstract.SubscriptionType.none;
                            roster_util.addBuddy(session, packet.getElemFrom(), null, null);
                        }
                        roster_util.updateBuddySubscription(session, pres_type, packet.getElemFrom());
                        Presence.updatePresenceChange(packet.getElement(), session, results);
                        break;
                    }
                    case in_unsubscribe: {
                        subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getElemFrom());
                        if (subscr_changed) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_subscribed: {
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub == null) {
                            curr_sub = RosterAbstract.SubscriptionType.none;
                            roster_util.addBuddy(session, packet.getElemFrom(), null, null);
                        }
                        if (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getElemFrom())) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_unsubscribed: {
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getElemFrom());
                        if (curr_sub != null && (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getElemFrom()))) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getElemFrom()));
                        }
                        break;
                    }
                    case in_probe: {
                        if (session.getPresence() == null) {
                            return;
                        }
                        RosterAbstract.SubscriptionType buddy_subscr = null;
                        buddy_subscr = DynamicRoster.getBuddyItem(session, settings, packet.getElemFrom()) != null ? RosterAbstract.SubscriptionType.both : roster_util.getBuddySubscription(session, packet.getElemFrom());
                        if (buddy_subscr == null) {
                            buddy_subscr = RosterAbstract.SubscriptionType.none;
                        }
                        switch (buddy_subscr) {
                            case none: 
                            case none_pending_out: 
                            case to: {
                                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, "Presence information is forbidden.", false));
                                break;
                            }
                            case none_pending_in: 
                            case none_pending_out_in: 
                            case to_pending_in: {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to get presence information.", false));
                                break;
                            }
                        }
                        if (roster_util.isSubscribedFrom(buddy_subscr)) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Received probe, setting buddy: " + packet.getElemFrom() + " as online.");
                            }
                            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                                try {
                                    Element pres = (Element)conn.getSessionData("user-presence");
                                    if (pres == null) continue;
                                    Presence.sendPresence(null, JIDUtils.getNodeID((String)packet.getElemFrom()), null, results, pres);
                                    if (!log.isLoggable(Level.FINEST)) continue;
                                    log.finest("Received probe, sending presence response to: " + packet.getElemFrom());
                                }
                                catch (Exception e) {}
                            }
                        }
                        break;
                    }
                    case error: {
                        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
                        if (direct_presences != null && direct_presences.contains(packet.getElemFrom())) {
                            Element elem = packet.getElement().clone();
                            Packet result = new Packet(elem);
                            result.setTo(session.getConnectionId());
                            result.setFrom(packet.getTo());
                            results.offer(result);
                        }
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.info("Can not access user Roster, user session is not authorized yet: " + packet.getStringData());
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (TigaseDBException e) {
                log.warning("Error accessing database for presence data: " + e);
            }
        }
    }
}

