/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public class PepPlugin
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String _XMLNS = "http://jabber.org/protocol/pubsub";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#owner"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#publish"}), new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "pep"})};
    private static final String[] ELEMENTS = new String[]{"pubsub"};
    private static final String ID = "pep";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.PepPlugin");
    private static final String PUBSUB_COMPONENT_URL = "pubsub-component";
    private static RosterAbstract roster = RosterFactory.getRosterImplementation(true);
    private static final EnumSet<RosterAbstract.SubscriptionType> SUBSCRITION_TYPES = EnumSet.of(RosterAbstract.SubscriptionType.both, RosterAbstract.SubscriptionType.from);
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/pubsub"};
    private final HashSet<String> supportedNodes = new HashSet();

    public PepPlugin() {
        this.supportedNodes.add("http://jabber.org/protocol/tune");
        this.supportedNodes.add("http://jabber.org/protocol/mood");
        this.supportedNodes.add("http://jabber.org/protocol/activity");
        this.supportedNodes.add("http://jabber.org/protocol/geoloc");
    }

    private void forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        String pubSubComponentUrl;
        String string = pubSubComponentUrl = settings == null ? null : (String)settings.get(PUBSUB_COMPONENT_URL);
        if (session == null || pubSubComponentUrl == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Packet reject. No Session or PubSub Component URL.");
            }
            return;
        }
        try {
            packet.getElement().setAttribute("to", pubSubComponentUrl);
            String id = JIDUtils.getNodeID((String)packet.getElemTo());
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId());
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            block16: {
                try {
                    results.offer(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true));
                }
                catch (PacketErrorTypeException e) {
                    if (!log.isLoggable(Level.FINE)) break block16;
                    log.fine("This is already error packet, ignoring... " + packet.toString());
                }
            }
            return;
        }
        try {
            String id = session.getDomain();
            if (packet.getElemTo() != null) {
                id = JIDUtils.getNodeID((String)packet.getElemTo());
            }
            if (id == null || id.equals("") || id.equalsIgnoreCase(session.getDomain()) || session.getConnectionId() == "NULL") {
                List<Element> x = packet.getElemChildren("/iq/pubsub");
                boolean processed = false;
                for (Element element : x) {
                    String action = element.getName();
                    String node = element.getAttribute("node");
                    if (!this.supportedNodes.contains(node)) continue;
                    if (action == "retract") {
                        Element item = element.getChild("item", null);
                        Element retract = new Element("retract");
                        if (item.getAttribute("id") != null) {
                            retract.addAttribute("id", item.getAttribute("id"));
                        }
                        processed = true;
                        this.processPEPPublish(packet, node, retract, session, repo, results, settings);
                        break;
                    }
                    if (action != "publish") continue;
                    Element item = element.getChild("item", null);
                    processed = true;
                    this.processPEPPublish(packet, node, item, session, repo, results, settings);
                    break;
                }
                if (!processed) {
                    this.forward(packet, session, repo, results, settings);
                } else {
                    results.offer(packet.okResult((Element)null, 0));
                }
                return;
            }
            if (packet.getElemTo() == null) {
                this.forward(packet, session, repo, results, settings);
                return;
            }
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
        }
        catch (TigaseDBException e) {
            log.warning("TigaseDBException for packet: " + packet.getStringData());
        }
    }

    private void processPEPPublish(Packet packet, String node, Element pepItem, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        String[] buddies = roster.getBuddies(session, SUBSCRITION_TYPES);
        Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
        Element items = new Element("items", new String[]{"node"}, new String[]{node});
        event.addChild((XMLNodeIfc)items);
        items.addChild((XMLNodeIfc)pepItem);
        String from = JIDUtils.getNodeID((String)packet.getElemFrom());
        for (String buddy : buddies) {
            Element message = new Element("message", new String[]{"from", "to", "type", "id"}, new String[]{from, buddy, "headline", packet.getElemId()});
            message.addChild((XMLNodeIfc)event);
            results.offer(new Packet(message));
        }
        Element message = new Element("message", new String[]{"from", "to", "type", "id"}, new String[]{from, packet.getElemFrom(), "headline", packet.getElemId()});
        message.addChild((XMLNodeIfc)event);
        results.offer(new Packet(message));
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

