/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class Message
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(Message.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String ID = "message";
    private static final String[] ELEMENTS = new String[]{"message"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (session == null) {
            return;
        }
        try {
            String id = JIDUtils.getNodeID((String)packet.getElemTo());
            if (session.getUserId().equals(id)) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
                return;
            }
            id = JIDUtils.getNodeID((String)packet.getElemFrom());
            if (session.getUserId().equals(id)) {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
                return;
            }
            id = packet.getFrom();
            if (session.getConnectionId().equals(id)) {
                Element result = packet.getElement().clone();
                result.setAttribute("from", session.getJID());
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }
}

