/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public abstract class JabberIqRoster {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqRoster");
    protected static final String XMLNS = "jabber:iq:roster";
    protected static final String XMLNS_DYNAMIC = "jabber:iq:roster-dynamic";
    private static final String[] ELEMENTS = new String[]{"query", "query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:roster", "jabber:iq:roster-dynamic"};
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster"}), new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster-dynamic"})};
    protected static final Element[] FEATURES = new Element[]{new Element("ver", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:rosterver"})};
    public static final String ANON = "anon";
    private static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);

    public static Element createRosterPacket(String iq_type, String iq_id, String to, String from, String item_jid, String item_name, String[] item_groups, String subscription, String item_type) {
        Element iq = new Element("iq", new String[]{"type", "id"}, new String[]{iq_type, iq_id});
        if (from != null) {
            iq.addAttribute("from", from);
        }
        if (to != null) {
            iq.addAttribute("to", to);
        }
        Element query = new Element("query");
        query.setXMLNS(XMLNS);
        iq.addChild((XMLNodeIfc)query);
        Element item = new Element("item", new String[]{"jid"}, new String[]{item_jid});
        if (item_type != null) {
            item.addAttribute("type", item_type);
        }
        if (item_name != null) {
            item.addAttribute("name", item_name);
        }
        if (subscription != null) {
            item.addAttribute("subscription", subscription);
        }
        if (item_groups != null) {
            for (String gr : item_groups) {
                Element group = new Element("group", gr);
                item.addChild((XMLNodeIfc)group);
            }
        }
        query.addChild((XMLNodeIfc)item);
        return iq;
    }

    public static String[] getItemGroups(Element item) {
        List elgr = item.getChildren();
        if (elgr != null && elgr.size() > 0) {
            ArrayList<String> groups = new ArrayList<String>();
            for (Element grp : elgr) {
                if (grp.getName() != "group") continue;
                groups.add(grp.getCData());
            }
            if (groups.size() > 0) {
                return groups.toArray(new String[groups.size()]);
            }
        }
        return null;
    }

    private static void dynamicGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        Element request = packet.getElement();
        Element item = request.findChild("/iq/query/item");
        if (item != null) {
            Element new_item = DynamicRoster.getItemExtraData(session, settings, item);
            if (new_item == null) {
                new_item = item;
            }
            results.offer(packet.okResult(new_item, 1));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    private static void dynamicSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        Element request = packet.getElement();
        List items = request.getChildren("/iq/query");
        if (items != null && items.size() > 0) {
            for (Element item : items) {
                DynamicRoster.setItemExtraData(session, settings, item);
            }
            results.offer(packet.okResult((String)null, 0));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    private static void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        Element request = packet.getElement();
        Element item = request.findChild("/iq/query/item");
        String buddy = JIDUtils.getNodeID((String)item.getAttribute("jid"));
        String subscription = item.getAttribute("subscription");
        if (subscription != null && subscription.equals("remove")) {
            RosterAbstract.SubscriptionType sub = roster_util.getBuddySubscription(session, buddy);
            if (sub == null) {
                sub = RosterAbstract.SubscriptionType.none;
            }
            String type = request.getAttribute("/iq/query/item", "type");
            if (!(sub == RosterAbstract.SubscriptionType.none || type != null && type.equals(ANON))) {
                Element pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getJID());
                pres.setAttribute("type", "unavailable");
                Packet pres_packet = new Packet(pres);
                pres_packet.setPriority(Priority.HIGH);
                results.offer(pres_packet);
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribe");
                results.offer(new Packet(pres));
                pres = new Element("presence");
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getUserId());
                pres.setAttribute("type", "unsubscribed");
                results.offer(new Packet(pres));
            }
            Element it = new Element("item");
            it.setAttribute("jid", buddy);
            it.setAttribute("subscription", "remove");
            roster_util.updateBuddyChange(session, results, it);
            roster_util.removeBuddy(session, buddy);
            results.offer(packet.okResult((String)null, 0));
        } else {
            Element dynamicItem = DynamicRoster.getBuddyItem(session, settings, buddy);
            String name = request.getAttribute("/iq/query/item", "name");
            List groups = item.getChildren();
            String[] gr = null;
            if (groups != null && groups.size() > 0) {
                gr = new String[groups.size()];
                int cnt = 0;
                for (Element group : groups) {
                    gr[cnt++] = group.getCData() == null ? "" : group.getCData();
                }
            }
            roster_util.addBuddy(session, buddy, name, gr);
            String type = request.getAttribute("/iq/query/item", "type");
            if (type != null && type.equals(ANON)) {
                roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy);
                Element pres = (Element)session.getSessionData("user-presence");
                pres = pres == null ? new Element("presence") : pres.clone();
                pres.setAttribute("to", buddy);
                pres.setAttribute("from", session.getJID());
                results.offer(new Packet(pres));
            }
            Element new_buddy = roster_util.getBuddyItem(session, buddy);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("1. New Buddy: " + new_buddy.toString());
            }
            if (roster_util.getBuddySubscription(session, buddy) == null) {
                roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.none, buddy);
            }
            if (dynamicItem != null) {
                roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy);
                String[] itemGroups = JabberIqRoster.getItemGroups(dynamicItem);
                if (itemGroups != null) {
                    roster_util.addBuddyGroup(session, buddy, itemGroups);
                }
            }
            new_buddy = roster_util.getBuddyItem(session, buddy);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("2. New Buddy: " + new_buddy.toString());
            }
            results.offer(packet.okResult((String)null, 0));
            roster_util.updateBuddyChange(session, results, new_buddy);
        }
    }

    private static void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        String incomingHash = packet.getElement().getAttribute("/iq/query", "ver");
        String storedHash = "";
        List<Element> its = DynamicRoster.getRosterItems(session, settings);
        if (its != null && its.size() > 0) {
            Iterator<Element> it = its.iterator();
            while (it.hasNext()) {
                Element element = it.next();
                String jid = element.getAttribute("jid");
                if (!roster_util.containsBuddy(session, jid)) continue;
                roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, jid);
                String[] itemGroups = JabberIqRoster.getItemGroups(element);
                if (itemGroups != null) {
                    roster_util.addBuddyGroup(session, jid, itemGroups);
                }
                it.remove();
            }
        }
        if (incomingHash != null && incomingHash.equals(storedHash = roster_util.getBuddiesHash(session))) {
            results.offer(packet.okResult((String)null, 0));
            return;
        }
        List<Element> ritems = roster_util.getRosterItems(session);
        if (ritems != null && ritems.size() > 0) {
            Element query = new Element("query");
            query.setXMLNS(XMLNS);
            if (incomingHash != null) {
                query.setAttribute("ver", storedHash);
            }
            query.addChildren(ritems);
            results.offer(packet.okResult(query, 0));
        } else {
            results.offer(packet.okResult((String)null, 1));
        }
        if (its != null && its.size() > 0) {
            LinkedList<Element> items = new LinkedList<Element>(its);
            while (items.size() > 0) {
                Element iq = new Element("iq", new String[]{"type", "id", "to"}, new String[]{"set", "dr-" + items.size(), session.getJID()});
                Element query = new Element("query");
                query.setXMLNS(XMLNS);
                iq.addChild((XMLNodeIfc)query);
                query.addChild((XMLNodeIfc)items.poll());
                while (query.getChildren().size() < 20 && items.size() > 0) {
                    query.addChild((XMLNodeIfc)items.poll());
                }
                Packet rost_res = new Packet(iq);
                rost_res.setTo(session.getConnectionId());
                rost_res.setFrom(packet.getTo());
                results.offer(rost_res);
            }
        }
    }

    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        try {
            if (packet.getElemFrom() != null && !session.getUserId().equals(JIDUtils.getNodeID((String)packet.getElemFrom()))) {
                log.warning("Roster request 'from' attribute doesn't match session userid: " + session.getUserId() + ", request: " + packet.getStringData());
                return;
            }
            StanzaType type = packet.getType();
            String xmlns = packet.getElement().getXMLNS("/iq/query");
            if (xmlns == XMLNS) {
                switch (type) {
                    case get: {
                        JabberIqRoster.processGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        JabberIqRoster.processSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else if (xmlns == XMLNS_DYNAMIC) {
                switch (type) {
                    case get: {
                        JabberIqRoster.dynamicGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        JabberIqRoster.dynamicSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else {
                log.warning("Unknown XMLNS for the roster plugin: " + packet.toString());
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received roster request but user session is not authorized yet: " + packet.getStringData());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.warning("Database problem, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    public static void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
    }
}

