/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.JIDUtils;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class XMPPSession {
    private static Logger log = Logger.getLogger("tigase.xmpp.XMPPSession");
    private String username = null;
    private CopyOnWriteArrayList<XMPPResourceConnection> activeResources = null;
    private long creationTime = 0L;
    private Map<String, Object> sessionData = new ConcurrentHashMap<String, Object>();

    public XMPPSession(String username) {
        this.activeResources = new CopyOnWriteArrayList();
        this.username = username;
        this.creationTime = System.currentTimeMillis();
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public void streamClosed(XMPPResourceConnection conn) {
        this.removeResourceConnection(conn);
    }

    public String getUserName() {
        return this.username;
    }

    public List<XMPPResourceConnection> getActiveResources() {
        return (List)this.activeResources.clone();
    }

    public int getActiveResourcesSize() {
        return this.activeResources.size();
    }

    public int getResSizeForConnStatus(ConnectionStatus status) {
        int result = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            if (conn.getConnectionStatus() != status) continue;
            ++result;
        }
        return result;
    }

    public void addResourceConnection(XMPPResourceConnection conn) {
        XMPPResourceConnection old_res;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding resource connection for username : " + this.username + ", id: " + conn.getConnectionId());
        }
        if ((old_res = this.getResourceForResource(conn.getResource())) != conn) {
            if (old_res != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found old resource connection, id: " + old_res.getConnectionId());
                }
                try {
                    old_res.logout();
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception during closing old connection, ignoring.", e);
                }
                this.removeResourceConnection(old_res);
            }
            if ((old_res = this.getResourceForConnectionId(conn.getConnectionId())) == null) {
                this.activeResources.add(conn);
                conn.setParentSession(this);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Number of active resources is: " + this.activeResources.size());
                if (this.activeResources.size() > 1) {
                    int i = 0;
                    for (XMPPResourceConnection res : this.activeResources) {
                        log.finest("RES " + ++i + ": " + res.getResource() + ", " + res.getConnectionId());
                    }
                }
            }
        }
    }

    public void removeResourceConnection(XMPPResourceConnection conn) {
        this.activeResources.remove(conn);
        conn.setParentSession(null);
    }

    public String[] getJIDs() throws NotAuthorizedException {
        String[] result = new String[this.activeResources.size()];
        int idx = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            result[idx++] = conn.getJID();
        }
        return result;
    }

    public String[] getConnectionIds() {
        String[] result = new String[this.activeResources.size()];
        int idx = 0;
        for (XMPPResourceConnection conn : this.activeResources) {
            result[idx++] = conn.getConnectionId();
        }
        return result;
    }

    public XMPPResourceConnection getResourceForResource(String resource) {
        if (resource != null && resource.length() > 0) {
            for (XMPPResourceConnection conn : this.activeResources) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Resource checking: " + conn.getResource() + ", connectionID: " + conn.getConnectionId());
                }
                if (!resource.equalsIgnoreCase(conn.getResource())) continue;
                return conn;
            }
        }
        return null;
    }

    public XMPPResourceConnection getResourceForConnectionId(String connectionId) {
        for (XMPPResourceConnection conn : this.activeResources) {
            if (!connectionId.equals(conn.getConnectionId())) continue;
            return conn;
        }
        return null;
    }

    public XMPPResourceConnection getOldestConnection() {
        if (this.activeResources.size() > 0) {
            XMPPResourceConnection result = this.activeResources.get(0);
            for (XMPPResourceConnection conn : this.activeResources) {
                if (result.getCreationTime() <= conn.getCreationTime()) continue;
                result = conn;
            }
            return result;
        }
        log.info("XMPPSession with no connections for user: " + this.username);
        return null;
    }

    public XMPPResourceConnection getResourceForJID(String jid) {
        String resource = JIDUtils.getNodeResource((String)jid);
        return this.getResourceForResource(resource);
    }

    public synchronized XMPPResourceConnection getResourceConnection(String jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Called for: " + jid);
        }
        if (this.activeResources.size() == 0) {
            return null;
        }
        if (this.activeResources.size() == 1) {
            XMPPResourceConnection result = this.activeResources.get(0);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Only 1 active resource: " + result.getResource());
            }
            return result;
        }
        XMPPResourceConnection conn = this.getResourceForJID(jid);
        if (conn != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Number of resources: " + this.activeResources.size() + ", got resource for jid: " + jid);
            }
            return conn;
        }
        ArrayList<XMPPResourceConnection> al = new ArrayList<XMPPResourceConnection>();
        int highest_priority = 0;
        for (XMPPResourceConnection conn_tmp : this.activeResources) {
            if (!conn_tmp.isAuthorized()) {
                log.info("Old XMPP connection which is not authorized anymore, removing..." + conn_tmp.getConnectionId());
                this.activeResources.remove(conn_tmp);
            }
            if (conn_tmp.getPriority() == highest_priority) {
                al.add(conn_tmp);
                continue;
            }
            if (conn_tmp.getPriority() <= highest_priority) continue;
            al.clear();
            al.add(conn_tmp);
            highest_priority = conn_tmp.getPriority();
        }
        if (al.size() == 1) {
            return (XMPPResourceConnection)al.get(0);
        }
        XMPPResourceConnection conn_last = (XMPPResourceConnection)al.get(0);
        long time = conn_last.getLastAccessed();
        for (int i = 1; i < al.size(); ++i) {
            if (((XMPPResourceConnection)al.get(i)).getLastAccessed() <= time) continue;
            conn_last = (XMPPResourceConnection)al.get(i);
            time = conn_last.getLastAccessed();
        }
        return conn_last;
    }

    public Object getCommonSessionData(String key) {
        return this.sessionData.get(key);
    }

    protected void putCommonSessionData(String key, Object value) {
        this.sessionData.put(key, value);
    }

    protected Object removeCommonSessionData(String key) {
        return this.sessionData.remove(key);
    }
}

