/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.RepositoryAccess;
import tigase.xmpp.XMPPSession;

public class XMPPResourceConnection
extends RepositoryAccess {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPResourceConnection");
    public static final String PRESENCE_KEY = "user-presence";
    private SessionManagerHandler loginHandler = null;
    private XMPPSession parentSession = null;
    private String sessionId = null;
    private String defLang = "en";
    private String resource = null;
    private long lastAccessed = 0L;
    private long creationTime = 0L;
    private long authenticationTime = 0L;
    private String connectionId = null;
    private int priority = 0;
    private String userJid = null;
    private String userId = null;
    private long id_counter = 0L;
    private ConnectionStatus connectionStatus = ConnectionStatus.INIT;
    private Map<String, Object> sessionData = null;

    public XMPPResourceConnection(String connectionId, UserRepository rep, UserAuthRepository authRepo, SessionManagerHandler loginHandler) {
        super(rep, authRepo);
        long currTime = System.currentTimeMillis();
        this.connectionId = connectionId;
        this.loginHandler = loginHandler;
        this.creationTime = currTime;
        this.lastAccessed = currTime;
        this.sessionData = new ConcurrentHashMap<String, Object>(4, 0.9f);
    }

    public boolean isLocalDomain(String outDomain, boolean includeComponents) {
        return this.loginHandler.isLocalDomain(outDomain, includeComponents);
    }

    public void putCommonSessionData(String key, Object value) {
        if (this.parentSession != null) {
            this.parentSession.putCommonSessionData(key, value);
        }
    }

    public Object getCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.getCommonSessionData(key);
    }

    public Object removeCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.removeCommonSessionData(key);
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public final void putSessionData(String key, Object value) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.put(key, value);
    }

    public final Object getSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        return this.sessionData.get(key);
    }

    public final void removeSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.remove(key);
    }

    public void setPresence(Element packet) {
        this.putSessionData(PRESENCE_KEY, packet);
        String pr_str = packet.getCData("/presence/priority");
        if (pr_str != null) {
            int pr = 1;
            try {
                pr = Integer.decode(pr_str);
            }
            catch (NumberFormatException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Incorrect priority value: " + pr_str + ", setting 1 as default.");
                }
                pr = 1;
            }
            this.setPriority(pr);
        }
        this.loginHandler.handlePresenceSet(this);
    }

    public Element getPresence() {
        return (Element)this.getSessionData(PRESENCE_KEY);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public XMPPSession getParentSession() {
        return this.parentSession;
    }

    public final String getJID() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid;
    }

    public final String getjid() {
        return this.userJid;
    }

    @Override
    public final String getUserId() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userId;
    }

    @Override
    public final String getUserName() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getUserName();
    }

    public List<XMPPResourceConnection> getActiveSessions() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getActiveResources();
    }

    public String[] getAllResourcesJIDs() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getJIDs();
    }

    @Override
    public boolean isAuthorized() {
        return super.isAuthorized() && this.parentSession != null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String argSessionId) {
        this.sessionId = argSessionId;
    }

    public String getDefLang() {
        return this.defLang;
    }

    public void setDefLang(String lang) {
        this.defLang = lang;
    }

    public boolean isResourceSet() {
        return this.resource != null;
    }

    public String getResource() {
        return this.resource;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long argLastAccessed) {
        this.lastAccessed = argLastAccessed;
    }

    public String getConnectionId() {
        this.lastAccessed = System.currentTimeMillis();
        return this.connectionId;
    }

    public String getConnectionId(String jid) {
        return this.parentSession == null || jid == null ? this.connectionId : this.parentSession.getResourceConnection(jid).getConnectionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed() {
        if (this.parentSession != null) {
            XMPPResourceConnection xMPPResourceConnection = this;
            synchronized (xMPPResourceConnection) {
                this.parentSession.streamClosed(this);
            }
        }
        this.parentSession = null;
        this.resource = null;
        this.sessionId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentSession(XMPPSession parent) {
        if (parent != null) {
            XMPPResourceConnection xMPPResourceConnection = this;
            synchronized (xMPPResourceConnection) {
                this.userId = JIDUtils.getNodeID((String)parent.getUserName(), (String)this.domain.getVhost());
                this.userJid = this.userId + (this.resource != null ? "/" + this.resource : "/" + this.sessionId);
            }
        }
        this.parentSession = parent;
    }

    public void setResource(String argResource) throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        this.resource = argResource;
        if (this.parentSession != null) {
            this.parentSession.addResourceConnection(this);
        }
        this.userJid = this.getUserId() + (this.resource != null ? "/" + this.resource : "/" + this.sessionId);
        this.loginHandler.handleResourceBind(this);
    }

    public synchronized void setConnectionStatus(ConnectionStatus status) {
        this.connectionStatus = status;
    }

    @Override
    public final void logout() throws NotAuthorizedException {
        this.loginHandler.handleLogout(this.getUserName(), this);
        this.streamClosed();
        super.logout();
    }

    @Override
    public final Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginPlain(user, password);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginDigest(user, digest, id, alg);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginOther(props);
        if (result == Authorization.AUTHORIZED) {
            String nick;
            String user = (String)props.get("user-id");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("UserAuthRepository.USER_ID_KEY: " + user);
            }
            if ((nick = JIDUtils.getNodeNick((String)user)) == null) {
                nick = user;
            }
            this.loginHandler.handleLogin(nick, this);
        }
        return result;
    }

    @Override
    protected void login() {
        this.authenticationTime = System.currentTimeMillis();
    }

    public long getAuthTime() {
        return this.authenticationTime - this.creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Authorization unregister(String name_param) throws NotAuthorizedException, TigaseDBException {
        Authorization auth_res = super.unregister(name_param);
        return auth_res;
    }

    public String nextStanzaId() {
        return "tig" + ++this.id_counter;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        super.queryAuth(authProps);
    }

    public String toString() {
        return "user_jid=" + this.userJid + ", connectioId=" + this.connectionId;
    }
}

