/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;

public class XMPPIOService
extends IOService {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPIOService");
    private XMPPDomBuilderHandler domHandler = null;
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    private XMPPIOServiceListener serviceListener = null;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();
    private String xmlns = null;

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
    }

    public void setXMLNS(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public void setIOServiceListener(XMPPIOServiceListener sl) {
        this.serviceListener = sl;
        super.setIOServiceListener(sl);
    }

    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            String response = this.serviceListener.streamOpened(this, attribs);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending data: " + response);
                }
                this.writeRawData(response);
                if (response != null && response.endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.warning("Error sending stream open data: " + e);
                this.forceStop();
            }
        }
    }

    public void xmppStreamOpen(String data) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending data: " + data);
            }
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.warning("Error sending stream open data: " + e);
            this.forceStop();
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    protected void xmppStreamClosed() {
        if (this.serviceListener != null) {
            this.serviceListener.streamClosed(this);
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending data: </stream:stream>");
            }
            this.writeRawData("</stream:stream>");
        }
        catch (IOException e) {
            log.warning("Error sending stream closed data: " + e);
        }
    }

    public void addPacketToSend(Packet packet) {
        this.waitingPackets.offer(packet);
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending packet: " + packet.toString());
            }
            this.writeRawData(packet.getStringData());
            if (!log.isLoggable(Level.FINEST)) continue;
            log.finest("SENT: " + packet.getStringData());
        }
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    @Override
    protected void processSocketData() throws IOException {
        if (this.isConnected()) {
            char[] data = this.readData();
            while (data != null && data.length > 0) {
                if (this.isConnected()) {
                    if (data != null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("READ:\n" + new String(data));
                        }
                        assert (this.debug(new String(data), "--RECEIVED:"));
                        try {
                            Queue<Element> elems;
                            this.parser.parse((SimpleHandler)this.domHandler, data, 0, data.length);
                            if (this.domHandler.parseError()) {
                                log.warning("Data parsing error: " + new String(data));
                                this.domHandler = new XMPPDomBuilderHandler(this);
                            }
                            if ((elems = this.domHandler.getParsedElements()).size() > 0) {
                                this.readCompleted();
                            }
                            Element elem = null;
                            while ((elem = elems.poll()) != null) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Read packet: " + elem.toString());
                                }
                                this.addReceivedPacket(new Packet(elem));
                            }
                        }
                        catch (Exception ex) {
                            log.log(Level.INFO, "Incorrect XML data: " + new String(data) + ", stopping connection: " + this.getUniqueId() + ", exception: ", ex);
                            this.forceStop();
                        }
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.finest("Nothing read!!");
                    }
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Service disconnected during read");
                    }
                    this.forceStop();
                }
                data = this.readData();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("function called when the service is not connected! forceStop()");
            }
            this.forceStop();
        }
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    protected void addReceivedPacket(Packet packet) {
        this.receivedPackets.offer(packet);
    }
}

