/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.util.DNSResolver;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostRepository;

public class VhostConfigRepository
implements VHostRepository {
    private static final Logger log = Logger.getLogger("tigase.vhosts.VhostConfigRepository");
    public static final String ANONYMOUS_DOMAINS_PROP_KEY = "anonymous-domains";
    protected LinkedHashMap<String, VHostItem> vhosts = new LinkedHashMap();

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        String[] hostnames = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            hostnames = ((String)params.get("--virt-hosts")).split(",");
        }
        defs.put("hostnames", hostnames);
        defs.put(ANONYMOUS_DOMAINS_PROP_KEY, hostnames);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        String[] hostnames = (String[])properties.get("hostnames");
        String[] anons = (String[])properties.get(ANONYMOUS_DOMAINS_PROP_KEY);
        HashSet anonset = new HashSet();
        if (anons != null) {
            Collections.addAll(anonset, anons);
        }
        if (hostnames != null && hostnames.length > 0) {
            this.vhosts.clear();
            for (String hostname : hostnames) {
                VHostItem item = new VHostItem(hostname);
                item.setAnonymousEnabled(anonset.contains(hostname));
                this.vhosts.put(hostname, item);
            }
        } else {
            log.warning("Virtual hosts list is not set in the configuration file!!");
        }
    }

    @Override
    public VHostItem getVHost(String domain) {
        return this.vhosts.get(domain);
    }

    @Override
    public boolean contains(String domain) {
        return this.vhosts.keySet().contains(domain);
    }

    @Override
    public void reload() {
    }

    public void store() {
    }

    @Override
    public int size() {
        return this.vhosts.size();
    }

    @Override
    public void addVHost(VHostItem vhost) {
        this.vhosts.put(vhost.getVhost(), vhost);
        this.store();
    }

    @Override
    public void removeVHost(String vh) {
        this.vhosts.remove(vh);
        this.store();
    }

    @Override
    public Collection<VHostItem> localDomains() {
        return this.vhosts.values();
    }
}

