/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import tigase.server.AbstractMessageReceiver;

public class PriorityQueue<E> {
    private static final Logger log = Logger.getLogger(AbstractMessageReceiver.class.getName());
    private LinkedBlockingQueue<E>[] qs = null;
    private int lowestNonEmpty = Integer.MAX_VALUE;

    public PriorityQueue(int maxPriority, int maxSize) {
        this.qs = new LinkedBlockingQueue[maxPriority + 1];
        for (int i = 0; i < this.qs.length; ++i) {
            this.qs[i] = new LinkedBlockingQueue(maxSize);
        }
    }

    public void setMaxSize(int maxSize) {
        for (int i = 0; i < this.qs.length; ++i) {
            LinkedBlockingQueue<E> oldQueue = this.qs[i];
            int newSize = Math.max(oldQueue.size(), maxSize);
            this.qs[i] = new LinkedBlockingQueue(newSize);
            this.qs[i].addAll(oldQueue);
        }
    }

    public void put(E element, int priority) throws InterruptedException {
        this.add(element, priority, true);
    }

    public boolean offer(E element, int priority) {
        try {
            return this.add(element, priority, false);
        }
        catch (InterruptedException e) {
            log.warning("This should not happen, this is non-blocking operation.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(E element, int priority, boolean blocking) throws InterruptedException {
        if (priority < 0 || this.qs.length <= priority) {
            throw new IllegalArgumentException("parameter priority must be between 0 and " + (this.qs.length - 1));
        }
        boolean result = true;
        LinkedBlockingQueue<E> q = this.qs[priority];
        if (blocking) {
            q.put(element);
        } else {
            result = q.offer(element);
        }
        PriorityQueue priorityQueue = this;
        synchronized (priorityQueue) {
            if (result) {
                if (priority < this.lowestNonEmpty) {
                    this.lowestNonEmpty = priority;
                }
                this.notify();
            }
        }
        if (!result && priority < this.qs.length - 1) {
            result = this.add(element, priority + 1, blocking);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        E e = null;
        while (e == null) {
            PriorityQueue priorityQueue = this;
            synchronized (priorityQueue) {
                LinkedBlockingQueue<E> q;
                try {
                    while (this.lowestNonEmpty == Integer.MAX_VALUE) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if ((e = (E)(q = this.qs[this.lowestNonEmpty]).poll()) == null || q.isEmpty()) {
                    this.lowestNonEmpty = this.findNextNonEmpty();
                }
            }
        }
        return e;
    }

    private int findNextNonEmpty() {
        for (int i = 0; i < this.qs.length; ++i) {
            if (this.qs[i].isEmpty()) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public int[] size() {
        int[] result = new int[this.qs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.qs[i].size();
        }
        return result;
    }

    public int totalSize() {
        int result = 0;
        for (int i = 0; i < this.qs.length; ++i) {
            result += this.qs[i].size();
        }
        return result;
    }
}

