/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private Calendar cal = Calendar.getInstance();
    private static int MED_LEN = 55;
    private static int LEVEL_OFFSET = 12;

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.cal.setTimeInMillis(record.getMillis());
        sb.append(String.format("%1$tF %1$tT", this.cal));
        if (record.getSourceClassName() != null) {
            String clsName = record.getSourceClassName();
            int idx = clsName.lastIndexOf(".");
            if (idx >= 0) {
                clsName = clsName.substring(idx + 1);
            }
            sb.append("  " + clsName);
        }
        if (record.getSourceMethodName() != null) {
            sb.append("." + record.getSourceMethodName() + "()");
        }
        while (sb.length() < MED_LEN) {
            sb.append(' ');
        }
        sb.append("  " + record.getLevel() + ": ");
        while (sb.length() < MED_LEN + LEVEL_OFFSET) {
            sb.append(' ');
        }
        sb.append(record.getMessage());
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString() + "\n";
    }
}

