/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import tigase.stats.StatRecord;

public class StatisticsList
implements Iterable<StatRecord> {
    private Level statLevel = Level.ALL;
    private LinkedHashMap<String, LinkedHashMap<String, StatRecord>> stats = new LinkedHashMap();

    public StatisticsList(Level level) {
        this.statLevel = level;
    }

    public LinkedHashMap<String, StatRecord> addCompStats(String comp) {
        LinkedHashMap<String, StatRecord> compStats = new LinkedHashMap<String, StatRecord>();
        this.stats.put(comp, compStats);
        return compStats;
    }

    public LinkedHashMap<String, StatRecord> getCompStats(String comp) {
        return this.stats.get(comp);
    }

    public boolean checkLevel(Level recordLevel) {
        return recordLevel.intValue() >= this.statLevel.intValue();
    }

    public boolean checkLevel(Level recordLevel, long value) {
        if (this.checkLevel(recordLevel)) {
            if (value == 0L) {
                return this.checkLevel(Level.FINEST);
            }
            return true;
        }
        return false;
    }

    public boolean checkLevel(Level recordLevel, int value) {
        if (this.checkLevel(recordLevel)) {
            if (value == 0) {
                return this.checkLevel(Level.FINEST);
            }
            return true;
        }
        return false;
    }

    public boolean add(String comp, String description, long value, Level recordLevel) {
        if (this.checkLevel(recordLevel, value)) {
            LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
            if (compStats == null) {
                compStats = this.addCompStats(comp);
            }
            compStats.put(description, new StatRecord(comp, description, "long", value, recordLevel));
            return true;
        }
        return false;
    }

    public boolean add(String comp, String description, int value, Level recordLevel) {
        if (this.checkLevel(recordLevel, value)) {
            LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
            if (compStats == null) {
                compStats = this.addCompStats(comp);
            }
            compStats.put(description, new StatRecord(comp, description, "int", value, recordLevel));
            return true;
        }
        return false;
    }

    public boolean add(String comp, String description, String value, Level recordLevel) {
        if (this.checkLevel(recordLevel)) {
            LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
            if (compStats == null) {
                compStats = this.addCompStats(comp);
            }
            compStats.put(description, new StatRecord(comp, description, "String", value, recordLevel));
            return true;
        }
        return false;
    }

    public boolean add(String comp, String description, float value, Level recordLevel) {
        if (this.checkLevel(recordLevel)) {
            LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
            if (compStats == null) {
                compStats = this.addCompStats(comp);
            }
            compStats.put(description, new StatRecord(comp, description, "float", value, recordLevel));
            return true;
        }
        return false;
    }

    public long getValue(String comp, String description, long def) {
        StatRecord rec;
        long result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getLongValue();
        }
        return result;
    }

    public float getValue(String comp, String description, float def) {
        StatRecord rec;
        float result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getFloatValue();
        }
        return result;
    }

    public int getValue(String comp, String description, int def) {
        StatRecord rec;
        int result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getIntValue();
        }
        return result;
    }

    public String getValue(String comp, String description, String def) {
        StatRecord rec;
        String result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getValue();
        }
        return result;
    }

    public String toString() {
        return this.stats.toString();
    }

    @Override
    public Iterator<StatRecord> iterator() {
        return new StatsIterator();
    }

    private class StatsIterator
    implements Iterator<StatRecord> {
        Iterator<LinkedHashMap<String, StatRecord>> compsIt;
        Iterator<StatRecord> recIt;

        private StatsIterator() {
            this.compsIt = StatisticsList.this.stats.values().iterator();
            this.recIt = null;
        }

        @Override
        public boolean hasNext() {
            if (this.recIt == null || !this.recIt.hasNext()) {
                if (this.compsIt.hasNext()) {
                    this.recIt = this.compsIt.next().values().iterator();
                } else {
                    return false;
                }
            }
            return this.recIt.hasNext();
        }

        @Override
        public StatRecord next() throws NoSuchElementException {
            if (this.recIt == null || !this.recIt.hasNext()) {
                if (this.compsIt.hasNext()) {
                    this.recIt = this.compsIt.next().values().iterator();
                } else {
                    throw new NoSuchElementException("No more statistics.");
                }
            }
            return this.recIt.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

