/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class PacketFilter {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.PacketFilter");
    private String[] IGNORE_PACKETS = new String[]{"stream:features"};
    private StanzaType[] IGNORE_TYPES = new StanzaType[]{StanzaType.error};
    private String[] AUTH_ONLY_ELEMS = new String[]{"message", "presence"};
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();

    public boolean preprocess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        for (int i = 0; i < this.IGNORE_PACKETS.length; ++i) {
            if (packet.getElemName() != this.IGNORE_PACKETS[i] || packet.getType() != this.IGNORE_TYPES[i]) continue;
            return true;
        }
        if (session == null) {
            return false;
        }
        try {
            if (session.getConnectionId().equals(packet.getFrom())) {
                if (!session.isAuthorized()) {
                    for (String elem : this.AUTH_ONLY_ELEMS) {
                        if (packet.getElemName() != elem) continue;
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Packet received before the session has been authenticated.Session details: connectionId=" + session.getConnectionId() + ", sessionId=" + session.getSessionId() + ", ConnectionStatus=" + (Object)((Object)session.getConnectionStatus()) + ", packet=" + packet.toString());
                        }
                        return true;
                    }
                    return false;
                }
                if (!session.isResourceSet() && packet.getElement().getChild("bind", "urn:ietf:params:xml:ns:xmpp-bind") == null) {
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must bind the resource first: http://www.xmpp.org/rfcs/rfc3920.html#bind", true));
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Session details: connectionId=" + session.getConnectionId() + ", sessionId=" + session.getSessionId() + ", ConnectionStatus=" + (Object)((Object)session.getConnectionStatus()));
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Session more detais: JID=" + session.getJID());
                    }
                    return true;
                }
                String from_jid = session.getJID();
                if (from_jid != null && !from_jid.isEmpty()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Setting correct from attribute: " + from_jid);
                    }
                    packet.getElement().setAttribute("from", from_jid);
                } else {
                    log.warning("Session is authenticated but session.getJid() is empty: " + packet.toString());
                }
            }
        }
        catch (PacketErrorTypeException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Ignoring packet with an error to non-existen user session: " + packet.toString());
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Packet preprocessing exception: ", e);
            return false;
        }
        return false;
    }

    public boolean forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        return false;
    }

    public boolean process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        try {
            if (packet.getElemTo() == null) {
                if (packet.getElemName().equals("iq") && packet.getType() == StanzaType.result) {
                    return true;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("No 'to' address, can't deliver packet: " + packet.getStringData());
                }
                return false;
            }
            String to = JIDUtils.getNodeID((String)packet.getElemTo());
            if (to.equals(session.getUserId())) {
                if (session.getConnectionId() == "NULL") {
                    results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Features not implemented yet.", true));
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Yes, this is packet to 'this' client: " + to);
                    }
                    Element elem = packet.getElement().clone();
                    Packet result = new Packet(elem);
                    result.setTo(session.getConnectionId(packet.getElemTo()));
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Setting to: " + result.getTo());
                    }
                    result.setFrom(packet.getTo());
                    results.offer(result);
                }
                return true;
            }
            String from = JIDUtils.getNodeID((String)packet.getElemFrom());
            if (from.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                results.offer(result);
                return true;
            }
        }
        catch (PacketErrorTypeException e) {
            log.info("Error packet, ignoring... " + packet.toString());
        }
        catch (NotAuthorizedException e) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                log.info("NotAuthorizedException for packet: " + packet.getStringData());
            }
            catch (PacketErrorTypeException e2) {
                log.info("Packet processing exception: " + e2);
            }
        }
        return false;
    }
}

