/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import tigase.conf.Configurator;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;
import tigase.stats.StatisticsList;
import tigase.util.LogFormatter;

public class LogMonitor
extends AbstractMonitor {
    private MonitorHandler monitorHandler = null;
    private MemoryHandlerFlush memoryHandler = null;
    private Map<String, String> monitorLevels = new LinkedHashMap<String, String>();
    private int loggerSize = 50;
    private Level levelTreshold = Level.WARNING;
    private int maxLogBuffer = 1000000;
    private long lastWarningSent = 0L;
    private long logWarings = 0L;

    @Override
    public String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String runCommand(String[] com) {
        command comm = command.valueOf(com[0].substring(2));
        switch (comm) {
            case setlevel: {
                if (com.length > 1) {
                    String[] keyval = com[1].split("=");
                    if (keyval.length > 1) {
                        String key = keyval[0].endsWith(".level") ? keyval[0].substring(0, keyval[0].length() - 6) : keyval[0];
                        try {
                            Level level = Level.parse(keyval[1]);
                            Logger.getLogger(key).setLevel(level);
                            this.monitorLevels.put(key + ".level", level.getName());
                            return "Level set successfuly: " + key + "=" + level.getName();
                        }
                        catch (Exception e) {
                            return "Incorrect level name, use: ALL, FINEST, FINER, FINE, INFO, WARNING, SEVERE, OFF";
                        }
                    }
                    return "Incorrect level setting, use: package=level";
                }
                return "Current logging levels are:\n" + this.getCurrentLevels();
            }
            case loggersize: {
                if (com.length > 1) {
                    try {
                        int newLoggerSize;
                        this.loggerSize = newLoggerSize = Integer.parseInt(com[1]);
                        this.registerHandler();
                        return "New logger size successfuly set to: " + this.loggerSize;
                    }
                    catch (Exception e) {
                        return "Incorrect logger size: " + com[1];
                    }
                }
                return "Current memory logger size is: " + this.loggerSize;
            }
            case leveltreshold: {
                if (com.length > 1) {
                    return "Setting logging treshold level is not supported yet.";
                }
                return "Current logging treshold level is: " + this.levelTreshold;
            }
            case logdump: {
                return "Memory logging buffer content:\n" + this.memoryHandler.pushToString();
            }
        }
        return null;
    }

    @Override
    public boolean isMonitorCommand(String com) {
        if (com != null) {
            for (command comm : command.values()) {
                if (!com.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void removeHandler() {
        if (this.memoryHandler != null) {
            Logger.getLogger("").removeHandler(this.memoryHandler);
        }
    }

    private void registerHandler() {
        this.removeHandler();
        if (this.monitorHandler == null) {
            this.monitorHandler = new MonitorHandler();
            this.monitorHandler.setLevel(Level.ALL);
        }
        this.memoryHandler = new MemoryHandlerFlush(this.monitorHandler, this.loggerSize, this.levelTreshold);
        this.memoryHandler.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(this.memoryHandler);
    }

    @Override
    public void init(String jid, float treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.registerHandler();
    }

    @Override
    public void destroy() {
        this.removeHandler();
    }

    private String getCurrentLevels() {
        String[] configLines = Configurator.logManagerConfiguration.split("\n");
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (String string : configLines) {
            if (!string.contains(".level") || string.contains("FileHandler") || string.contains("ConsoleHandler")) continue;
            String[] keyval = string.split("=");
            results.put(keyval[0], keyval[1]);
        }
        results.putAll(this.monitorLevels);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : results.entrySet()) {
            sb.append((String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String getState() {
        StringBuilder sb = new StringBuilder("Logging levels:\n");
        sb.append(this.getCurrentLevels());
        sb.append("Monitor parameters:\n");
        sb.append("loggerSize=" + this.loggerSize + "\n");
        sb.append("levelTreshold=" + this.levelTreshold + "\n");
        return sb.toString();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add("log-mon", "Log warings", this.logWarings, Level.FINE);
    }

    private class MemoryHandlerFlush
    extends MemoryHandler {
        MonitorHandler monHandle;

        public MemoryHandlerFlush(MonitorHandler target, int size, Level pushLevel) {
            super(target, size, pushLevel);
            this.monHandle = null;
            this.monHandle = target;
        }

        public String pushToString() {
            super.push();
            return this.monHandle.logsToString();
        }

        @Override
        public void push() {
            super.push();
            this.flush();
        }
    }

    private class MonitorHandler
    extends Handler {
        private LinkedList<String> logs = new LinkedList();
        private LogFormatter formatter = new LogFormatter();

        private MonitorHandler() {
        }

        @Override
        public synchronized void publish(LogRecord record) {
            String logEntry = this.formatter.format(record).replace('<', '[').replace('>', ']');
            this.logs.add(logEntry);
        }

        public synchronized String logsToString() {
            StringBuilder sb = new StringBuilder();
            String logEntry = null;
            while ((logEntry = this.logs.pollLast()) != null && sb.length() < LogMonitor.this.maxLogBuffer) {
                sb.insert(0, logEntry);
            }
            this.logs.clear();
            String result = sb.length() <= LogMonitor.this.maxLogBuffer ? sb.toString() : sb.substring(sb.length() - LogMonitor.this.maxLogBuffer);
            return result;
        }

        @Override
        public synchronized void flush() {
            ++LogMonitor.this.logWarings;
            if (System.currentTimeMillis() - LogMonitor.this.lastWarningSent > 300000L) {
                String logBuff = this.logsToString();
                LogMonitor.this.sendWarningOut(logBuff, null);
                LogMonitor.this.lastWarningSent = System.currentTimeMillis();
            }
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static enum command {
        setlevel(" [package=level] - Sets logging level for specified package."),
        loggersize(" [N] - Sets memory logger size to specified value."),
        leveltreshold(" [level] - Sets level treshold to specified level."),
        logdump(" - retrieves all logs collected in the memory buffer and clears that buffer.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

