/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import tigase.server.Command;
import tigase.server.Permissions;
import tigase.server.Priority;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;

public class Packet {
    private static final String ERROR_NS = "urn:ietf:params:xml:ns:xmpp-stanzas";
    private Set<String> processorsIds = new LinkedHashSet<String>(4, 0.9f);
    public static final String OLDTO = "oldto";
    public static final String OLDFROM = "oldfrom";
    private final Element elem;
    private final Command command;
    private final String strCommand;
    private final boolean cmd;
    private final boolean serviceDisco;
    private final StanzaType type;
    private final boolean routed;
    private String to = null;
    private String toId = null;
    private String toHost = null;
    private String toNick = null;
    private String from = null;
    private String id = null;
    private Permissions permissions = Permissions.NONE;
    private String packetToString = null;
    private Priority priority = Priority.NORMAL;
    private String iqQueryXMLNS = null;
    private String elemTo = null;
    private String elemToId = null;
    private String elemToHost = null;
    private String elemToNick = null;

    public Packet(Element elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        this.elem = elem;
        this.type = elem.getAttribute("type") != null ? StanzaType.valueof(elem.getAttribute("type")) : null;
        if (elem.getName() == "iq") {
            Element child = elem.getChild("command", "http://jabber.org/protocol/commands");
            if (child != null) {
                this.cmd = true;
                this.strCommand = child.getAttribute("node");
                this.command = Command.valueof(this.strCommand);
            } else {
                this.strCommand = null;
                this.command = null;
                this.cmd = false;
            }
            this.serviceDisco = this.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#info") || this.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#items");
        } else {
            this.strCommand = null;
            this.command = null;
            this.cmd = false;
            this.serviceDisco = false;
            if (elem.getName() == "cluster") {
                this.setPriority(Priority.CLUSTER);
            }
            if (elem.getName() == "presence" && (this.type == null || this.type == StanzaType.available || this.type == StanzaType.unavailable || this.type == StanzaType.probe)) {
                this.setPriority(Priority.PRESENCE);
            }
        }
        this.routed = elem.getName().equals("route");
        this.initVars();
    }

    public Packet(String el_name, String from, String to, StanzaType type) {
        this.elem = new Element(el_name, new String[]{"from", "to", "type"}, new String[]{from, to, type.toString()});
        this.type = type;
        this.strCommand = null;
        this.command = null;
        this.cmd = false;
        this.routed = false;
        this.serviceDisco = false;
        this.initVars();
    }

    private void initVars() {
        this.elemTo = this.elem.getAttribute("to");
        if (this.elemTo != null) {
            this.elemToHost = JIDUtils.getNodeHost((String)this.elemTo);
            this.elemToNick = JIDUtils.getNodeNick((String)this.elemTo);
            this.elemToId = JIDUtils.getNodeID((String)this.elemTo);
        }
        this.id = this.elem.getAttribute("id");
        this.initTo();
    }

    private void initTo() {
        if (this.to != null) {
            this.toId = JIDUtils.getNodeID((String)this.to);
            this.toHost = JIDUtils.getNodeHost((String)this.to);
            this.toNick = JIDUtils.getNodeNick((String)this.to);
        }
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getId() {
        return this.id;
    }

    public void setPermissions(Permissions perm) {
        this.packetToString = null;
        this.permissions = perm;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void processedBy(String id) {
        this.processorsIds.add(id);
    }

    public boolean wasProcessed() {
        return this.processorsIds.size() > 0;
    }

    public boolean wasProcessedBy(String id) {
        return this.processorsIds.contains(id);
    }

    public Set<String> getProcessorsIds() {
        return this.processorsIds;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getStrCommand() {
        return this.strCommand;
    }

    public StanzaType getType() {
        return this.type;
    }

    public Element getElement() {
        return this.elem;
    }

    public String getElemName() {
        return this.elem.getName();
    }

    public boolean isCommand() {
        return this.cmd;
    }

    public boolean isServiceDisco() {
        return this.serviceDisco;
    }

    public String getXMLNS() {
        return this.elem.getXMLNS();
    }

    public String getIQXMLNS() {
        if (this.iqQueryXMLNS == null) {
            this.iqQueryXMLNS = this.elem.getXMLNS("/iq/query");
        }
        return this.iqQueryXMLNS;
    }

    public String getIQChildName() {
        List children = this.elem.getChildren();
        if (children != null && children.size() > 0) {
            return ((Element)children.get(0)).getName();
        }
        return null;
    }

    public boolean isXMLNS(String elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNS(elementPath);
        return this_xmlns == xmlns;
    }

    public boolean isElement(String name, String xmlns) {
        return this.elem.getName() == name && xmlns == this.elem.getXMLNS();
    }

    public String getTo() {
        return this.to != null ? this.to : this.elemTo;
    }

    public String getToId() {
        return this.toId != null ? this.toId : this.elemToId;
    }

    public String getToHost() {
        return this.toHost != null ? this.toHost : this.elemToHost;
    }

    public String getToNick() {
        return this.toNick != null ? this.toNick : this.elemToNick;
    }

    public void setTo(String to) {
        this.to = to;
        this.initTo();
    }

    public String getFrom() {
        return this.from != null ? this.from : this.getElemFrom();
    }

    public void setFrom(String from) {
        this.packetToString = null;
        this.from = from;
    }

    public String getAttribute(String key) {
        return this.elem.getAttribute(key);
    }

    public String getElemTo() {
        return this.elemTo;
    }

    public String getElemToHost() {
        return this.elemToHost;
    }

    public String getElemToNick() {
        return this.elemToNick;
    }

    public String getAttribute(String path, String attr_name) {
        return this.elem.getAttribute(path, attr_name);
    }

    public String getElemFrom() {
        return this.elem.getAttribute("from");
    }

    public String getElemId() {
        return this.id;
    }

    public String getElemCData(String path) {
        return this.elem.getCData(path);
    }

    public List<Element> getElemChildren(String path) {
        return this.elem.getChildren(path);
    }

    public String getElemCData() {
        return this.elem.getCData();
    }

    public byte[] getByteData() {
        return this.elem.toString().getBytes();
    }

    public String getStringData() {
        return this.elem.toString();
    }

    public char[] getCharData() {
        return this.elem.toString().toCharArray();
    }

    public String toString() {
        if (this.packetToString == null) {
            this.packetToString = ", data=" + this.elem.toString() + ", XMLNS=" + this.elem.getXMLNS() + ", priority=" + (Object)((Object)this.priority);
        }
        return "to=" + this.to + ", from=" + this.from + this.packetToString;
    }

    public boolean isRouted() {
        return this.routed;
    }

    public Packet unpackRouted() {
        Packet result = new Packet((Element)this.elem.getChildren().get(0));
        result.setTo(this.getTo());
        result.setFrom(this.getFrom());
        return result;
    }

    public Packet packRouted() {
        Element routedp = new Element("route", new String[]{"to", "from"}, new String[]{this.getTo(), this.getFrom()});
        routedp.addChild((XMLNodeIfc)this.elem);
        return new Packet(routedp);
    }

    public Packet swapFromTo(Element el) {
        Packet packet = new Packet(el);
        packet.setTo(this.getFrom());
        packet.setFrom(this.getTo());
        return packet;
    }

    public Packet commandResult(Command.DataType cmd_type) {
        Packet result = new Packet(Command.createIqCommand(this.getElemTo(), this.getElemFrom(), StanzaType.result, this.elem.getAttribute("id"), this.strCommand, cmd_type));
        result.setFrom(this.getTo());
        result.setTo(this.getFrom());
        return result;
    }

    public static Packet commandResultForm(Packet packet) {
        Packet result = packet.commandResult(Command.DataType.form);
        return result;
    }

    public static Packet commandResultResult(Packet packet) {
        Packet result = packet.commandResult(Command.DataType.result);
        return result;
    }

    public String getErrorCondition() {
        List children = this.elem.getChildren(this.elem.getName() + "/error");
        if (children != null) {
            for (Element cond : children) {
                if (cond.getName().equals("text")) continue;
                return cond.getName();
            }
        }
        return null;
    }

    public Packet errorResult(String errorType, Integer errorCode, String errorCondition, String errorText, boolean includeOriginalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.error.toString());
        if (this.getElemFrom() != null) {
            reply.setAttribute("to", this.getElemFrom());
        }
        if (this.getElemTo() != null) {
            reply.setAttribute("from", this.getElemTo());
        }
        if (this.getElemId() != null) {
            reply.setAttribute("id", this.getElemId());
        }
        if (includeOriginalXML) {
            reply.addChildren(this.elem.getChildren());
        }
        if (this.getAttribute(OLDTO) != null) {
            reply.setAttribute(OLDTO, this.getAttribute(OLDTO));
        }
        if (this.getAttribute("xmlns") != null) {
            reply.setAttribute("xmlns", this.getAttribute("xmlns"));
        }
        Element error = new Element("error");
        if (errorCode != null) {
            error.setAttribute("code", errorCode.toString());
        }
        error.setAttribute("type", errorType);
        Element cond = new Element(errorCondition);
        cond.setXMLNS(ERROR_NS);
        error.addChild((XMLNodeIfc)cond);
        if (errorText != null) {
            Element t = new Element("text", errorText, new String[]{"xml:lang", "xmlns"}, new String[]{"en", ERROR_NS});
            error.addChild((XMLNodeIfc)t);
        }
        reply.addChild((XMLNodeIfc)error);
        return this.swapFromTo(reply);
    }

    public Packet okResult(String includeXML, int originalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.result.toString());
        if (this.getElemFrom() != null) {
            reply.setAttribute("to", this.getElemFrom());
        }
        if (this.getElemTo() != null) {
            reply.setAttribute("from", this.getElemTo());
        }
        if (this.getElemId() != null) {
            reply.setAttribute("id", this.getElemId());
        }
        if (this.getAttribute(OLDTO) != null) {
            reply.setAttribute(OLDTO, this.getAttribute(OLDTO));
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML; ++i) {
            old_child = (Element)old_child.getChildren().get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setXMLNS(old_child.getXMLNS());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.setCData(includeXML);
        }
        Packet result = this.swapFromTo(reply);
        result.setPriority(this.priority);
        return result;
    }

    public Packet okResult(Element includeXML, int originalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.result.toString());
        if (this.getElemFrom() != null) {
            reply.setAttribute("to", this.getElemFrom());
        }
        if (this.getElemTo() != null) {
            reply.setAttribute("from", this.getElemTo());
        }
        if (this.getElemId() != null) {
            reply.setAttribute("id", this.getElemId());
        }
        if (this.getAttribute(OLDTO) != null) {
            reply.setAttribute(OLDTO, this.getAttribute(OLDTO));
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML; ++i) {
            old_child = (Element)old_child.getChildren().get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setXMLNS(old_child.getXMLNS());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.addChild((XMLNodeIfc)includeXML);
        }
        Packet result = this.swapFromTo(reply);
        result.setPriority(this.priority);
        return result;
    }

    public Packet swapElemFromTo() {
        Element copy = this.elem.clone();
        copy.setAttribute("to", this.getElemFrom());
        copy.setAttribute("from", this.getElemTo());
        Packet result = new Packet(copy);
        result.setPriority(this.priority);
        return result;
    }

    public Packet swapElemFromTo(StanzaType type) {
        Element copy = this.elem.clone();
        copy.setAttribute("to", this.getElemFrom());
        copy.setAttribute("from", this.getElemTo());
        copy.setAttribute("type", type.toString());
        Packet result = new Packet(copy);
        result.setPriority(this.priority);
        return result;
    }

    public static Packet getMessage(String to, String from, StanzaType type, String body, String subject, String thread, String id) {
        Element message = new Element("message", new Element[]{new Element("body", body)}, new String[]{"to", "from", "type"}, new String[]{to, from, type.toString()});
        if (id != null) {
            message.addAttribute("id", id);
        }
        if (subject != null) {
            message.addChild((XMLNodeIfc)new Element("subject", subject));
        }
        if (thread != null) {
            message.addChild((XMLNodeIfc)new Element("thread", thread));
        }
        return new Packet(message);
    }
}

