/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.conf.Configurable;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.Priority;
import tigase.server.QueueType;
import tigase.server.ReceiverEventHandler;
import tigase.server.filters.PacketCounter;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.util.PriorityQueue;
import tigase.util.tracer.TigaseTracer;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;

public abstract class AbstractMessageReceiver
implements StatisticsContainer,
MessageReceiver,
Configurable,
VHostListener {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private String DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 400000L).intValue();
    private static final Logger log = Logger.getLogger("tigase.abstract.AbstractMessageReceiver");
    private static final TigaseTracer tracer = TigaseTracer.getTracer("abstract");
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private String defHostname = this.DEF_HOSTNAME_PROP_VAL;
    private MessageReceiver parent = null;
    private Priority[] pr_cache = Priority.values();
    private int in_queues_size = 1;
    private ArrayList<PriorityQueue<Packet>> in_queues = new ArrayList();
    private PriorityQueue<Packet> out_queue = new PriorityQueue(this.pr_cache.length, this.maxQueueSize);
    private CopyOnWriteArrayList<PacketFilterIfc> incoming_filters = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<PacketFilterIfc> outgoing_filters = new CopyOnWriteArrayList();
    private Timer receiverTasks = null;
    private ConcurrentHashMap<String, ReceiverTask> waitingTasks = new ConcurrentHashMap(16, 0.75f, 4);
    private LinkedList<QueueListener> processingThreads = null;
    private QueueListener out_thread = null;
    private String name = null;
    protected VHostManagerIfc vHostManager = null;
    private Set<Pattern> regexRoutings = new CopyOnWriteArraySet<Pattern>();
    private long last_second_packets = 0L;
    private long packets_per_second = 0L;
    private long last_minute_packets = 0L;
    private long packets_per_minute = 0L;
    private long last_hour_packets = 0L;
    private long packets_per_hour = 0L;
    private String compId = null;
    private long[] processPacketTimings = new long[100];
    private int pptIdx = 0;
    private long statReceivedPacketsOk = 0L;
    private long statSentPacketsOk = 0L;
    private long statReceivedPacketsEr = 0L;
    private long statSentPacketsEr = 0L;
    private long packetId = 0L;

    @Override
    public String getComponentId() {
        return this.compId;
    }

    @Override
    public void initializationCompleted() {
    }

    private boolean filterPacket(Packet packet, CopyOnWriteArrayList<PacketFilterIfc> filters) {
        PacketFilterIfc packetFilterIfc;
        boolean result = false;
        Iterator<PacketFilterIfc> i$ = filters.iterator();
        while (i$.hasNext() && !(result = (packetFilterIfc = i$.next()).filter(packet))) {
        }
        return result;
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getFrom() != null && packet.getFrom() != packet.getElemFrom()) {
            return packet.getFrom().hashCode();
        }
        if (packet.getElemTo() != null) {
            return packet.getElemTo().hashCode();
        }
        return packet.getTo().hashCode();
    }

    public String newPacketId(String prefix) {
        StringBuilder sb = new StringBuilder(32);
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(this.getName()).append(++this.packetId);
        return sb.toString();
    }

    @Override
    public boolean addPacketNB(Packet packet) {
        boolean result;
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toString());
        }
        if (result = this.in_queues.get(queueIdx).offer(packet, packet.getPriority().ordinal())) {
            ++this.statReceivedPacketsOk;
        } else {
            ++this.statReceivedPacketsEr;
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addPacket(Packet packet) {
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toString());
        }
        try {
            this.in_queues.get(queueIdx).put(packet, packet.getPriority().ordinal());
            ++this.statReceivedPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statReceivedPacketsEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        boolean result = false;
        result = this.out_queue.offer(packet, packet.getPriority().ordinal());
        if (result) {
            ++this.statSentPacketsOk;
        } else {
            ++this.statSentPacketsEr;
        }
        return result;
    }

    protected boolean addOutPacketWithTimeout(Packet packet, ReceiverEventHandler handler, long delay, TimeUnit unit) {
        new ReceiverTask(handler, delay, unit, packet);
        return this.addOutPacket(packet);
    }

    protected boolean addOutPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            this.out_queue.put(packet, packet.getPriority().ordinal());
            ++this.statSentPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statSentPacketsEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    public abstract void processPacket(Packet var1);

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Last second packets", this.packets_per_second, Level.FINE);
        list.add(this.getName(), "Last minute packets", this.packets_per_minute, Level.FINE);
        list.add(this.getName(), "Last hour packets", this.packets_per_hour, Level.FINE);
        list.add(this.getName(), StatisticType.MSG_RECEIVED_OK.getDescription(), this.statReceivedPacketsOk, Level.FINE);
        list.add(this.getName(), StatisticType.MSG_SENT_OK.getDescription(), this.statSentPacketsOk, Level.FINE);
        int[] in_priority_sizes = this.in_queues.get(0).size();
        for (int i = 1; i < this.in_queues.size(); ++i) {
            int[] tmp_pr_sizes = this.in_queues.get(i).size();
            for (int j = 0; j < tmp_pr_sizes.length; ++j) {
                int n = j;
                in_priority_sizes[n] = in_priority_sizes[n] + tmp_pr_sizes[j];
            }
        }
        int in_queue_size = 0;
        int[] out_priority_sizes = this.out_queue.size();
        int out_queue_size = 0;
        for (Priority queue : Priority.values()) {
            list.add(this.getName(), "In queue: " + queue.name(), in_priority_sizes[queue.ordinal()], Level.FINEST);
            list.add(this.getName(), "Out queue: " + queue.name(), out_priority_sizes[queue.ordinal()], Level.FINEST);
            in_queue_size += in_priority_sizes[queue.ordinal()];
            out_queue_size += out_priority_sizes[queue.ordinal()];
        }
        list.add(this.getName(), "Total In queues wait", in_queue_size, Level.INFO);
        list.add(this.getName(), "Total Out queues wait", out_queue_size, Level.INFO);
        list.add(this.getName(), StatisticType.MAX_QUEUE_SIZE.getDescription(), this.maxQueueSize, Level.FINEST);
        list.add(this.getName(), StatisticType.IN_QUEUE_OVERFLOW.getDescription(), this.statReceivedPacketsEr, Level.INFO);
        list.add(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW.getDescription(), this.statSentPacketsEr, Level.INFO);
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        long prcessingTime = res / (long)this.processPacketTimings.length;
        list.add(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", prcessingTime, Level.FINE);
        for (PacketFilterIfc packetFilter : this.incoming_filters) {
            packetFilter.getStatistics(list);
        }
        for (PacketFilterIfc packetFilter : this.outgoing_filters) {
            packetFilter.getStatistics(list);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        int queueSize = (Integer)props.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.setMaxQueueSize(queueSize);
        this.defHostname = (String)props.get("def-hostname");
        this.compId = (String)props.get("component-id");
        this.incoming_filters.clear();
        this.outgoing_filters.clear();
        PacketCounter counter = new PacketCounter();
        counter.init(this.getName(), QueueType.IN_QUEUE);
        this.incoming_filters.add(counter);
        counter = new PacketCounter();
        counter.init(this.getName(), QueueType.OUT_QUEUE);
        this.outgoing_filters.add(counter);
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (this.maxQueueSize != maxQueueSize || this.in_queues.size() == 0) {
            this.maxQueueSize = maxQueueSize / this.processingThreads();
            if (this.in_queues.size() == 0) {
                for (int i = 0; i < this.in_queues_size; ++i) {
                    this.in_queues.add(new PriorityQueue(this.pr_cache.length, maxQueueSize));
                }
            } else {
                for (int i = 0; i < this.in_queues.size(); ++i) {
                    this.in_queues.get(i).setMaxSize(maxQueueSize);
                }
            }
            this.out_queue.setMaxSize(maxQueueSize);
        }
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String queueSize = (String)params.get("--max-queue-size");
        int queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
        if (queueSize != null) {
            try {
                queueSizeInt = Integer.parseInt(queueSize);
            }
            catch (NumberFormatException e) {
                queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
            }
        }
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getMaxQueueSize(queueSizeInt));
        this.DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        defs.put("component-id", this.compId);
        return defs;
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.compId = JIDUtils.getNodeID((String)name, (String)this.defHostname);
        this.in_queues_size = this.processingThreads();
        this.setMaxQueueSize(this.maxQueueSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void stopThreads() {
        try {
            if (this.processingThreads != null) {
                for (QueueListener in_thread : this.processingThreads) {
                    in_thread.threadStopped = true;
                    in_thread.interrupt();
                    while (in_thread.isAlive()) {
                        Thread.sleep(100L);
                    }
                }
            }
            if (this.out_thread != null) {
                this.out_thread.threadStopped = true;
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.processingThreads = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
    }

    public synchronized void everySecond() {
        this.packets_per_second = this.statReceivedPacketsOk - this.last_second_packets;
        this.last_second_packets = this.statReceivedPacketsOk;
    }

    public synchronized void everyMinute() {
        this.packets_per_minute = this.statReceivedPacketsOk - this.last_minute_packets;
        this.last_minute_packets = this.statReceivedPacketsOk;
        this.receiverTasks.purge();
    }

    public synchronized void everyHour() {
        this.packets_per_hour = this.statReceivedPacketsOk - this.last_hour_packets;
        this.last_hour_packets = this.statReceivedPacketsOk;
    }

    private void startThreads() {
        if (this.processingThreads == null) {
            this.processingThreads = new LinkedList();
            for (int i = 0; i < this.in_queues_size; ++i) {
                QueueListener in_thread = new QueueListener(this.in_queues.get(i), QueueType.IN_QUEUE);
                in_thread.setName("in_" + i + "-" + this.name);
                in_thread.start();
                this.processingThreads.add(in_thread);
            }
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.out_thread = new QueueListener(this.out_queue, QueueType.OUT_QUEUE);
            this.out_thread.setName("out_" + this.name);
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyHour();
            }
        }, 3600000L, 3600000L);
    }

    @Override
    public void start() {
        if (log.isLoggable(Level.FINER)) {
            log.info(this.getName() + ": starting queue management threads ...");
        }
        this.startThreads();
    }

    public void stop() {
        if (log.isLoggable(Level.FINER)) {
            log.info(this.getName() + ": stopping queue management threads ...");
        }
        this.stopThreads();
    }

    @Override
    public String getDefHostName() {
        return this.defHostname;
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    public VHostItem getVHostItem(String domain) {
        return this.vHostManager != null ? this.vHostManager.getVHostItem(domain) : null;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    public void addRegexRouting(String address) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - attempt to add regex routing: " + address);
        }
        this.regexRoutings.add(Pattern.compile(address, 2));
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - success adding regex routing: " + address);
        }
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (!pat.matcher(address).matches()) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " matched against pattern: " + pat.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    public int processingThreads() {
        return 1;
    }

    private class ReceiverTask
    extends TimerTask {
        private ReceiverEventHandler handler = null;
        private Packet packet = null;
        private String id = null;

        private ReceiverTask(ReceiverEventHandler handler, long delay, TimeUnit unit, Packet packet) {
            this.handler = handler;
            this.packet = packet;
            this.id = packet.getFrom() + packet.getId();
            AbstractMessageReceiver.this.waitingTasks.put(this.id, this);
            AbstractMessageReceiver.this.receiverTasks.schedule((TimerTask)this, unit.toMillis(delay));
        }

        @Override
        public void run() {
            this.handleTimeout();
        }

        public void handleTimeout() {
            AbstractMessageReceiver.this.waitingTasks.remove(this.packet.getFrom() + this.packet.getId());
            this.handler.timeOutExpired(this.packet);
        }

        public void handleResponse(Packet response) {
            this.cancel();
            this.handler.responseReceived(this.packet, response);
        }
    }

    private class QueueListener
    extends Thread {
        private PriorityQueue<Packet> queue;
        private QueueType type = null;
        private boolean threadStopped = false;

        private QueueListener(PriorityQueue<Packet> q, QueueType type) {
            this.queue = q;
            this.type = type;
        }

        @Override
        public void run() {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " starting queue processing.");
            }
            Packet packet = null;
            block7: while (!this.threadStopped) {
                try {
                    packet = this.queue.take();
                    switch (this.type) {
                        case IN_QUEUE: {
                            tracer.trace(null, packet.getElemTo(), packet.getElemFrom(), packet.getFrom(), this.getName(), this.type.name(), null, packet);
                            String id = packet.getTo() + packet.getId();
                            ReceiverTask task = (ReceiverTask)AbstractMessageReceiver.this.waitingTasks.remove(id);
                            if (task != null) {
                                task.handleResponse(packet);
                                continue block7;
                            }
                            long startPPT = System.currentTimeMillis();
                            if (!AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.incoming_filters)) {
                                AbstractMessageReceiver.this.processPacket(packet);
                            }
                            ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[((AbstractMessageReceiver)AbstractMessageReceiver.this).pptIdx] = System.currentTimeMillis() - startPPT;
                            AbstractMessageReceiver.this.pptIdx = (AbstractMessageReceiver.this.pptIdx + 1) % AbstractMessageReceiver.this.processPacketTimings.length;
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            tracer.trace(null, packet.getElemTo(), packet.getElemFrom(), packet.getTo(), this.getName(), this.type.name(), null, packet);
                            if (AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.outgoing_filters)) continue block7;
                            if (AbstractMessageReceiver.this.parent != null) {
                                AbstractMessageReceiver.this.parent.addPacket(packet);
                                continue block7;
                            }
                            AbstractMessageReceiver.this.addPacketNB(packet);
                            continue block7;
                        }
                    }
                    log.severe("Unknown queue element type: " + (Object)((Object)this.type));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "[" + this.getName() + "] Exception during packet processing: " + packet.toString(), e);
                }
            }
        }
    }
}

