/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashMap;
import java.util.Map;
import tigase.server.ComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;

public abstract class AbstractComponentRegistrator<E extends ServerComponent>
implements ComponentRegistrator {
    private String name = null;
    private String componentId = null;
    private long packetId = 0L;
    protected Map<String, E> components = new LinkedHashMap<String, E>();

    public abstract boolean isCorrectType(ServerComponent var1);

    @Override
    public boolean addComponent(ServerComponent component) {
        if (this.isCorrectType(component)) {
            this.components.put(component.getName(), component);
            this.componentAdded(component);
            return true;
        }
        return false;
    }

    public E getComponent(String name) {
        return (E)((ServerComponent)this.components.get(name));
    }

    public abstract void componentAdded(E var1);

    @Override
    public boolean deleteComponent(ServerComponent component) {
        this.components.remove(component.getName());
        this.componentRemoved(component);
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.componentId = JIDUtils.getNodeID((String)name, (String)DNSResolver.getDefaultHostname());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    public String newPacketId(String prefix) {
        StringBuilder sb = new StringBuilder(32);
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(this.getName()).append(++this.packetId);
        return sb.toString();
    }

    @Override
    public void initializationCompleted() {
    }

    public abstract void componentRemoved(E var1);
}

