/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.IOInterface;
import tigase.stats.StatisticsList;

public class SocketIO
implements IOInterface {
    private static Logger log = Logger.getLogger("tigase.io.SocketIO");
    private Queue<ByteBuffer> dataToSend = null;
    private SocketChannel channel = null;
    private int bytesRead = 0;
    private String remoteAddress = null;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;

    public SocketIO(SocketChannel sock) throws IOException {
        this.channel = sock;
        this.channel.configureBlocking(false);
        this.channel.socket().setSoLinger(false, 0);
        this.channel.socket().setReuseAddress(true);
        this.remoteAddress = this.channel.socket().getInetAddress().getHostAddress();
        this.dataToSend = this.channel.socket().getTrafficClass() == 8 ? new LinkedBlockingQueue<ByteBuffer>(100000) : new LinkedBlockingQueue<ByteBuffer>(100);
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called.");
        }
        this.channel.close();
    }

    @Override
    public boolean isRemoteAddress(String addr) {
        return this.remoteAddress.equals(addr);
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        if (buff != null) {
            this.dataToSend.offer(buff);
        }
        int result = 0;
        ByteBuffer dataBuffer = null;
        while ((dataBuffer = this.dataToSend.peek()) != null) {
            int res = this.channel.write(dataBuffer);
            if (res == -1) {
                throw new EOFException("Channel has been closed.");
            }
            result += res;
            if (dataBuffer.hasRemaining()) break;
            this.dataToSend.poll();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Wrote to channel " + result + " bytes.");
        }
        this.bytesSent += (long)result;
        return result;
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        this.bytesRead = this.channel.read(buff);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read from channel " + this.bytesRead + " bytes.");
        }
        if (this.bytesRead == -1) {
            throw new EOFException("Channel has been closed.");
        }
        if (this.bytesRead > 0) {
            buff.flip();
            this.bytesReceived += (long)this.bytesRead;
        }
        return buff;
    }

    @Override
    public int bytesRead() {
        return this.bytesRead;
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.channel.socket().getReceiveBufferSize();
    }

    @Override
    public boolean waitingToSend() {
        return this.dataToSend.size() > 0;
    }

    @Override
    public int waitingToSendSize() {
        return this.dataToSend.size();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add("socketio", "Bytes sent", this.bytesSent, Level.FINE);
        list.add("socketio", "Bytes received", this.bytesReceived, Level.FINE);
    }
}

