/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.JIDUtils;

public class DrupalAuth
implements UserAuthRepository {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.DrupalAuth");
    private static final String[] non_sasl_mechs = new String[]{"password"};
    private static final String[] sasl_mechs = new String[]{"PLAIN"};
    public static final String DEF_USERS_TBL = "users";
    private String users_tbl = "users";
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement pass_st = null;
    private PreparedStatement status_st = null;
    private PreparedStatement user_add_st = null;
    private PreparedStatement max_uid_st = null;
    private PreparedStatement conn_valid_st = null;
    private PreparedStatement update_last_login_st = null;
    private PreparedStatement update_online_status = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean online_status = false;

    private void initPreparedStatements() throws SQLException {
        String query = "select pass from " + this.users_tbl + " where name = ?;";
        this.pass_st = this.conn.prepareStatement(query);
        query = "select status from " + this.users_tbl + " where name = ?;";
        this.status_st = this.conn.prepareStatement(query);
        query = "insert into " + this.users_tbl + " (uid, name, pass, status)" + " values (?, ?, ?, 1);";
        this.user_add_st = this.conn.prepareStatement(query);
        query = "select max(uid) from " + this.users_tbl;
        this.max_uid_st = this.conn.prepareStatement(query);
        query = "select 1;";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "update " + this.users_tbl + " set access=?, login=? where name=?;";
        this.update_last_login_st = this.conn.prepareStatement(query);
        query = "update " + this.users_tbl + " set online_status=online_status+? where name=?;";
        this.update_online_status = this.conn.prepareStatement(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLogin(String user) throws TigaseDBException {
        try {
            PreparedStatement preparedStatement = this.update_last_login_st;
            synchronized (preparedStatement) {
                BigDecimal bd = new BigDecimal(System.currentTimeMillis() / 1000L);
                this.update_last_login_st.setBigDecimal(1, bd);
                this.update_last_login_st.setBigDecimal(2, bd);
                this.update_last_login_st.setString(3, JIDUtils.getNodeNick((String)user));
                this.update_last_login_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Error accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnlineStatus(String user, int status) throws TigaseDBException {
        if (this.online_status) {
            try {
                PreparedStatement preparedStatement = this.update_online_status;
                synchronized (preparedStatement) {
                    this.update_online_status.setInt(1, status);
                    this.update_online_status.setString(2, JIDUtils.getNodeNick((String)user));
                    this.update_online_status.executeUpdate();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Error accessing repository.", e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isActive(String user) throws SQLException, UserNotFoundException {
        ResultSet rs = null;
        try {
            boolean bl;
            PreparedStatement preparedStatement = this.status_st;
            synchronized (preparedStatement) {
                this.status_st.setString(1, JIDUtils.getNodeNick((String)user));
                rs = this.status_st.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                bl = rs.getInt(1) == 1;
            }
            this.release(null, rs);
            return bl;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getMaxUID() throws SQLException {
        long l;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.max_uid_st;
            synchronized (preparedStatement) {
                rs = this.max_uid_st.executeQuery();
                if (rs.next()) {
                    BigDecimal max_uid = rs.getBigDecimal(1);
                    long l2 = max_uid.longValue();
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.release(null, rs);
                    return l2;
                }
                l = -1L;
            }
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        this.release(null, rs);
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPassword(String user) throws SQLException, UserNotFoundException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            PreparedStatement preparedStatement = this.pass_st;
            synchronized (preparedStatement) {
                this.pass_st.setString(1, JIDUtils.getNodeNick((String)user));
                rs = this.pass_st.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                string = rs.getString(1);
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.conn = DriverManager.getConnection(this.db_conn);
            this.initPreparedStatements();
        }
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        this.db_conn = connection_str;
        if (this.db_conn.contains("online_status=true")) {
            this.online_status = true;
        }
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
        try {
            if (this.online_status) {
                Statement stmt = this.conn.createStatement();
                stmt.executeUpdate("update users set online_status = 0;");
                stmt.close();
                stmt = null;
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("'online_status'")) {
                try {
                    Statement stmt = this.conn.createStatement();
                    stmt.executeUpdate("alter table users add online_status int default 0;");
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {
                    this.conn = null;
                    throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, ex);
                }
            }
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public boolean plainAuth(String user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        try {
            this.checkConnection();
            if (!this.isActive(user)) {
                throw new AuthorizationException("User account has been blocked.");
            }
            String enc_passwd = Algorithms.hexDigest((String)"", (String)password, (String)"MD5");
            String db_password = this.getPassword(user);
            boolean login_ok = db_password.equals(enc_passwd);
            if (login_ok) {
                this.updateLastLogin(user);
                this.updateOnlineStatus(user, 1);
            }
            return login_ok;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("Password encoding algorithm is not supported.", e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public boolean digestAuth(String user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        throw new AuthorizationException("Not supported.");
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals("PLAIN")) {
                boolean login_ok = this.saslAuth(props);
                if (login_ok) {
                    String user = (String)props.get("user-id");
                    this.updateLastLogin(user);
                    this.updateOnlineStatus(user, 1);
                }
                return login_ok;
            }
            throw new AuthorizationException("Mechanism is not supported: " + mech);
        }
        throw new AuthorizationException("Protocol is not supported: " + proto);
    }

    @Override
    public void logout(String user) throws UserNotFoundException, TigaseDBException {
        try {
            this.checkConnection();
            this.updateOnlineStatus(user, -1);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(String user, String password) throws UserExistsException, TigaseDBException {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.user_add_st;
            synchronized (preparedStatement) {
                long uid = this.getMaxUID() + 1L;
                this.user_add_st.setLong(1, uid);
                this.user_add_st.setString(2, JIDUtils.getNodeNick((String)user));
                this.user_add_st.setString(3, Algorithms.hexDigest((String)"", (String)password, (String)"MD5"));
                this.user_add_st.executeUpdate();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TigaseDBException("Password encoding algorithm is not supported.", e);
        }
        catch (SQLException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", e);
        }
    }

    @Override
    public void updatePassword(String user, String password) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Updatin user password is not supported.");
    }

    @Override
    public void removeUser(String user) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Removing user is not supported.");
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                sasl_props.put("password-encryption", "MD5");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("challenge: " + (challenge != null ? new String(challenge) : "null"));
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    @Override
    public long getUsersCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getUsersCount(String domain) {
        return 0L;
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Callback: " + callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("RealmCallback: " + realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = JIDUtils.getNodeID((String)user_name, (String)((String)this.options.get("realm")));
                    this.options.put("user-id", jid);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("NameCallback: " + user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = DrupalAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.finest("PasswordCallback: " + passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    String authorId = authCallback.getAuthorizationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("AuthorizeCallback: authenId: " + authenId);
                        log.finest("AuthorizeCallback: authorId: " + authorId);
                    }
                    if (!authenId.equals(authorId)) continue;
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

