/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterController;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.cluster.ClusteringStrategyIfc;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClustered
extends SessionManager
implements ClusteredComponent {
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_KEY = "cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.SMNonCachingAllNodes";
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final int SYNC_MAX_BATCH_SIZE = 1000;
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private static final String USER_ID = "userId";
    private static final String SM_ID = "smId";
    private static final String CREATION_TIME = "creationTime";
    private static final String ERROR_CODE = "errorCode";
    private static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final String RESOURCE = "resource";
    private static final String CONNECTION_ID = "connectionId";
    private static final String PRIORITY = "priority";
    private static final String TOKEN = "token";
    private static final String TRANSFER = "transfer";
    private static final String AUTH_TIME = "auth-time";
    private static final String CL_BR_INITIAL_PRESENCE = "cl-br-init-pres";
    private static final String CL_BR_USER_CONNECTED = "cl-br-user_conn";
    private static final String SYNC_ONLINE_JIDS = "sync-jids";
    private Timer delayedTasks = null;
    private ClusteringStrategyIfc strategy = null;
    private String my_hostname = null;
    private int nodesNo = 0;

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            if (this.isTrusted(packet.getElemFrom())) {
                this.processClusterPacket(packet);
            } else if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Cluster packet from untrusted source: " + packet.toString());
            }
            return;
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Ressource connection found: " + conn);
        }
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet) || this.sendToNextNode(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    protected void processPacket(ClusterElement packet) {
        List<Element> elems = packet.getDataPackets();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                Packet el_packet = new Packet(elem);
                XMPPResourceConnection conn = this.getXMPPResourceConnection(el_packet);
                if (conn == null && this.sendToNextNode(packet, el_packet.getElemTo())) continue;
                this.processPacket(el_packet, conn);
            }
        } else {
            log.finest("Empty packets list in the cluster packet: " + packet.toString());
        }
    }

    protected void processClusterPacket(Packet packet) {
        LinkedList<Packet> results;
        block30: {
            results = new LinkedList<Packet>();
            ClusterElement clel = new ClusterElement(packet.getElement());
            ClusterMethods method = ClusterMethods.parseMethod(clel.getMethodName());
            block1 : switch (packet.getType()) {
                case set: {
                    if (clel.getMethodName() == null) {
                        this.processPacket(clel);
                    }
                    switch (method) {
                        case USER_INITIAL_PRESENCE: {
                            String userId = clel.getMethodParam(USER_ID);
                            String resource = clel.getMethodParam(RESOURCE);
                            XMPPSession session = this.getSession(userId);
                            if (session != null && session.getResourceForResource(resource) == null) {
                                String connectionId = clel.getMethodParam(CONNECTION_ID);
                                String xmpp_sessionId = clel.getMethodParam(XMPP_SESSION_ID);
                                String domain = JIDUtils.getNodeHost((String)userId);
                                XMPPResourceConnection res_con = this.loginUserSession(connectionId, domain, userId, resource, ConnectionStatus.REMOTE, xmpp_sessionId);
                                if (res_con != null) {
                                    List<Element> packs = clel.getDataPackets();
                                    for (Element elem : packs) {
                                        if (elem.getName() != "presence") continue;
                                        res_con.setPresence(elem);
                                    }
                                    res_con.putSessionData(SM_ID, packet.getElemFrom());
                                    this.updateUserResources(res_con, results);
                                    for (XMPPResourceConnection xrc : session.getActiveResources()) {
                                        if (xrc.getConnectionStatus() == ConnectionStatus.REMOTE || xrc.getPresence() == null) continue;
                                        this.broadcastUserPresence(xrc, packet.getElemFrom());
                                    }
                                    if (!log.isLoggable(Level.FINEST)) break block1;
                                    log.finest("Added remote session for: " + userId + ", from: " + packet.getElemFrom());
                                    break;
                                }
                                if (!log.isLoggable(Level.INFO)) break block1;
                                log.info("Couldn't create user session for: " + userId + ", resource: " + resource + ", connectionId: " + connectionId);
                                break;
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                if (session == null) {
                                    log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getElemFrom() + ", there is no other session for the user on this node.");
                                    break;
                                }
                                if (session.getResourceForResource(resource) != null) {
                                    log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getElemFrom() + ", there is already a session on this node for this resource.");
                                    break;
                                }
                                log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getElemFrom() + ", reason unknown, please contact devs.");
                                break;
                            }
                            break block30;
                        }
                        case USER_CONNECTED: {
                            String userId = clel.getMethodParam(USER_ID);
                            String resource = clel.getMethodParam(RESOURCE);
                            String connectionId = clel.getMethodParam(CONNECTION_ID);
                            this.strategy.usersConnected(packet.getElemFrom(), results, userId + "/" + resource + "#" + connectionId);
                            break;
                        }
                        case USER_DISCONNECTED: {
                            String userId = clel.getMethodParam(USER_ID);
                            String resource = clel.getMethodParam(RESOURCE);
                            this.strategy.userDisconnected(userId + "/" + resource, packet.getElemFrom(), results);
                            XMPPSession session = this.getSession(userId);
                            if (session != null) {
                                String connectionId = clel.getMethodParam(CONNECTION_ID);
                                this.closeConnection(connectionId, true);
                                if (!log.isLoggable(Level.FINEST)) break block1;
                                log.finest("Removed remote session for: " + userId + ", from: " + packet.getElemFrom());
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case get: {
                    switch (method) {
                        case SYNC_ONLINE: {
                            Collection conns = this.connectionsByFrom.values();
                            int counter = 0;
                            StringBuilder sb = new StringBuilder(40000);
                            for (XMPPResourceConnection conn : conns) {
                                String jid = null;
                                try {
                                    jid = conn.getJID() + "#" + conn.getConnectionId();
                                }
                                catch (Exception e) {
                                    jid = null;
                                }
                                if (jid == null) continue;
                                sb.append(',').append(jid);
                                if (++counter <= 1000) continue;
                                ClusterElement resp = clel.createMethodResponse(this.getComponentId(), StanzaType.result, null);
                                resp.addMethodResult(SYNC_ONLINE_JIDS, sb.toString());
                                this.fastAddOutPacket(new Packet(resp.getClusterElement()));
                                counter = 0;
                                sb.delete(0, sb.length());
                            }
                            if (sb.length() <= 0) break;
                            ClusterElement resp = clel.createMethodResponse(this.getComponentId(), StanzaType.result, null);
                            resp.addMethodResult(SYNC_ONLINE_JIDS, sb.toString());
                            this.fastAddOutPacket(new Packet(resp.getClusterElement()));
                            break;
                        }
                    }
                    break;
                }
                case result: {
                    switch (method) {
                        case SYNC_ONLINE: {
                            String jids = clel.getMethodResultVal(SYNC_ONLINE_JIDS);
                            if (jids != null) {
                                String[] jidsa = jids.split(",");
                                this.strategy.usersConnected(packet.getElemFrom(), results, jidsa);
                                break block1;
                            }
                            log.warning("Sync online packet with empty jids list! Please check this out: " + packet.toString());
                            break block1;
                        }
                    }
                    break;
                }
                case error: {
                    String from = packet.getElemFrom();
                    clel.addVisitedNode(from);
                    this.processPacket(clel);
                    break;
                }
            }
        }
        this.addOutPackets(results);
    }

    protected void updateUserResources(XMPPResourceConnection res_con, Queue<Packet> results) {
        try {
            Element pres_update = res_con.getPresence();
            for (XMPPResourceConnection conn : res_con.getActiveSessions()) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Update presence change to: " + conn.getJID());
                    }
                    if (conn != res_con && conn.isResourceSet() && conn.getConnectionStatus() != ConnectionStatus.REMOTE) {
                        pres_update = pres_update != null ? pres_update.clone() : new Element("presence");
                        pres_update.setAttribute("from", res_con.getJID());
                        pres_update.setAttribute("to", conn.getUserId());
                        Packet pack_update = new Packet(pres_update);
                        pack_update.setTo(conn.getConnectionId());
                        results.offer(pack_update);
                        continue;
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("Skipping presence update to: " + conn.getJID());
                }
                catch (NotAuthorizedException ex) {
                    log.warning("This should not happen, unless the connection has been stopped in a concurrent thread or has not been authenticated yet: " + conn.getConnectionId());
                }
            }
        }
        catch (NotAuthorizedException ex) {
            log.warning("User session from another cluster node authentication problem: " + res_con.getConnectionId());
        }
    }

    protected boolean sendToNextNode(ClusterElement clel, String userId) {
        ClusterElement next_clel = ClusterElement.createForNextNode(clel, this.strategy.getNodesForJid(userId), this.getComponentId());
        if (next_clel != null) {
            this.fastAddOutPacket(new Packet(next_clel.getClusterElement()));
            return true;
        }
        String first = clel.getFirstNode();
        if (first != null && !first.equals(this.getComponentId())) {
            Packet packet;
            List<Element> packets = clel.getDataPackets();
            Element elem = packets != null && packets.size() == 1 ? packets.get(0) : null;
            Packet packet2 = packet = elem != null ? new Packet(elem) : null;
            if (packet == null || packet.getType() != StanzaType.result && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable && packet.getType() != StanzaType.error && (packet.getElemName() != "presence" || packet.getType() != null)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending back to the first node: " + first);
                }
                ClusterElement result = clel.nextClusterNode(first);
                result.addVisitedNode(this.getComponentId());
                this.fastAddOutPacket(new Packet(result.getClusterElement()));
            }
            return true;
        }
        return false;
    }

    protected boolean sendToNextNode(Packet packet) {
        String cluster_node = this.getFirstClusterNode(packet.getElemTo());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Cluster node found: " + cluster_node);
        }
        if (cluster_node != null) {
            String sess_man_id = this.getComponentId();
            ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
            clel.addVisitedNode(sess_man_id);
            this.fastAddOutPacket(new Packet(clel.getClusterElement()));
            return true;
        }
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
        try {
            ClusteringStrategyIfc strategy_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            strategy_tmp.setProperties(props);
            this.strategy = strategy_tmp;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not clustering strategy instance for class: " + strategy_class, e);
        }
        this.my_hostname = (String)props.get(MY_DOMAIN_NAME_PROP_KEY);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate clustering strategy for class: " + strategy_class, e);
        }
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        props.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        if (params.get("--cluster-nodes") != null) {
            String[] cl_nodes = ((String)params.get("--cluster-nodes")).split(",");
            this.nodesNo = cl_nodes.length;
        }
        return props;
    }

    @Override
    public void nodeConnected(String node) {
        log.fine("Nodes connected: " + node);
        String jid = this.getName() + "@" + node;
        this.addTrusted(jid);
        this.strategy.nodeConnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' connected (" + new Date() + ")", "New cluster node connected: " + node, node);
        if (this.strategy.needsSync()) {
            this.requestSync(jid);
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        log.fine("Nodes disconnected: " + node);
        String jid = this.getName() + "@" + node;
        this.strategy.nodeDisconnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' disconnected (" + new Date() + ")", "Cluster node disconnected: " + node, node);
    }

    private void sendAdminNotification(String msg, String subject, String node) {
        String message = msg;
        if (node != null) {
            message = msg + "\n";
        }
        boolean cnt = false;
        message = message + node + " connected to " + this.getDefHostName();
        Packet p_msg = Packet.getMessage(this.getDefHostName(), JIDUtils.getNodeID((String)this.getName(), (String)this.my_hostname), StanzaType.normal, message, subject, "xyz", this.newPacketId(null));
        this.sendToAdmins(p_msg);
    }

    protected String getFirstClusterNode(String userJid) {
        String cluster_node = null;
        List<String> nodes = this.strategy.getNodesForJid(userJid);
        if (nodes != null) {
            for (String node : nodes) {
                if (node.equals(this.getComponentId())) continue;
                cluster_node = node;
                break;
            }
        }
        return cluster_node;
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && conn.isAuthorized()) {
            try {
                String connectionId = conn.getConnectionId();
                String userId = conn.getUserId();
                String resource = conn.getResource();
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put(CONNECTION_ID, connectionId);
                params.put(USER_ID, userId);
                params.put(RESOURCE, resource);
                List<String> cl_nodes = this.strategy.getAllNodes();
                for (String node : cl_nodes) {
                    if (node.equals(this.getComponentId())) continue;
                    Element check_session_el = ClusterElement.createClusterMethodCall(this.getComponentId(), node, StanzaType.set, ClusterMethods.USER_DISCONNECTED.toString(), params).getClusterElement();
                    this.fastAddOutPacket(new Packet(check_session_el));
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem sending user disconnect broadcast for: " + conn.getConnectionId(), ex);
            }
        }
        XMPPSession parentSession = conn.getParentSession();
        super.closeSession(conn, closeOnly);
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && parentSession != null && parentSession.getActiveResourcesSize() == parentSession.getResSizeForConnStatus(ConnectionStatus.REMOTE)) {
            List<XMPPResourceConnection> conns = parentSession.getActiveResources();
            for (XMPPResourceConnection xrc : conns) {
                String connId = xrc.getConnectionId();
                super.closeConnection(xrc.getConnectionId(), true);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Closed remote connection: " + connId);
            }
        }
    }

    private Map<String, String> prepareBroadcastParams(XMPPResourceConnection conn, boolean full_details) throws NotAuthorizedException {
        String userId = conn.getUserId();
        String resource = conn.getResource();
        String connectionId = conn.getConnectionId();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(USER_ID, userId);
        params.put(RESOURCE, resource);
        params.put(CONNECTION_ID, connectionId);
        if (full_details) {
            String xmpp_sessionId = conn.getSessionId();
            long authTime = conn.getAuthTime();
            params.put(XMPP_SESSION_ID, xmpp_sessionId);
            params.put(AUTH_TIME, "" + authTime);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending user: " + userId + " session, resource: " + resource + ", xmpp_sessionId: " + xmpp_sessionId + ", connectionId: " + connectionId);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending user: " + userId + " session, resource: " + resource);
        }
        return params;
    }

    private void sendBroadcastPackets(Element data, Map<String, String> params, ClusterMethods methodCall, String ... nodes) {
        ClusterElement clel = ClusterElement.createClusterMethodCall(this.getComponentId(), nodes[0], StanzaType.set, methodCall.toString(), params);
        if (data != null) {
            clel.addDataPacket(data);
        }
        Element check_session_el = clel.getClusterElement();
        if (!nodes[0].equals(this.getComponentId())) {
            this.fastAddOutPacket(new Packet(check_session_el));
        }
        for (int i = 1; i < nodes.length; ++i) {
            if (nodes[i].equals(this.getComponentId())) continue;
            Element elem = check_session_el.clone();
            elem.setAttribute("to", nodes[i]);
            this.fastAddOutPacket(new Packet(elem));
        }
    }

    private void broadcastUserPresence(XMPPResourceConnection conn, String ... cl_nodes) {
        try {
            Map<String, String> params = this.prepareBroadcastParams(conn, true);
            Element presence = conn.getPresence();
            this.sendBroadcastPackets(presence, params, ClusterMethods.USER_INITIAL_PRESENCE, cl_nodes);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user initial presence message for: " + conn.getConnectionId() + ", " + conn.getjid(), e);
        }
    }

    private void broadcastUserPresence(XMPPResourceConnection conn, List<String> cl_nodes) {
        try {
            Map<String, String> params = this.prepareBroadcastParams(conn, true);
            Element presence = conn.getPresence();
            if (presence == null) {
                log.log(Level.WARNING, "Something wrong. Initial presence NULL!!", Thread.currentThread().getStackTrace());
            }
            this.sendBroadcastPackets(presence, params, ClusterMethods.USER_INITIAL_PRESENCE, cl_nodes.toArray(new String[cl_nodes.size()]));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user initial presence for: " + conn.getConnectionId() + ", " + conn.getjid(), e);
        }
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
        super.handlePresenceSet(conn);
        if (conn.getConnectionStatus() == ConnectionStatus.REMOTE) {
            return;
        }
        if (conn.getSessionData(CL_BR_INITIAL_PRESENCE) == null) {
            conn.putSessionData(CL_BR_INITIAL_PRESENCE, CL_BR_INITIAL_PRESENCE);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Handle presence set for Connection ID: " + conn.getConnectionId() + ", User ID: " + conn.getjid());
            }
            List<String> cl_nodes = this.strategy.getAllNodes();
            this.broadcastUserPresence(conn, cl_nodes);
        }
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        super.handleResourceBind(conn);
        if (conn.getConnectionStatus() == ConnectionStatus.REMOTE) {
            return;
        }
        if (conn.getSessionData(CL_BR_USER_CONNECTED) == null) {
            conn.putSessionData(CL_BR_USER_CONNECTED, CL_BR_USER_CONNECTED);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Handle resource bind for Connection ID: " + conn.getConnectionId() + ", User ID: " + conn.getjid());
            }
            List<String> cl_nodes = this.strategy.getAllNodes();
            try {
                Map<String, String> params = this.prepareBroadcastParams(conn, false);
                this.sendBroadcastPackets(null, params, ClusterMethods.USER_CONNECTED, cl_nodes.toArray(new String[cl_nodes.size()]));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with broadcast user connected for: " + conn.getConnectionId() + ", " + conn.getjid(), e);
            }
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("User resourc-rebind - not implemented yet in the cluster. Connection ID: " + conn.getConnectionId() + ", User ID: " + conn.getjid());
        }
    }

    @Override
    public void release() {
        this.delayedTasks.cancel();
        super.release();
    }

    @Override
    public void start() {
        super.start();
        this.delayedTasks = new Timer("SM Cluster Delayed Tasks", true);
    }

    @Override
    public void setClusterController(ClusterController cl_controller) {
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.strategy.getStatistics(list);
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return this.strategy.hasCompleteJidsInfo();
    }

    @Override
    public boolean containsJid(String jid) {
        return super.containsJid(jid) || this.strategy.containsJid(jid);
    }

    @Override
    public String[] getConnectionIdsForJid(String jid) {
        String[] ids = super.getConnectionIdsForJid(jid);
        if (ids == null) {
            ids = this.strategy.getConnectionIdsForJid(jid);
        }
        return ids;
    }

    @Override
    public int processingThreads() {
        return Math.max(this.nodesNo, super.processingThreads());
    }

    private void requestSync(String node) {
        ClusterElement clel = ClusterElement.createClusterMethodCall(this.getComponentId(), node, StanzaType.get, ClusterMethods.SYNC_ONLINE.name(), null);
        this.fastAddOutPacket(new Packet(clel.getClusterElement()));
    }
}

