/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterController;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.server.Packet;
import tigase.server.xmppserver.ServerConnectionManager;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public class ServerConnectionClustered
extends ServerConnectionManager
implements ClusteredComponent {
    private static final Logger log = Logger.getLogger("tigase.cluster.ServerConnectionClustered");
    private static final String CID = "cid";
    private static final String KEY = "key";
    private static final String FORKEY_SESSION_ID = "forkey_sessionId";
    private static final String ASKING_SESSION_ID = "asking_sessionId";
    private static final String VALID = "valid";
    private List<String> cl_nodes_array = new CopyOnWriteArrayList<String>();

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            this.processClusterPacket(packet);
            return;
        }
        super.processPacket(packet);
    }

    protected void processClusterPacket(Packet packet) {
        ClusterElement clel = new ClusterElement(packet.getElement());
        clel.addVisitedNode(this.getComponentId());
        switch (packet.getType()) {
            case set: {
                if (!ClusterMethods.CHECK_DB_KEY.toString().equals(clel.getMethodName())) break;
                String cid = clel.getMethodParam(CID);
                String key = clel.getMethodParam(KEY);
                String forkey_sessionId = clel.getMethodParam(FORKEY_SESSION_ID);
                String asking_sessionId = clel.getMethodParam(ASKING_SESSION_ID);
                String local_key = super.getLocalDBKey(cid, key, forkey_sessionId, asking_sessionId);
                ClusterElement result = null;
                boolean valid = false;
                if (local_key != null) {
                    valid = local_key.equals(key);
                } else {
                    result = ClusterElement.createForNextNode(clel, this.cl_nodes_array, this.getComponentId());
                }
                if (result == null) {
                    LinkedHashMap<String, String> res_vals = new LinkedHashMap<String, String>();
                    res_vals.put(VALID, "" + valid);
                    result = clel.createMethodResponse(this.getComponentId(), StanzaType.result, res_vals);
                }
                this.addOutPacket(new Packet(result.getClusterElement()));
                break;
            }
            case get: {
                break;
            }
            case result: {
                if (!ClusterMethods.CHECK_DB_KEY.toString().equals(clel.getMethodName())) break;
                String cid = clel.getMethodParam(CID);
                String key = clel.getMethodParam(KEY);
                String forkey_sessionId = clel.getMethodParam(FORKEY_SESSION_ID);
                String asking_sessionId = clel.getMethodParam(ASKING_SESSION_ID);
                boolean valid = "true".equals(clel.getMethodResultVal(VALID));
                String from = JIDUtils.getNodeNick((String)cid);
                String to = JIDUtils.getNodeHost((String)cid);
                this.sendVerifyResult(from, to, forkey_sessionId, valid, this.getServerConnections(cid), asking_sessionId);
                break;
            }
            case error: {
                String from = packet.getElemFrom();
                clel.addVisitedNode(from);
                this.addOutPacket(new Packet(ClusterElement.createForNextNode(clel, this.cl_nodes_array, this.getComponentId()).getClusterElement()));
                break;
            }
        }
    }

    protected String getFirstClusterNode() {
        String cluster_node = null;
        for (String node : this.cl_nodes_array) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    @Override
    protected String getLocalDBKey(String cid, String key, String forkey_sessionId, String asking_sessionId) {
        String local_key = super.getLocalDBKey(cid, key, forkey_sessionId, asking_sessionId);
        if (local_key != null) {
            return local_key;
        }
        String cluster_node = this.getFirstClusterNode();
        if (cluster_node != null) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put(CID, cid);
            params.put(KEY, key);
            params.put(FORKEY_SESSION_ID, forkey_sessionId);
            params.put(ASKING_SESSION_ID, asking_sessionId);
            Element check_db_key = ClusterElement.createClusterMethodCall(this.getComponentId(), cluster_node, StanzaType.set, ClusterMethods.CHECK_DB_KEY.toString(), params).getClusterElement();
            this.addOutPacket(new Packet(check_db_key));
        }
        return null;
    }

    @Override
    public void nodeConnected(String node) {
        this.cl_nodes_array.add(this.getName() + "@" + node);
    }

    @Override
    public void nodeDisconnected(String node) {
        this.cl_nodes_array.remove(this.getName() + "@" + node);
    }

    @Override
    public void setClusterController(ClusterController cl_controller) {
    }
}

