/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusteredComponent;
import tigase.conf.Configurable;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public class ClusterController
extends AbstractComponentRegistrator<ClusteredComponent>
implements XMPPService,
Configurable {
    private static final Logger log = Logger.getLogger("tigase.cluster.ClusterController");
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String MY_DOMAIN_NAME_PROP_VAL = "localhost";
    private ServiceEntity serviceEntity = null;
    private Level statsLevel = Level.INFO;
    private String this_node = DNSResolver.getDefaultHostname();
    private String my_hostname = null;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "load", "Server clustering");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "load", "Server clustering"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
    }

    @Override
    public void componentAdded(ClusteredComponent component) {
        component.setClusterController(this);
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof ClusteredComponent;
    }

    @Override
    public void componentRemoved(ClusteredComponent component) {
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (this.getName().equals(JIDUtils.getNodeNick((String)jid))) {
            return this.serviceEntity.getDiscoItems(node, jid);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, JIDUtils.getNodeID((String)this.getName(), (String)jid)));
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
    }

    public void nodeConnected(String node) {
        for (ClusteredComponent comp : this.components.values()) {
            comp.nodeConnected(node);
        }
    }

    public void nodeDisconnected(String node) {
        for (ClusteredComponent comp : this.components.values()) {
            comp.nodeDisconnected(node);
        }
    }

    private Packet sendClusterNotification(String msg, String subject, String nodes) {
        String message = msg;
        if (nodes != null) {
            message = msg + "\n";
        }
        int cnt = 0;
        for (String node : nodes.split(",")) {
            message = message + "" + ++cnt + ". " + node + " connected to " + this.this_node;
        }
        Packet p_msg = Packet.getMessage(this.my_hostname, JIDUtils.getJID((String)this.getName(), (String)this.my_hostname, null), StanzaType.normal, message, subject, "xyz", this.newPacketId(null));
        return p_msg;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.my_hostname = (String)properties.get(MY_DOMAIN_NAME_PROP_KEY);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        defs.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        return defs;
    }
}

