/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1766 $
 * Last modified by $Author: kobit $
 * $Date: 2009-07-14 20:33:33 +0100 (Tue, 14 Jul 2009) $
 */

package tigase.stats;

import tigase.server.ServerComponent;

/**
 * Interface StatisticsContainer
 *
 * Objects which inherits this type can return runtime statistics. Any object
 * can collect job statistics and implementing this interface guarantees that
 * statistics will be presented in configured way to user who wants to see them.
 *
 * Created: Tue Nov 22 07:07:11 2005
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1766 $
 */
public interface StatisticsContainer extends ServerComponent {

  public void getStatistics(StatisticsList list);

}