/*  Tigase Jabber/XMPP Server
 *  Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1513 $
 * Last modified by $Author: kobit $
 * $Date: 2009-02-17 15:16:29 +0000 (Tue, 17 Feb 2009) $
 */
package tigase.server.bosh;

import java.util.TimerTask;
import tigase.server.Packet;

/**
 * Describe interface BoshSessionTaskHandler here.
 *
 *
 * Created: Sat Aug  4 10:39:21 2007
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1513 $
 */
public interface BoshSessionTaskHandler {

	TimerTask scheduleTask(BoshSession bs, long delay);

	void cancelTask(TimerTask bs);

	void writeRawData(BoshIOService ios, String data);

	boolean addOutStreamOpen(Packet packet, BoshSession bs);

	boolean addOutStreamClosed(Packet packet, BoshSession bs);

}
