/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.HashSet;
import java.util.logging.Logger;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.impl.roster.RosterAbstract;

public class RosterElement {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterElement");
    private static final String ELEM_NAME = "contact";
    private static final String JID_ATT = "jid";
    private static final String NAME_ATT = "name";
    private static final String SUBS_ATT = "subs";
    private static final String GRP_ATT = "groups";
    private RosterAbstract.SubscriptionType subscription = null;
    private String[] groups = null;
    private String name = null;
    private String jid = null;
    private boolean online = false;
    private boolean presence_sent = false;

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isPresence_sent() {
        return this.presence_sent;
    }

    public void setPresence_sent(boolean presence_sent) {
        this.presence_sent = presence_sent;
    }

    public RosterElement(String jid, String name, String[] groups) {
        this.jid = jid.toLowerCase();
        if (name == null) {
            this.name = JIDUtils.getNodeNick((String)jid);
            if (this.name == null || this.name.isEmpty()) {
                this.name = jid;
            }
        } else {
            this.name = name;
        }
        this.groups = groups;
        this.subscription = RosterAbstract.SubscriptionType.none;
    }

    public RosterElement(Element roster_el) {
        if (roster_el.getName() == ELEM_NAME) {
            this.jid = roster_el.getAttribute(JID_ATT).toLowerCase();
            this.name = roster_el.getAttribute(NAME_ATT);
            if (this.name == null || this.name.isEmpty()) {
                this.name = JIDUtils.getNodeNick((String)this.jid);
                if (this.name == null || this.name.isEmpty()) {
                    this.name = this.jid;
                }
            }
            this.subscription = roster_el.getAttribute(SUBS_ATT) == null ? RosterAbstract.SubscriptionType.none : RosterAbstract.SubscriptionType.valueOf(roster_el.getAttribute(SUBS_ATT));
        } else {
            log.warning("Incorrect roster data: " + roster_el.toString());
        }
        String grps = roster_el.getAttribute(GRP_ATT);
        if (grps != null && !grps.isEmpty()) {
            this.groups = grps.split(",");
        }
    }

    public String getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public RosterAbstract.SubscriptionType getSubscription() {
        return this.subscription;
    }

    public void setSubscription(RosterAbstract.SubscriptionType subscription) {
        this.subscription = subscription == null ? RosterAbstract.SubscriptionType.none : subscription;
    }

    public Element getRosterElement() {
        Element elem = new Element(ELEM_NAME, new String[]{JID_ATT, SUBS_ATT, NAME_ATT}, new String[]{this.jid, this.subscription.toString(), this.name});
        if (this.groups != null && this.groups.length > 0) {
            String grps = "";
            for (String group : this.groups) {
                grps = grps + group + ",";
            }
            grps = grps.substring(0, grps.length() - 1);
            elem.setAttribute(GRP_ATT, grps);
        }
        return elem;
    }

    void addGroups(String[] groups) {
        if (groups != null) {
            if (this.groups == null) {
                this.groups = groups;
            } else {
                HashSet<String> groupsSet = new HashSet<String>();
                for (String group : this.groups) {
                    groupsSet.add(group);
                }
                for (String group : groups) {
                    groupsSet.add(group);
                }
                this.groups = groupsSet.toArray(new String[groupsSet.size()]);
            }
        }
    }
}

