/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.PriorityQueue;
import tigase.util.QueueItem;

public abstract class WorkerThread
extends Thread {
    protected static final Logger log = Logger.getLogger(WorkerThread.class.getName());
    private boolean stopped = false;
    private long averageProcessingTime = 0L;
    private PriorityQueue<QueueItem> queue = null;
    private long runsCnt = 0L;

    public abstract WorkerThread getNewInstance(PriorityQueue<QueueItem> var1);

    public void setQueue(PriorityQueue<QueueItem> queue) {
        this.queue = queue;
    }

    public abstract void process(QueueItem var1);

    @Override
    public void run() {
        QueueItem item = null;
        while (!this.stopped) {
            try {
                item = this.queue.take();
                long start = System.currentTimeMillis();
                this.process(item);
                long end = System.currentTimeMillis() - start;
                if (end > 0L) {
                    this.averageProcessingTime = (this.averageProcessingTime + end) / 2L;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception during packet processing: " + item.packet.toString(), e);
            }
            ++this.runsCnt;
        }
    }

    public long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    public long getRunsCounter() {
        return this.runsCnt;
    }
}

