/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsCollector;
import tigase.stats.StatisticsProviderMBean;

public class StatisticsProvider
extends StandardMBean
implements StatisticsProviderMBean {
    private StatisticsCollector theRef;

    public StatisticsProvider(StatisticsCollector theRef) throws NotCompliantMBeanException {
        super(StatisticsProviderMBean.class, false);
        this.theRef = theRef;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "Provides the Tigase server statistics";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("AllStats")) {
            description = "Collection of statistics from all components.";
        } else if (info.getName().equals("ComponentsNames")) {
            description = "List of components names for which statistics are available";
        } else if (info.getName().equals("Name")) {
            description = "This component name - name of the statistics collector component,";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getAllStats")) {
            switch (sequence) {
                case 0: {
                    return "Statistics level, 0 - All, 500 - Medium, 800 - Minimal";
                }
            }
            return null;
        }
        if (op.getName().equals("getComponentStats")) {
            switch (sequence) {
                case 0: {
                    return "The component name to provide statistics for";
                }
                case 1: {
                    return "Statistics level, 0 - All, 500 - Medium, 800 - Minimal";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getAllStats")) {
            switch (sequence) {
                case 0: {
                    return "param0";
                }
            }
            return null;
        }
        if (op.getName().equals("getComponentStats")) {
            switch (sequence) {
                case 0: {
                    return "param0";
                }
                case 1: {
                    return "param1";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        MBeanParameterInfo[] params = info.getSignature();
        Object[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        Object[] methodSignature = new String[]{Integer.TYPE.getName()};
        if (info.getName().equals("getAllStats") && Arrays.equals(signature, methodSignature)) {
            description = "Provides statistics for all components for a given level.";
        }
        methodSignature = new String[]{String.class.getName(), Integer.TYPE.getName()};
        if (info.getName().equals("getComponentStats") && Arrays.equals(signature, methodSignature)) {
            description = "Provides statistics for a given component name and statistics level.";
        }
        return description;
    }

    @Override
    public List getComponentsNames() {
        return this.theRef.getComponentsNames();
    }

    @Override
    public String getName() {
        return this.theRef.getName();
    }

    private Map<String, String> getMapFromList(List<StatRecord> stats) {
        if (stats != null) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (StatRecord rec : stats) {
                String key = rec.getComponent() + "/" + rec.getDescription();
                String value = rec.getValue();
                if (rec.getType() == StatisticType.LIST) {
                    value = rec.getListValue().toString();
                }
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    @Override
    public Map<String, String> getAllStats(int param0) {
        return this.getMapFromList(this.theRef.getAllStats(param0));
    }

    @Override
    public Map<String, String> getComponentStats(String param0, int param1) {
        return this.getMapFromList(this.theRef.getComponentStats(param0, param1));
    }
}

