/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import tigase.util.DNSResolver;

public class SessionManagerConfig {
    public static final String PLUGINS_PROP_KEY = "plugins";
    public static final String PLUGINS_CONF_PROP_KEY = "plugins-conf";
    public static final String PLUGINS_CONCURRENCY_PROP_KEY = "plugins-concurrency";
    private static final String[] PLUGINS_NO_REG_PROP_VAL = new String[]{"jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "msgoffline", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "basic-filter", "domain-filter"};
    private static final String[] PLUGINS_TEST_PROP_VAL = new String[]{"jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "basic-filter", "domain-filter"};
    private static final String[] PLUGINS_FULL_PROP_VAL = new String[]{"jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "roster-presence", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "msgoffline", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "basic-filter", "domain-filter"};
    private static String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ANONYMOUS_DOMAINS_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] TRUSTED_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] CLUSTER_NODES_PROP_VAL = new String[]{"sess-man@localhost"};
    protected static final String ADMIN_SCRIPTS_PROP_KEY = "admin-scripts-dir";
    protected static final String ADMIN_SCRIPTS_PROP_VAL = "scripts/admin/";

    private static boolean addPlugin(LinkedHashSet<String> plugins, String plugin) {
        String[] pla = plugin.split("=");
        plugins.add(pla[0]);
        return pla.length > 1;
    }

    public static void getDefaults(Map<String, Object> props, Map<String, Object> params) {
        props.put(ADMIN_SCRIPTS_PROP_KEY, ADMIN_SCRIPTS_PROP_VAL);
        String user_repo_class = params.get("--user-db") != null ? (String)params.get("--user-db") : "tigase.db.jdbc.JDBCRepository";
        String user_repo_url = params.get("--user-db-uri") != null ? (String)params.get("--user-db-uri") : "jdbc:derby:tigase-derbydb;create=true";
        String auth_repo_class = params.get("--auth-db") != null ? (String)params.get("--auth-db") : "tigase.db.jdbc.JDBCRepository";
        String auth_repo_url = params.get("--auth-db-uri") != null ? (String)params.get("--auth-db-uri") : "jdbc:derby:tigase-derbydb;create=true";
        props.put("user-repo-class", user_repo_class);
        props.put("user-repo-url", user_repo_url);
        props.put("auth-repo-class", auth_repo_class);
        props.put("auth-repo-url", auth_repo_url);
        boolean full_comps = params.get("--auth-db") == null || params.get("--auth-db").toString().equals("mysql") || params.get("--auth-db").toString().equals("pgsql") || params.get("--auth-db").toString().equals("derby") || params.get("--auth-db").toString().equals("tigase-auth");
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        if (((Boolean)params.get("--test")).booleanValue()) {
            Collections.addAll(plugins, PLUGINS_TEST_PROP_VAL);
        } else if (full_comps) {
            Collections.addAll(plugins, PLUGINS_FULL_PROP_VAL);
        } else {
            Collections.addAll(plugins, PLUGINS_NO_REG_PROP_VAL);
        }
        String str_plugins = (String)params.get("--sm-plugins");
        String plugin_concurrency = "";
        if (str_plugins != null) {
            String[] conf_plugins;
            block4: for (String plugin : conf_plugins = str_plugins.split(",")) {
                switch (plugin.charAt(0)) {
                    case '+': {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin.substring(1))) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin.substring(1) + ",";
                        continue block4;
                    }
                    case '-': {
                        plugins.remove(plugin.substring(1));
                        continue block4;
                    }
                    default: {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin)) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin + ",";
                    }
                }
            }
        }
        props.put(PLUGINS_PROP_KEY, plugins.toArray(new String[plugins.size()]));
        props.put(PLUGINS_CONCURRENCY_PROP_KEY, plugin_concurrency);
        if (params.get("--virt-hosts") != null) {
            HOSTNAMES_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
            ANONYMOUS_DOMAINS_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
        } else {
            HOSTNAMES_PROP_VAL = DNSResolver.getDefHostNames();
            ANONYMOUS_DOMAINS_PROP_VAL = DNSResolver.getDefHostNames();
        }
        if (params.get("--admins") != null) {
            ADMINS_PROP_VAL = ((String)params.get("--admins")).split(",");
        } else {
            ADMINS_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (int i = 0; i < ADMINS_PROP_VAL.length; ++i) {
                SessionManagerConfig.ADMINS_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("admins", ADMINS_PROP_VAL);
        if (params.get("--trusted") != null) {
            TRUSTED_PROP_VAL = ((String)params.get("--trusted")).split(",");
        } else {
            TRUSTED_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (int i = 0; i < TRUSTED_PROP_VAL.length; ++i) {
                SessionManagerConfig.TRUSTED_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("trusted", TRUSTED_PROP_VAL);
    }
}

