/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Security;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import tigase.auth.TigaseSaslProvider;
import tigase.conf.Configurable;
import tigase.db.DataOverwriteException;
import tigase.db.NonAuthUserRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ReceiverEventHandler;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.AbstractAdminCommand;
import tigase.server.xmppsession.AddScriptCommand;
import tigase.server.xmppsession.AdminCommandIfc;
import tigase.server.xmppsession.PacketFilter;
import tigase.server.xmppsession.RemoveScriptCommand;
import tigase.server.xmppsession.SessionManagerConfig;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.stats.StatRecord;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.TigaseRuntime;
import tigase.util.JIDUtils;
import tigase.util.PriorityQueue;
import tigase.util.ProcessingThreads;
import tigase.util.QueueItem;
import tigase.util.WorkerThread;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.ProcessorFactory;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;

public class SessionManager
extends AbstractMessageReceiver
implements Configurable,
XMPPService,
SessionManagerHandler,
OnlineJidsReporter {
    private static final Logger log = Logger.getLogger(SessionManager.class.getName());
    protected static final String SESSION_PACKETS = "session-packets";
    protected static final String ADMIN_COMMAND_NODE = "http://jabber.org/protocol/admin";
    private UserRepository user_repository = null;
    private UserAuthRepository auth_repository = null;
    private NonAuthUserRepository naUserRepository = null;
    private PacketFilter filter = null;
    private Set<String> admins = new CopyOnWriteArraySet<String>();
    private Set<String> trusted = new CopyOnWriteArraySet<String>();
    private ConcurrentHashMap<String, XMPPSession> sessionsByNodeId = new ConcurrentHashMap();
    private ConcurrentHashMap<String, XMPPResourceConnection> connectionsByFrom = new ConcurrentHashMap();
    private Map<String, XMPPPreprocessorIfc> preProcessors = new ConcurrentSkipListMap<String, XMPPPreprocessorIfc>();
    private Map<String, ProcessingThreads<ProcessorWorkerThread>> processors = new ConcurrentSkipListMap<String, ProcessingThreads<ProcessorWorkerThread>>();
    private Map<String, XMPPPostprocessorIfc> postProcessors = new ConcurrentSkipListMap<String, XMPPPostprocessorIfc>();
    private Map<String, XMPPStopListenerIfc> stopListeners = new ConcurrentSkipListMap<String, XMPPStopListenerIfc>();
    private Map<String, Map<String, Object>> plugin_config = new ConcurrentSkipListMap<String, Map<String, Object>>();
    private Map<String, XMPPPacketFilterIfc> outFilters = new ConcurrentSkipListMap<String, XMPPPacketFilterIfc>();
    private Map<String, AdminCommandIfc> adminCommands = new ConcurrentSkipListMap<String, AdminCommandIfc>();
    private ProcessingThreads<SessionCloseWorkerThread> sessionCloseThread = new ProcessingThreads<SessionCloseWorkerThread>(new SessionCloseWorkerThread(), 4, 1, this.maxQueueSize, "session-close");
    private ProcessingThreads<SessionOpenWorkerThread> sessionOpenThread = new ProcessingThreads<SessionOpenWorkerThread>(new SessionOpenWorkerThread(this), 1, 1, this.maxQueueSize, "session-open");
    private Timer authenticationWatchdog = new Timer("SM authentocation watchdog");
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ConnectionCheckCommandHandler connectionCheckCommandHandler = new ConnectionCheckCommandHandler();
    private ServiceEntity serviceEntity = null;
    private int maxUserSessions = 0;
    private int maxUserConnections = 0;
    private long totalUserSessions = 0L;
    private long totalUserConnections = 0L;
    private long closedConnections = 0L;
    private long authTimeouts = 0L;
    private int maxPluginsNo = 0;
    private Timer reaperTask = null;
    private long reaperInterval = 60000L;
    private long maxIdleTime = 86400000L;

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "sm", "Session manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "sm", "Session manager"));
        AbstractAdminCommand command2 = new AddScriptCommand();
        command2.init("add-script", "New command script");
        this.adminCommands.put(command2.getCommandId(), command2);
        ServiceEntity item = new ServiceEntity(this.getName(), "http://jabber.org/protocol/admin#" + command2.getCommandId(), command2.getDescription());
        item.addIdentities(new ServiceIdentity("component", "generic", command2.getDescription()), new ServiceIdentity("automation", "command-node", command2.getDescription()));
        item.addFeatures(CMD_FEATURES);
        this.serviceEntity.addItems(item);
        command2 = new RemoveScriptCommand();
        command2.init("del-script", "Remove command script");
        this.adminCommands.put(command2.getCommandId(), command2);
        item = new ServiceEntity(this.getName(), "http://jabber.org/protocol/admin#" + command2.getCommandId(), command2.getDescription());
        item.addIdentities(new ServiceIdentity("component", "generic", command2.getDescription()), new ServiceIdentity("automation", "command-node", command2.getDescription()));
        item.addFeatures(CMD_FEATURES);
        this.serviceEntity.addItems(item);
        List<ScriptEngineFactory> scriptFactories = this.scriptEngineManager.getEngineFactories();
        if (scriptFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptFactories) {
                log.info("Found script engine for language: " + scriptEngineFactory.getLanguageName() + ", version: " + scriptEngineFactory.getLanguageVersion());
            }
        }
        TigaseRuntime.getTigaseRuntime().addOnlineJidsReporter(this);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(String connId) {
        return this.connectionsByFrom.get(connId);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        XMPPResourceConnection conn = null;
        String from = p.getFrom();
        if (from != null && (conn = this.connectionsByFrom.get(from)) != null) {
            return conn.getConnectionStatus() == ConnectionStatus.TEMP ? null : conn;
        }
        String to = p.getElemTo();
        if (to != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Searching for resource connection for: " + to);
            }
            if ((conn = this.getResourceConnection(to)) != null && conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                conn = null;
            }
        } else {
            log.info("Message without TO attribute set, don't know what to do wih this: " + p.getStringData());
        }
        return conn;
    }

    protected boolean isBrokenPacket(Packet p) {
        if (!p.getFrom().equals(p.getElemFrom()) && (!p.isCommand() || p.isCommand() && p.getCommand() == Command.OTHER)) {
            if (p.getElemFrom() != null && !this.isLocalDomain(JIDUtils.getNodeHost((String)p.getElemFrom()))) {
                p.setFrom(null);
                p.setTo(null);
                this.fastAddOutPacket(p);
                return true;
            }
            log.info("Broken packet: " + p.toString());
            try {
                Packet error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(p, "Service not available.", true);
                error.setTo(p.getFrom());
                this.fastAddOutPacket(error);
            }
            catch (PacketErrorTypeException e) {
                log.info("Packet processing exception: " + e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    protected void processPacket(Packet packet, XMPPResourceConnection conn) {
        packet.setTo(this.getComponentId());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processing packet: " + packet.toString() + ", connectionID: " + (conn != null ? conn.getConnectionId() : "null"));
        }
        LinkedList<Packet> results = new LinkedList<Packet>();
        boolean stop = false;
        if (!stop && this.filter.preprocess(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet preprocessed: " + packet.toString());
                if (results.size() > 0) {
                    for (Packet p : results) {
                        log.finest("Preprocess result: " + p.toString());
                    }
                }
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                stop |= preproc.preProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && this.filter.forward(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet forwarded: " + packet.toString());
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            this.walk(packet, conn, packet.getElement(), results);
        }
        if (!stop) {
            for (XMPPPostprocessorIfc postproc : this.postProcessors.values()) {
                postproc.postProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && !packet.wasProcessed() && !this.isLocalDomain(packet.getElemTo()) && this.filter.process(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-process");
        }
        this.setPermissions(conn, results);
        this.addOutPackets(packet, conn, results);
        if (!packet.wasProcessed()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet not processed: " + packet.toString());
            }
            Packet error = null;
            if (stop || conn == null && packet.getElemFrom() != null && packet.getElemTo() != null && packet.getElemTo() != this.getComponentId() && (packet.getElemName().equals("iq") || packet.getElemName().equals("message"))) {
                try {
                    error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.info("Packet processing exception: " + e + ", packet: " + packet.toString());
                }
            } else if (packet.getElemFrom() != null || conn != null) {
                try {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.info("Packet processing exception: " + e + ", packet: " + packet.toString());
                }
            }
            if (error != null) {
                if (error.getElemTo() != null) {
                    conn = this.getResourceConnection(error.getElemTo());
                }
                if (conn != null) {
                    error.setTo(conn.getConnectionId());
                }
                this.addOutPacket(error);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Packet processed by: " + packet.getProcessorsIds().toString());
        }
    }

    private void setPermissions(XMPPResourceConnection conn, Queue<Packet> results) {
        Permissions perms = Permissions.NONE;
        if (conn != null) {
            perms = Permissions.LOCAL;
            if (conn.isAuthorized()) {
                perms = Permissions.AUTH;
                if (conn.isAnonymous()) {
                    perms = Permissions.ANONYM;
                } else {
                    try {
                        String id = conn.getUserId();
                        if (this.isTrusted(id)) {
                            perms = Permissions.TRUSTED;
                        }
                        if (this.isAdmin(id)) {
                            perms = Permissions.ADMIN;
                        }
                    }
                    catch (NotAuthorizedException e) {
                        perms = Permissions.NONE;
                    }
                }
            }
        }
        for (Packet res : results) {
            res.setPermissions(perms);
        }
    }

    @Override
    public int processingThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private boolean isAdmin(String jid) {
        for (String adm : this.admins) {
            if (!adm.equals(JIDUtils.getNodeID((String)jid))) continue;
            return true;
        }
        return false;
    }

    protected boolean isTrusted(String jid) {
        if (this.trusted.contains(JIDUtils.getNodeID((String)jid))) {
            return true;
        }
        return this.isAdmin(jid);
    }

    protected boolean addTrusted(String jid) {
        return this.trusted.add(JIDUtils.getNodeID((String)jid));
    }

    protected boolean delTrusted(String jid) {
        return this.trusted.remove(JIDUtils.getNodeID((String)jid));
    }

    protected boolean processAdminsOrDomains(Packet packet) {
        String to = packet.getElemTo();
        if (this.isLocalDomain(to)) {
            if (packet.getElemName().equals("message")) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Packet for admin: " + packet.getStringData());
                }
                this.sendToAdmins(packet);
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Packet for hostname: " + packet.getStringData());
                }
                Packet host_pac = new Packet(packet.getElement().clone());
                host_pac.getElement().setAttribute("to", this.getComponentId());
                host_pac.getElement().setAttribute("oldto", packet.getElemTo());
                host_pac.getElement().setAttribute("oldfrom", packet.getElemFrom());
                this.processPacket(host_pac);
            }
            return true;
        }
        return false;
    }

    protected void sendToAdmins(Packet packet) {
        for (String admin : this.admins) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Sending packet to admin: " + admin);
            }
            Packet admin_pac = new Packet(packet.getElement().clone());
            admin_pac.getElement().setAttribute("to", admin);
            this.processPacket(admin_pac);
        }
    }

    protected XMPPSession getSession(String jid) {
        return this.sessionsByNodeId.get(JIDUtils.getNodeID((String)jid));
    }

    protected XMPPResourceConnection getResourceConnection(String jid) {
        XMPPSession session = this.getSession(jid);
        if (session != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Session not null, getting resource for jid: " + jid);
            }
            return session.getResourceConnection(jid);
        }
        return null;
    }

    private void walk(Packet packet, XMPPResourceConnection connection, Element elem, Queue<Packet> results) {
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            XMPPProcessorIfc processor;
            String xmlns = elem.getXMLNS();
            if (xmlns == null) {
                xmlns = "jabber:client";
            }
            if (!(processor = proc_t.getWorkerThread().processor).isSupporting(elem.getName(), xmlns)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XMPPProcessorIfc: " + processor.getClass().getSimpleName() + " (" + processor.id() + ")" + "\n Request: " + elem.toString() + (connection != null ? ", " + connection.getConnectionId() : " null"));
            }
            if (proc_t.addItem(packet, connection)) {
                packet.processedBy(processor.id());
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Can not add packet: " + packet.toString() + " to processor: " + proc_t.getName() + " internal queue full.");
        }
        List children = elem.getChildren();
        if (children != null) {
            for (Element child : children) {
                this.walk(packet, connection, child, results);
            }
        }
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    protected boolean processCommand(Packet pc) {
        if (pc.getElemTo() != null && !this.getComponentId().equals(pc.getElemTo()) && !this.isLocalDomain(pc.getElemTo())) {
            return false;
        }
        boolean processing_result = false;
        if (log.isLoggable(Level.FINER)) {
            log.finer(pc.getCommand().toString() + " command from: " + pc.getFrom());
        }
        XMPPResourceConnection connection = this.connectionsByFrom.get(pc.getFrom());
        switch (pc.getCommand()) {
            case STREAM_OPENED: {
                this.sessionOpenThread.addItem(pc, connection);
                processing_result = true;
                break;
            }
            case GETFEATURES: {
                if (pc.getType() == StanzaType.get) {
                    List<Element> features = this.getFeatures(this.connectionsByFrom.get(pc.getFrom()));
                    Packet result = pc.commandResult(null);
                    Command.setData(result, features);
                    this.addOutPacket(result);
                }
                processing_result = true;
                break;
            }
            case STREAM_CLOSED: {
                this.fastAddOutPacket(pc.okResult((String)null, 0));
                this.sessionCloseThread.addItem(pc, null);
                processing_result = true;
                break;
            }
            case STREAM_CLOSED_UPDATE: {
                if (this.connectionsByFrom.get(pc.getFrom()) != null) {
                    this.sessionCloseThread.addItem(pc, null);
                }
                processing_result = true;
                break;
            }
            case BROADCAST_TO_ONLINE: {
                String from = pc.getFrom();
                boolean trusted = false;
                try {
                    trusted = from != null && this.isTrusted(from) || connection != null && this.isTrusted(connection.getUserId());
                }
                catch (NotAuthorizedException e) {
                    trusted = false;
                }
                try {
                    if (trusted) {
                        List<Element> packets = Command.getData(pc);
                        if (packets != null) {
                            for (XMPPResourceConnection conn : this.connectionsByFrom.values()) {
                                if (!conn.isAuthorized()) continue;
                                try {
                                    for (Element el_pack : packets) {
                                        Element el_copy = el_pack.clone();
                                        el_copy.setAttribute("to", conn.getJID());
                                        Packet out_packet = new Packet(el_copy);
                                        out_packet.setTo(conn.getConnectionId());
                                        this.addOutPacket(out_packet);
                                    }
                                }
                                catch (NotAuthorizedException e) {
                                    log.warning("Something wrong, connection is authenticated but NoAuthorizedException is thrown.");
                                }
                            }
                        } else {
                            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(pc, "Missing packets for broadcast.", true));
                        }
                    } else {
                        this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(pc, "You don't have enough permission to brodcast packet.", true));
                    }
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e + ", packet: " + pc.toString());
                }
                processing_result = true;
                break;
            }
            case USER_STATUS: {
                try {
                    if (this.isTrusted(pc.getElemFrom()) || this.isTrusted(JIDUtils.getNodeHost((String)pc.getElemFrom()))) {
                        boolean available;
                        String av = Command.getFieldValue(pc, "available");
                        boolean bl = available = av == null || !av.equalsIgnoreCase("false");
                        if (available) {
                            Packet presence = null;
                            Element p = pc.getElement().getChild("command").getChild("presence");
                            if (p != null) {
                                Element elem = p.clone();
                                elem.setXMLNS("jabber:client");
                                presence = new Packet(elem);
                            }
                            if ((connection = this.connectionsByFrom.get(pc.getElemFrom())) == null) {
                                String user_jid = Command.getFieldValue(pc, "jid");
                                String hostname = JIDUtils.getNodeHost((String)user_jid);
                                connection = this.loginUserSession(pc.getElemFrom(), hostname, JIDUtils.getNodeID((String)user_jid), JIDUtils.getNodeResource((String)user_jid), ConnectionStatus.NORMAL, "USER_STATUS");
                                connection.putSessionData("jingle", "active");
                                this.fastAddOutPacket(pc.okResult((String)null, 0));
                                if (presence == null) {
                                    presence = new Packet(new Element("presence", new Element[]{new Element("priority", "-1"), new Element("c", new String[]{"node", "ver", "ext", "xmlns"}, new String[]{"http://www.google.com/xmpp/client/caps", XMPPServer.getImplementationVersion(), "voice-v1", "http://jabber.org/protocol/caps"})}, null, null));
                                }
                            } else if (log.isLoggable(Level.FINEST)) {
                                log.finest("USER_STATUS set to true for user who is already available: " + pc.toString());
                            }
                            if (presence != null) {
                                presence.setFrom(pc.getElemFrom());
                                presence.setTo(this.getComponentId());
                                this.addOutPacket(presence);
                            }
                        } else {
                            connection = this.connectionsByFrom.remove(pc.getElemFrom());
                            if (connection != null) {
                                this.closeSession(connection, false);
                                this.addOutPacket(pc.okResult((String)null, 0));
                            } else {
                                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(pc, "The user resource you want to remove does not exist.", true));
                                log.info("Can not find resource connection for packet: " + pc.toString());
                            }
                        }
                    } else {
                        try {
                            this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(pc, "Only trusted entity can do it.", true));
                        }
                        catch (PacketErrorTypeException e) {
                            log.warning("Packet error type when not expected: " + pc.toString());
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        this.addOutPacket(Authorization.UNDEFINED_CONDITION.getResponseMessage(pc, "Unexpected error occured during the request: " + e, true));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    log.log(Level.WARNING, "USER_STATUS session creation error: ", e);
                }
                processing_result = true;
                break;
            }
            case REDIRECT: {
                if (connection != null) {
                    String action = Command.getFieldValue(pc, "action");
                    if (action.equals("close")) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Closing redirected connections: " + pc.getFrom());
                        }
                        this.sendAllOnHold(connection);
                        this.closeConnection(pc.getFrom(), true);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.fine("Activating redirected connections: " + pc.getFrom());
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("Redirect for non-existen connection: " + pc.toString());
                }
                processing_result = true;
                break;
            }
            case OTHER: {
                String strCommand = pc.getStrCommand();
                if (strCommand != null && strCommand.contains(ADMIN_COMMAND_NODE)) {
                    Command.Action action = Command.getAction(pc);
                    if (action != Command.Action.cancel) {
                        boolean admin = false;
                        try {
                            boolean bl = admin = connection != null && connection.isAuthorized() && this.isAdmin(connection.getUserId());
                            if (admin) {
                                int hashIdx;
                                String scriptId;
                                AdminCommandIfc com;
                                if (log.isLoggable(Level.FINER)) {
                                    log.finer("Processing admin command: " + pc.toString());
                                }
                                if ((com = this.adminCommands.get(scriptId = strCommand.substring((hashIdx = strCommand.indexOf(35)) + 1))) == null) {
                                    Packet result = pc.commandResult(Command.DataType.result);
                                    Command.addTextField(result, "Error", "The command: " + scriptId + " is not available yet.");
                                    this.fastAddOutPacket(result);
                                } else {
                                    Bindings binds = this.scriptEngineManager.getBindings();
                                    this.initBindings(binds);
                                    LinkedList<Packet> results = new LinkedList<Packet>();
                                    com.runCommand(pc, binds, results);
                                    this.addOutPackets(results);
                                }
                            }
                        }
                        catch (NotAuthorizedException e) {
                            admin = false;
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Unknown admin command processing exception: " + pc.toString(), e);
                        }
                        if (!admin) {
                            try {
                                if (log.isLoggable(Level.FINER)) {
                                    log.finer("Command rejected non-admin detected: " + (connection != null ? connection.isAuthorized() + ": " + connection.getUserId() : "null"));
                                }
                                this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(pc, "Only Administrator can call the command.", true));
                            }
                            catch (Exception e) {
                                log.info("Problem sending FORBIDDEN error: " + e + ", packet: " + pc.toString());
                            }
                        }
                    } else {
                        Packet result = pc.commandResult(Command.DataType.result);
                        Command.addTextField(result, "Note", "Command canceled.");
                        this.fastAddOutPacket(result);
                    }
                    processing_result = true;
                    break;
                }
                log.info("Other command found: " + pc.getStrCommand());
                break;
            }
        }
        return processing_result;
    }

    private void initBindings(Bindings binds) {
        binds.put("adminCommands", (Object)this.adminCommands);
        binds.put("authRepository", (Object)this.auth_repository);
        binds.put("userConnections", (Object)this.connectionsByFrom);
        binds.put("userRepository", (Object)this.user_repository);
        binds.put("userSessions", (Object)this.sessionsByNodeId);
        binds.put("adminDisco", (Object)this.serviceEntity);
        binds.put("scriptManager", (Object)this.scriptEngineManager);
    }

    protected void sendAllOnHold(XMPPResourceConnection conn) {
        String remote_smId = (String)conn.getSessionData("redirect-to");
        LinkedList packets = (LinkedList)conn.getSessionData(SESSION_PACKETS);
        if (remote_smId == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("No address for remote SM to redirect packets, processing locally.");
            }
            if (packets != null) {
                Packet sess_pack = null;
                while ((sess_pack = (Packet)packets.poll()) != null && conn.getConnectionStatus() != ConnectionStatus.ON_HOLD) {
                    this.processPacket(sess_pack);
                }
            }
            return;
        }
        conn.setConnectionStatus(ConnectionStatus.REDIRECT);
        if (packets != null) {
            Packet sess_pack = null;
            while ((sess_pack = (Packet)packets.poll()) != null) {
                sess_pack.setTo(remote_smId);
                this.fastAddOutPacket(sess_pack);
            }
        }
    }

    protected void closeConnection(String connectionId, boolean closeOnly) {
        XMPPResourceConnection connection;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed from: " + connectionId);
        }
        if ((connection = this.connectionsByFrom.remove(connectionId)) != null) {
            this.closeSession(connection, closeOnly);
        } else {
            log.fine("Can not find resource connection for packet: " + connectionId);
        }
    }

    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (!closeOnly) {
            LinkedList<Packet> results = new LinkedList<Packet>();
            for (XMPPStopListenerIfc stopProc : this.stopListeners.values()) {
                stopProc.stopped(conn, results, this.plugin_config.get(stopProc.id()));
            }
            this.addOutPackets(null, conn, results);
        }
        try {
            if (conn.isAuthorized() || conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                XMPPSession session;
                String userId = conn.getUserId();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Closing connection for: " + userId);
                }
                if ((session = conn.getParentSession()) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Found parent session for: " + userId);
                    }
                    if (session.getActiveResourcesSize() <= 1) {
                        session = this.sessionsByNodeId.remove(userId);
                        if (session == null) {
                            log.info("UPS can't remove, session not found in map: " + userId);
                        } else if (log.isLoggable(Level.FINER)) {
                            log.finer("Number of user sessions: " + this.sessionsByNodeId.size());
                        }
                        if (conn.getConnectionStatus() == ConnectionStatus.NORMAL) {
                            this.auth_repository.logout(userId);
                        }
                    } else if (log.isLoggable(Level.FINER)) {
                        StringBuilder sb = new StringBuilder();
                        for (XMPPResourceConnection res_con : session.getActiveResources()) {
                            sb.append(", res=" + res_con.getResource() + " (" + (Object)((Object)res_con.getConnectionStatus()) + ")");
                        }
                        log.finer("Number of connections is " + session.getActiveResourcesSize() + " for the user: " + userId + sb.toString());
                    }
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.info("Closed not authorized session: " + e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception closing session... ", e);
        }
        ++this.closedConnections;
        conn.streamClosed();
    }

    @Override
    protected boolean addOutPacket(Packet packet) {
        String oldfrom;
        String oldto = packet.getAttribute("oldto");
        if (oldto != null) {
            packet.getElement().setAttribute("from", oldto);
            packet.getElement().removeAttribute("oldto");
        }
        if ((oldfrom = packet.getAttribute("oldfrom")) != null) {
            packet.getElement().setAttribute("to", oldfrom);
            packet.getElement().removeAttribute("oldfrom");
        }
        return super.addOutPacket(packet);
    }

    protected boolean fastAddOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    protected void addOutPackets(Packet packet, XMPPResourceConnection conn, Queue<Packet> results) {
        for (XMPPPacketFilterIfc outfilter : this.outFilters.values()) {
            outfilter.filter(packet, conn, this.naUserRepository, results);
        }
        this.addOutPackets(results);
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            Element[] features = proc_t.getWorkerThread().processor.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        SessionManagerConfig.getDefaults(props, params);
        return props;
    }

    private void addPlugin(String plug_id, Integer conc) {
        XMPPPacketFilterIfc filterproc;
        XMPPStopListenerIfc stoplist;
        XMPPPostprocessorIfc postproc;
        XMPPPreprocessorIfc preproc;
        XMPPProcessorIfc proc = ProcessorFactory.getProcessor(plug_id);
        int concurrency = conc != null ? conc : (proc != null ? proc.concurrentQueuesNo() : 0);
        System.out.println("Loading plugin: " + plug_id + "=" + concurrency + " ...");
        boolean loaded = false;
        if (proc != null) {
            ProcessorWorkerThread worker = new ProcessorWorkerThread(proc);
            ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, concurrency, proc.concurrentThreadsPerQueue(), this.maxQueueSize, proc.id());
            this.processors.put(plug_id, pt);
            log.config("Added processor: " + proc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((preproc = ProcessorFactory.getPreprocessor(plug_id)) != null) {
            this.preProcessors.put(plug_id, preproc);
            log.config("Added preprocessor: " + preproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((postproc = ProcessorFactory.getPostprocessor(plug_id)) != null) {
            this.postProcessors.put(plug_id, postproc);
            log.config("Added postprocessor: " + postproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((stoplist = ProcessorFactory.getStopListener(plug_id)) != null) {
            this.stopListeners.put(plug_id, stoplist);
            log.config("Added stopped processor: " + stoplist.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((filterproc = ProcessorFactory.getPacketFilter(plug_id)) != null) {
            this.outFilters.put(plug_id, filterproc);
            log.config("Added packet filter: " + filterproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if (!loaded) {
            log.warning("No implementation found for plugin id: " + plug_id);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String[] trusted_tmp;
        String res_uri;
        String cls_name;
        String[] nodes;
        super.setProperties(props);
        Security.insertProviderAt(new TigaseSaslProvider(), 6);
        this.filter = new PacketFilter();
        this.user_repository = (UserRepository)props.get("shared-user-repo-pool");
        if (this.user_repository == null) {
            this.user_repository = (UserRepository)props.get("shared-user-repo");
        } else {
            log.config("Using shared repository pool.");
        }
        this.auth_repository = (UserAuthRepository)props.get("shared-auth-repo");
        if (this.user_repository != null) {
            log.config("Using shared auth repository instance.");
        } else {
            LinkedHashMap<String, String> user_repo_params = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (!entry.getKey().startsWith("user-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                user_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                cls_name = (String)props.get("user-repo-class");
                res_uri = (String)props.get("user-repo-url");
                this.user_repository = RepositoryFactory.getUserRepository(this.getName(), cls_name, res_uri, user_repo_params);
                log.config("Initialized " + cls_name + " as user repository: " + res_uri);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize user repository: ", e);
            }
        }
        if (this.auth_repository != null) {
            log.config("Using shared auth repository.");
        } else {
            LinkedHashMap<String, String> auth_repo_params = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (!entry.getKey().startsWith("auth-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                auth_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                cls_name = (String)props.get("auth-repo-class");
                res_uri = (String)props.get("auth-repo-url");
                this.auth_repository = RepositoryFactory.getAuthRepository(this.getName(), cls_name, res_uri, auth_repo_params);
                log.config("Initialized " + cls_name + " as auth repository: " + res_uri);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize auth repository: ", e);
            }
        }
        this.naUserRepository = new NARepository(this.user_repository);
        LinkedHashMap<String, Integer> plugins_concurrency = new LinkedHashMap<String, Integer>();
        String[] plugins_conc = ((String)props.get("plugins-concurrency")).split(",");
        if (plugins_conc != null && plugins_conc.length > 0) {
            for (String plugc : plugins_conc) {
                if (plugc.trim().isEmpty()) continue;
                String[] pc = plugc.split("=");
                try {
                    int conc = Integer.parseInt(pc[1]);
                    plugins_concurrency.put(pc[0], conc);
                    log.config("Concurrency for plugin: " + pc[0] + " set to: " + conc);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Plugin concurrency parsing error for: " + plugc + ", ", e);
                }
            }
        }
        String[] plugins = (String[])props.get("plugins");
        this.maxPluginsNo = plugins.length;
        this.processors.clear();
        for (String plug_id : plugins) {
            if (plug_id.equals("presence")) {
                log.warning("Your configuration is outdated! Note 'presence' and 'jaber:iq:roster' plugins are no longer exist. Use 'roster-presence' plugin instead, loading automaticly...");
                plug_id = "roster-presence";
            }
            this.addPlugin(plug_id, (Integer)plugins_concurrency.get(plug_id));
            ConcurrentSkipListMap<String, Object> plugin_settings = new ConcurrentSkipListMap<String, Object>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes2;
                if (!entry.getKey().startsWith("plugins-conf") || (nodes2 = entry.getKey().split("/")).length <= 2) continue;
                Object[] ids = nodes2[1].split(",");
                Arrays.sort(ids);
                if (Arrays.binarySearch(ids, plug_id) < 0) continue;
                plugin_settings.put(nodes2[2], entry.getValue());
            }
            if (plugin_settings.size() <= 0) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(((Object)plugin_settings).toString());
            }
            this.plugin_config.put(plug_id, plugin_settings);
        }
        this.registerNewSession(this.getComponentId(), this.createUserSession("NULL", this.getDefHostName()));
        String[] admins_tmp = (String[])props.get("admins");
        if (admins_tmp != null) {
            for (String admin : admins_tmp) {
                this.admins.add(admin);
            }
        }
        if ((trusted_tmp = (String[])props.get("trusted")) != null) {
            for (String trust : trusted_tmp) {
                this.trusted.add(trust);
            }
        }
        String descrStr = "AS:Description: ";
        String cmdIdStr = "AS:CommandId: ";
        String scriptsPath = (String)props.get("admin-scripts-dir");
        File file = null;
        AddScriptCommand addCommand = new AddScriptCommand();
        Bindings binds = this.scriptEngineManager.getBindings();
        this.initBindings(binds);
        try {
            File adminDir = new File(scriptsPath);
            for (File f : adminDir.listFiles()) {
                int idx;
                String cmdId = null;
                String cmdDescr = null;
                file = f;
                StringBuilder sb = new StringBuilder();
                BufferedReader buffr = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = buffr.readLine()) != null) {
                    sb.append(line + "\n");
                    idx = line.indexOf(descrStr);
                    if (idx >= 0) {
                        cmdDescr = line.substring(idx + descrStr.length());
                    }
                    if ((idx = line.indexOf(cmdIdStr)) < 0) continue;
                    cmdId = line.substring(idx + cmdIdStr.length());
                }
                buffr.close();
                if (cmdId == null || cmdDescr == null) {
                    log.warning("Admin script found but it has no command ID or command description: " + file);
                    continue;
                }
                idx = file.toString().lastIndexOf(".");
                String ext = file.toString().substring(idx + 1);
                addCommand.addAdminScript(cmdId, cmdDescr, sb.toString(), null, ext, binds);
                log.config("Loaded admin command from file: " + file + ", id: " + cmdId + ", ext: " + ext + ", descr: " + cmdDescr);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't load the admin script file: " + file, e);
        }
    }

    @Override
    public boolean handlesLocalDomains() {
        return true;
    }

    protected XMPPResourceConnection createUserSession(String conn_id, String domain) {
        XMPPResourceConnection connection = new XMPPResourceConnection(conn_id, this.user_repository, this.auth_repository, this);
        VHostItem vitem = null;
        if (domain != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting hostname " + domain + " for connection: " + conn_id);
            }
            vitem = this.getVHostItem(domain);
        }
        if (vitem == null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Can't get VHostItem for domain: " + domain + ", using default one instead: " + this.getDefHostName());
            }
            vitem = new VHostItem(this.getDefHostName());
        }
        connection.setDomain(vitem.getUnmodifiableVHostItem());
        this.connectionsByFrom.put(conn_id, connection);
        int currSize = this.connectionsByFrom.size();
        if (currSize > this.maxUserConnections) {
            this.maxUserConnections = currSize;
        }
        ++this.totalUserConnections;
        return connection;
    }

    protected XMPPResourceConnection loginUserSession(String conn_id, String domain, String user_id, String resource, ConnectionStatus conn_st, String xmpp_sessionId) {
        try {
            XMPPResourceConnection conn = this.createUserSession(conn_id, domain);
            conn.setSessionId(xmpp_sessionId);
            this.user_repository.setData(user_id, "tokens", xmpp_sessionId, conn_id);
            Authorization auth = conn.loginToken(user_id, xmpp_sessionId, conn_id);
            if (auth == Authorization.AUTHORIZED) {
                this.handleLogin(JIDUtils.getNodeNick((String)user_id), conn);
                if (resource != null) {
                    conn.setResource(resource);
                }
            } else {
                this.connectionsByFrom.remove(conn_id);
                return null;
            }
            conn.setConnectionStatus(conn_st);
            return conn;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem logging user: " + user_id + "/" + resource, ex);
            return null;
        }
    }

    protected void registerNewSession(String userId, XMPPResourceConnection conn) {
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session == null) {
            session = new XMPPSession(JIDUtils.getNodeNick((String)userId));
            this.sessionsByNodeId.put(userId, session);
            int currSize = this.sessionsByNodeId.size();
            if (currSize > this.maxUserSessions) {
                this.maxUserSessions = currSize;
            }
            ++this.totalUserSessions;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created new XMPPSession for: " + userId);
            }
        } else {
            List<XMPPResourceConnection> connections = session.getActiveResources();
            if (connections != null) {
                for (XMPPResourceConnection connection : connections) {
                    if (connection == conn) continue;
                    this.addOutPacketWithTimeout(Command.CHECK_USER_CONNECTION.getPacket(this.getComponentId(), connection.getConnectionId(), StanzaType.get, UUID.randomUUID().toString()), this.connectionCheckCommandHandler, 30L, TimeUnit.SECONDS);
                }
            }
        }
        session.addResourceConnection(conn);
    }

    @Override
    public void handleLogin(String userName, XMPPResourceConnection conn) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("handleLogin called for: " + userName + ", conn_id: " + conn.getConnectionId());
        }
        String userId = JIDUtils.getNodeID((String)userName, (String)conn.getDomain());
        this.registerNewSession(userId, conn);
        conn.setConnectionStatus(ConnectionStatus.NORMAL);
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
    }

    @Override
    public void handleLogout(String userName, XMPPResourceConnection conn) {
        String domain = conn.getDomain();
        String userId = JIDUtils.getNodeID((String)userName, (String)domain);
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session != null && session.getActiveResourcesSize() <= 1) {
            this.sessionsByNodeId.remove(userId);
        }
        this.connectionsByFrom.remove(conn.getConnectionId());
        this.fastAddOutPacket(Command.CLOSE.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId()));
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && (this.getName().equals(JIDUtils.getNodeNick((String)jid)) || this.isLocalDomain(jid))) {
            Element query = this.serviceEntity.getDiscoInfo(node);
            if (node == null) {
                for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
                    Element[] discoFeatures = proc_t.getWorkerThread().processor.supDiscoFeatures(null);
                    if (discoFeatures == null) continue;
                    query.addChildren(Arrays.asList(discoFeatures));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found disco info: " + (query != null ? query.toString() : null));
            }
            return query;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Not found disco info for node: " + node + ", jid: " + jid);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        LinkedList<Element> features = new LinkedList<Element>();
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            Element[] discoFeatures = proc_t.getWorkerThread().processor.supDiscoFeatures(null);
            if (discoFeatures == null) continue;
            features.addAll(Arrays.asList(discoFeatures));
        }
        return features;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        List<Element> result = this.serviceEntity.getDiscoItems(node, jid);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Found disco items: " + (result != null ? result.toString() : null));
        }
        return result;
    }

    @Override
    public List<StatRecord> getStatistics() {
        List<StatRecord> stats = super.getStatistics();
        stats.add(new StatRecord(this.getName(), "Registered accounts", "long", this.user_repository.getUsersCount(), Level.FINEST));
        stats.add(new StatRecord(this.getName(), "Open user connections", "int", this.connectionsByFrom.size(), Level.INFO));
        stats.add(new StatRecord(this.getName(), "Maximum user connections", "int", this.maxUserConnections, Level.INFO));
        stats.add(new StatRecord(this.getName(), "Total user connections", "long", this.totalUserConnections, Level.FINER));
        stats.add(new StatRecord(this.getName(), "Closed user connections", "long", this.closedConnections, Level.FINER));
        stats.add(new StatRecord(this.getName(), "Open user sessions", "int", this.sessionsByNodeId.size(), Level.FINE));
        stats.add(new StatRecord(this.getName(), "Maximum user sessions", "int", this.maxUserSessions, Level.FINE));
        stats.add(new StatRecord(this.getName(), "Total user sessions", "long", this.totalUserSessions, Level.FINER));
        if (this.authTimeouts > 0L) {
            stats.add(new StatRecord(this.getName(), "Authentication timouts", "long", this.authTimeouts, Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), "Authentication timouts", "long", this.authTimeouts, Level.FINEST));
        }
        for (Map.Entry<String, ProcessingThreads<ProcessorWorkerThread>> procent : this.processors.entrySet()) {
            ProcessingThreads<ProcessorWorkerThread> proc = procent.getValue();
            if (proc.getTotalQueueSize() > 0 || proc.getDroppedPackets() > 0L) {
                stats.add(new StatRecord(this.getName(), "Processor: " + procent.getKey(), "String", "Queue: " + proc.getTotalQueueSize() + ", AvTime: " + proc.getAverageProcessingTime() + ", Runs: " + proc.getTotalRuns() + ", Lost: " + proc.getDroppedPackets(), Level.INFO));
                continue;
            }
            stats.add(new StatRecord(this.getName(), "Processor: " + procent.getKey(), "String", "Queue: " + proc.getTotalQueueSize() + ", AvTime: " + proc.getAverageProcessingTime() + ", Runs: " + proc.getTotalRuns() + ", Lost: " + proc.getDroppedPackets(), Level.FINEST));
        }
        if (this.sessionCloseThread.getTotalQueueSize() > 0 || this.sessionCloseThread.getDroppedPackets() > 0L) {
            stats.add(new StatRecord(this.getName(), "Processor: " + this.sessionCloseThread.getName(), "String", "Queue: " + this.sessionCloseThread.getTotalQueueSize() + ", AvTime: " + this.sessionCloseThread.getAverageProcessingTime() + ", Runs: " + this.sessionCloseThread.getTotalRuns() + ", Lost: " + this.sessionCloseThread.getDroppedPackets(), Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), "Processor: " + this.sessionCloseThread.getName(), "String", "Queue: " + this.sessionCloseThread.getTotalQueueSize() + ", AvTime: " + this.sessionCloseThread.getAverageProcessingTime() + ", Runs: " + this.sessionCloseThread.getTotalRuns() + ", Lost: " + this.sessionCloseThread.getDroppedPackets(), Level.FINEST));
        }
        if (this.sessionOpenThread.getTotalQueueSize() > 0 || this.sessionOpenThread.getDroppedPackets() > 0L) {
            stats.add(new StatRecord(this.getName(), "Processor: " + this.sessionOpenThread.getName(), "String", "Queue: " + this.sessionOpenThread.getTotalQueueSize() + ", AvTime: " + this.sessionOpenThread.getAverageProcessingTime() + ", Runs: " + this.sessionOpenThread.getTotalRuns() + ", Lost: " + this.sessionOpenThread.getDroppedPackets(), Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), "Processor: " + this.sessionOpenThread.getName(), "String", "Queue: " + this.sessionOpenThread.getTotalQueueSize() + ", AvTime: " + this.sessionOpenThread.getAverageProcessingTime() + ", Runs: " + this.sessionOpenThread.getTotalRuns() + ", Lost: " + this.sessionOpenThread.getDroppedPackets(), Level.FINEST));
        }
        return stats;
    }

    @Override
    public boolean isLocalDomain(String domain, boolean includeComponents) {
        if (includeComponents) {
            return this.isLocalDomainOrComponent(domain);
        }
        return this.isLocalDomain(domain);
    }

    @Override
    public Set<String> getOnlineJids() {
        return this.sessionsByNodeId.keySet();
    }

    private static class NARepository
    implements NonAuthUserRepository {
        UserRepository rep = null;

        NARepository(UserRepository userRep) {
            this.rep = userRep;
        }

        private String calcNode(String base, String subnode) {
            if (subnode == null) {
                return base;
            }
            return base + "/" + subnode;
        }

        @Override
        public String getPublicData(String user, String subnode, String key, String def) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getData(user, this.calcNode("public", subnode), key, def) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public String[] getPublicDataList(String user, String subnode, String key) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getDataList(user, this.calcNode("public", subnode), key) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public void addOfflineDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException {
            try {
                if (!this.rep.userExists(user)) {
                    throw new UserNotFoundException("User: " + user + " has not been found inthe repository.");
                }
                this.rep.addDataList(user, this.calcNode("offline", subnode), key, list);
            }
            catch (UserNotFoundException e) {
                log.info("User not found in repository: " + user);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }

        @Override
        public void addOfflineData(String user, String subnode, String key, String value) throws UserNotFoundException, DataOverwriteException {
            String node = this.calcNode("offline", subnode);
            try {
                String data = this.rep.getData(user, node, key);
                if (data != null) {
                    throw new DataOverwriteException("Not authorized attempt to overwrite data.");
                }
                this.rep.setData(user, node, key, value);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }
    }

    private class ConnectionCheckCommandHandler
    implements ReceiverEventHandler {
        private ConnectionCheckCommandHandler() {
        }

        @Override
        public void timeOutExpired(Packet packet) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Connection checker timeout expired, closing connection: " + packet.getTo());
            }
            SessionManager.this.closeConnection(packet.getTo(), false);
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (response.getType() == StanzaType.error) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Connection checker error received, closing connection: " + packet.getTo());
                }
                SessionManager.this.closeConnection(packet.getTo(), false);
            }
        }
    }

    private class AuthenticationTimer
    extends TimerTask {
        private String connId = null;

        private AuthenticationTimer(String connId) {
            this.connId = connId;
        }

        @Override
        public void run() {
            XMPPResourceConnection conn = (XMPPResourceConnection)SessionManager.this.connectionsByFrom.get(this.connId);
            if (conn != null && !conn.isAuthorized()) {
                SessionManager.this.connectionsByFrom.remove(this.connId);
                ++SessionManager.this.authTimeouts;
                log.info("Authentication timeout expired, closing connection: " + this.connId);
                SessionManager.this.fastAddOutPacket(Command.CLOSE.getPacket(SessionManager.this.getComponentId(), this.connId, StanzaType.set, conn.nextStanzaId()));
            }
        }
    }

    private class ProcessorWorkerThread
    extends WorkerThread {
        private XMPPProcessorIfc processor = null;
        private LinkedList<Packet> local_results = new LinkedList();

        public ProcessorWorkerThread(XMPPProcessorIfc processor) {
            this.processor = processor;
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueue<QueueItem> queue) {
            ProcessorWorkerThread worker = new ProcessorWorkerThread(this.processor);
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            try {
                if (item.conn != null) {
                    this.processor.process(item.packet, item.conn, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                    SessionManager.this.setPermissions(item.conn, this.local_results);
                } else {
                    this.processor.process(item.packet, null, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                }
                SessionManager.this.addOutPackets(item.packet, item.conn, this.local_results);
            }
            catch (PacketErrorTypeException e) {
                log.info("Already error packet, ignoring: " + item.packet.toString());
            }
            catch (XMPPException e) {
                log.log(Level.WARNING, "Exception during packet processing: " + item.packet.toString(), e);
            }
        }
    }

    private class SessionCloseWorkerThread
    extends WorkerThread {
        private SessionCloseWorkerThread() {
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueue<QueueItem> queue) {
            SessionCloseWorkerThread worker = new SessionCloseWorkerThread();
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            SessionManager.this.closeConnection(item.packet.getFrom(), false);
        }
    }

    private class SessionOpenWorkerThread
    extends WorkerThread {
        private SessionManager sm = null;

        public SessionOpenWorkerThread(SessionManager sm) {
            this.sm = sm;
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueue<QueueItem> queue) {
            SessionOpenWorkerThread worker = new SessionOpenWorkerThread(this.sm);
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            if (item.conn == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Adding resource connection for: " + item.packet.getFrom());
                }
                String hostname = Command.getFieldValue(item.packet, "hostname");
                item.conn = SessionManager.this.createUserSession(item.packet.getFrom(), hostname);
                SessionManager.this.authenticationWatchdog.schedule((TimerTask)new AuthenticationTimer(item.packet.getFrom()), 120000L);
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Stream opened for existing session, authorized: " + item.conn.isAuthorized());
            }
            item.conn.setSessionId(Command.getFieldValue(item.packet, "session-id"));
            item.conn.setDefLang(Command.getFieldValue(item.packet, "xml:lang"));
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting session-id " + item.conn.getSessionId() + " for connection: " + item.conn.getConnectionId());
            }
            SessionManager.this.fastAddOutPacket(item.packet.okResult((String)null, 0));
        }
    }
}

