/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.ConnectionHandlerIfc;
import tigase.xmpp.XMPPIOService;

public class ServerConnections {
    private static final Logger log = Logger.getLogger("tigase.server.xmppserver.ServerConnections");
    private XMPPIOService outgoing = null;
    private OutgoingState conn_state = OutgoingState.NULL;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> waitingControlPackets = new ConcurrentLinkedQueue();
    private ConcurrentSkipListMap<String, String> db_keys = new ConcurrentSkipListMap();
    private long sentPackets = 0L;
    private long receivedPackets = 0L;
    private String cid = null;
    private ConnectionHandlerIfc handler = null;
    private long creationTime = System.currentTimeMillis();

    public ServerConnections(ConnectionHandlerIfc handler, String cid) {
        this.handler = handler;
        this.cid = cid;
    }

    public String getCID() {
        return this.cid;
    }

    public synchronized boolean sendPacket(Packet packet) {
        boolean result = false;
        if (this.outgoing != null && this.outgoing.isConnected() && this.conn_state == OutgoingState.OK) {
            result = this.handler.writePacketToSocket(this.outgoing, packet);
            if (!result) {
                this.outgoing.forceStop();
                this.outgoing = null;
            } else {
                ++this.sentPackets;
            }
        }
        if (!result) {
            this.addDataPacket(packet);
        }
        return result;
    }

    public OutgoingState getOutgoingState() {
        return this.conn_state;
    }

    public int getDBKeysSize() {
        return this.db_keys.size();
    }

    public synchronized boolean sendControlPacket(Packet packet) {
        boolean result = false;
        if (this.outgoing != null && this.outgoing.isConnected() && (this.conn_state == OutgoingState.OK || this.conn_state == OutgoingState.HANDSHAKING) && !(result = this.handler.writePacketToSocket(this.outgoing, packet))) {
            this.outgoing.forceStop();
            this.outgoing = null;
        }
        if (!result) {
            this.addControlPacket(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Inserted to waiting queue packet: " + packet.toString());
            }
        }
        return result;
    }

    public boolean outgoingIsNull() {
        return this.outgoing == null;
    }

    public void addDataPacket(Packet packet) {
        if (this.waitingPackets.size() == 0) {
            this.creationTime = System.currentTimeMillis();
        }
        this.waitingPackets.offer(packet);
    }

    public long waitingTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public void addControlPacket(Packet packet) {
        this.waitingControlPackets.offer(packet);
    }

    public boolean needsConnection() {
        return this.conn_state == OutgoingState.NULL;
    }

    public void setConnecting() {
        this.conn_state = OutgoingState.CONNECTING;
    }

    public void setValid() {
        this.conn_state = OutgoingState.OK;
    }

    public synchronized boolean sendAllControlPackets() {
        this.handler.writePacketsToSocket(this.outgoing, this.waitingControlPackets);
        return true;
    }

    public synchronized boolean handleDialbackSuccess() {
        if (this.outgoing != null && this.conn_state == OutgoingState.HANDSHAKING) {
            this.setValid();
            LinkedList<Packet> all = new LinkedList<Packet>();
            Packet packet = null;
            while ((packet = this.waitingControlPackets.poll()) != null) {
                all.offer(packet);
            }
            this.sentPackets += (long)this.waitingPackets.size();
            while ((packet = this.waitingPackets.poll()) != null) {
                all.offer(packet);
            }
            this.handler.writePacketsToSocket(this.outgoing, all);
            return true;
        }
        log.warning("Something wrong, the method was called when the outgoing connection is null.");
        this.outgoing = null;
        this.conn_state = OutgoingState.NULL;
        return false;
    }

    public synchronized void handleDialbackFailure() {
        if (this.outgoing != null) {
            this.outgoing.forceStop();
            this.outgoing = null;
        }
        this.conn_state = OutgoingState.NULL;
    }

    public Queue<Packet> getWaitingPackets() {
        return this.waitingPackets;
    }

    public void stopAll() {
        if (this.outgoing != null) {
            this.outgoing.forceStop();
            this.outgoing = null;
        }
        this.conn_state = OutgoingState.NULL;
    }

    public void putDBKey(String sessionId, String dbKey) {
        this.db_keys.put(sessionId, dbKey);
    }

    public String getDBKey(String sessionId) {
        return this.db_keys.get(sessionId);
    }

    public synchronized void addOutgoing(XMPPIOService serv) {
        XMPPIOService old = this.outgoing;
        if (this.outgoing != serv) {
            this.outgoing = serv;
            this.conn_state = OutgoingState.HANDSHAKING;
        }
        if (old != null) {
            log.info("Old outgoing connection replaced with new one!");
            old.forceStop();
        }
    }

    public boolean isOutgoingConnected() {
        return this.outgoing != null && this.outgoing.isConnected();
    }

    public boolean isOutgoing(XMPPIOService serv) {
        return serv == this.outgoing;
    }

    public void serviceStopped(XMPPIOService serv) {
        String session_id = (String)serv.getSessionData().get("sessionID");
        if (session_id != null) {
            this.db_keys.remove(session_id);
        } else {
            log.info("Session_ID is null for: " + serv.getUniqueId());
        }
        if (serv == this.outgoing) {
            this.outgoing = null;
            this.conn_state = OutgoingState.NULL;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Connection removed: " + session_id);
            }
        }
    }

    public static enum OutgoingState {
        NULL,
        CONNECTING,
        HANDSHAKING,
        OK;

    }
}

