/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.sreceiver.NewTaskCommand;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.ReceiverTaskIfc;
import tigase.server.sreceiver.StanzaReceiverIfc;
import tigase.server.sreceiver.TaskCommandIfc;
import tigase.server.sreceiver.TaskCreationPolicy;
import tigase.server.sreceiver.TaskInstanceCommand;
import tigase.server.sreceiver.TaskType;
import tigase.util.ClassUtil;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;

public class StanzaReceiver
extends AbstractMessageReceiver
implements Configurable,
XMPPService,
StanzaReceiverIfc {
    private static final Logger log = Logger.getLogger("tigase.server.sreceiver.StanzaReceiver");
    private static final String TASKS_LIST_PROP_KEY = "tasks-list";
    private static final String[] TASKS_LIST_PROP_VAL = new String[0];
    private static final String TASK_ACTIVE_PROP_KEY = "active";
    private static final boolean TASK_ACTIVE_PROP_VAL = true;
    private static final String TASK_TYPE_PROP_KEY = "task-type";
    private static final String TASK_TYPE_PROP_VAL = "News Distribution";
    private static final String SREC_REPO_CLASS_PROP_KEY = "srec-repo-class";
    private static final String SREC_REPO_URL_PROP_KEY = "srec-repo-url";
    private static String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String MY_DOMAIN_NAME_PROP_VAL = "srecv.localhost";
    private static final String TESTER_TASK_NAME = "tester_1";
    private static final String TESTER_TASK_TYPE = "Tester Task";
    private static final String TASK_TYPES_PROP_NODE = "task-types/";
    private static final String TASK_TYPES_PROP_KEY = "task-types/list";
    private static final String[] TASK_TYPES_PROP_VAL = new String[]{"News Distribution"};
    private static final String CREATION_POLICY_PROP_KEY = "task-types/default-policy";
    private static final TaskCreationPolicy CREATION_POLICY_PROP_VAL = TaskCreationPolicy.ADMIN;
    private static final String CREATION_MAX_NO_PROP_KEY = "task-types/default-max-number";
    private static final int CREATION_MAX_NO_PROP_VAL = 1;
    private static final String tasks_node = "/tasks";
    private static final String params_node = "/params";
    private static final String task_type_key = "task-type";
    private Map<String, TaskType> task_types = new ConcurrentSkipListMap<String, TaskType>();
    private Map<String, ReceiverTaskIfc> task_instances = new ConcurrentSkipListMap<String, ReceiverTaskIfc>();
    private Map<String, TaskCommandIfc> commands = new ConcurrentSkipListMap<String, TaskCommandIfc>();
    private ServiceEntity serviceEntity = null;
    private String[] admins = new String[]{"admin@localhost"};
    private String my_hostname = "srecv.localhost";
    private UserRepository repository = null;
    private int defaultMaxTasksNo = 1;

    public StanzaReceiver() {
        try {
            Set ctasks = ClassUtil.getClassesImplementing(ReceiverTaskIfc.class);
            for (Class ctask : ctasks) {
                ReceiverTaskIfc itask = (ReceiverTaskIfc)ctask.newInstance();
                this.task_types.put(itask.getType(), new TaskType(itask));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not load ReceiverTaskIfc implementations", e);
        }
        TaskCommandIfc new_task = new NewTaskCommand();
        this.commands.put(new_task.getNodeName(), new_task);
        new_task = new TaskInstanceCommand();
        this.commands.put(new_task.getNodeName(), new_task);
    }

    protected boolean isAllowedCreate(String jid, String task_type) {
        TaskType tt = this.task_types.get(task_type);
        switch (tt.getCreationPolicy()) {
            case ADMIN: {
                return this.isAdmin(jid);
            }
            case LOCAL: {
                return this.isLocalDomain(JIDUtils.getNodeHost((String)jid));
            }
        }
        return true;
    }

    private void addTaskToInstances(ReceiverTaskIfc task) {
        this.task_instances.put(task.getJID(), task);
        ServiceEntity item = new ServiceEntity(task.getJID(), JIDUtils.getNodeNick((String)task.getJID()), task.getDescription());
        item.addIdentities(new ServiceIdentity("component", "generic", task.getJID()));
        item.addFeatures(CMD_FEATURES);
        this.serviceEntity.addItems(item);
        LinkedList<Packet> results = new LinkedList<Packet>();
        task.init(results);
        this.addOutPackets(results);
        this.task_types.get(task.getType()).instanceAdded();
    }

    protected void addTaskInstance(String task_type, String task_name, Map<String, Object> task_params) {
        this.addTaskInstance(this.createTask(task_type, task_name + "@" + this.my_hostname, task_params));
    }

    protected void addTaskInstance(ReceiverTaskIfc task) {
        if (this.getTask(task.getJID()) == null) {
            this.addTaskToInstances(task);
            try {
                this.saveTaskToRepository(task);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem with saving task to repository: " + task.getJID(), e);
            }
        } else {
            log.log(Level.INFO, "Attempt to add another task with jid: " + task.getJID() + ", ignoring.");
        }
    }

    protected void removeTaskInstance(ReceiverTaskIfc task) {
        ServiceEntity item = new ServiceEntity(task.getJID(), JIDUtils.getNodeNick((String)task.getJID()), task.getDescription());
        this.serviceEntity.removeItems(item);
        this.task_instances.remove(task.getJID());
        LinkedList<Packet> results = new LinkedList<Packet>();
        task.destroy(results);
        this.addOutPackets(results);
        this.task_types.get(task.getType()).instanceRemoved();
        try {
            String repo_node = "/tasks/" + task.getJID();
            this.repository.removeSubnode(this.getComponentId(), repo_node);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem removing task from repository: " + task.getJID(), e);
        }
    }

    protected void removeTaskSubscribers(ReceiverTaskIfc task, String ... subscr) {
        LinkedList<Packet> results = new LinkedList<Packet>();
        task.removeSubscribers(results, subscr);
        this.addOutPackets(results);
    }

    protected Map<String, TaskType> getTaskTypes() {
        return this.task_types;
    }

    protected Map<String, ReceiverTaskIfc> getTaskInstances() {
        return this.task_instances;
    }

    private void loadTasksFromRepository() throws TigaseDBException {
        String[] tasks_jids = this.repository.getSubnodes(this.getComponentId(), tasks_node);
        if (tasks_jids != null) {
            for (String task_jid : tasks_jids) {
                StringBuilder repo_node = new StringBuilder("/tasks/" + task_jid);
                String task_type = this.repository.getData(this.getComponentId(), repo_node.toString(), "task-type");
                repo_node.append(params_node);
                String[] keys = this.repository.getKeys(this.getComponentId(), repo_node.toString());
                LinkedHashMap<String, Object> task_params = new LinkedHashMap<String, Object>();
                if (keys != null) {
                    for (String key : keys) {
                        Object[] vals = this.repository.getDataList(this.getComponentId(), repo_node.toString(), key);
                        if (vals.length == 1) {
                            task_params.put(key, vals[0]);
                            log.info("Loaded data: " + key + ", value: " + (String)vals[0]);
                            continue;
                        }
                        task_params.put(key, vals);
                        log.info("Loaded data list: " + key + ", value: " + Arrays.toString(vals));
                    }
                }
                try {
                    this.addTaskToInstances(this.createTask(task_type, task_jid, task_params));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Can't create task: " + task_jid, e);
                }
            }
        }
    }

    protected void saveTaskToRepository(ReceiverTaskIfc task) throws TigaseDBException {
        String repo_node = "/tasks/" + task.getJID();
        this.repository.setData(this.getComponentId(), repo_node, "task-type", task.getType());
        Map<String, PropertyItem> task_params = task.getParams();
        repo_node = repo_node + params_node;
        for (Map.Entry<String, PropertyItem> entry : task_params.entrySet()) {
            if (entry.getKey().equals("user-repository")) continue;
            if (entry.getValue().getValue().getClass().isArray()) {
                this.repository.setDataList(this.getComponentId(), repo_node, entry.getKey(), (String[])entry.getValue().getValue());
                log.info("Saving task data list: " + entry.getKey() + ", value: " + Arrays.toString((String[])entry.getValue().getValue()));
                continue;
            }
            this.repository.setData(this.getComponentId(), repo_node, entry.getKey(), entry.getValue().toString());
            log.info("Saving task data: " + entry.getKey() + ", value: " + entry.getValue().toString());
        }
    }

    private ReceiverTaskIfc createTask(String task_type, String task_jid, Map<String, Object> task_params) {
        ReceiverTaskIfc ntask = this.task_types.get(task_type).getTaskInstance();
        ntask.setStanzaReceiver(this);
        ntask.setJID(task_jid.toLowerCase());
        task_params.put("user-repository", this.repository);
        ntask.setParams(task_params);
        return ntask;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String[] task_types_arr;
        super.setProperties(props);
        this.my_hostname = (String)props.get(MY_DOMAIN_NAME_PROP_KEY);
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Stanza Receiver");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "generic", "Stanza Receiver"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        ServiceEntity com = new ServiceEntity(this.my_hostname, "commands", "Tasks management commands");
        com.addFeatures(DEF_FEATURES);
        com.addIdentities(new ServiceIdentity("automation", "command-list", "Tasks management commands"));
        this.serviceEntity.addItems(com);
        for (TaskCommandIfc comm : this.commands.values()) {
            ServiceEntity item = new ServiceEntity(this.my_hostname, comm.getNodeName(), comm.getDescription());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", comm.getDescription()));
            com.addItems(item);
        }
        this.admins = (String[])props.get("admins");
        Arrays.sort(this.admins);
        try {
            String cls_name = (String)props.get(SREC_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(SREC_REPO_URL_PROP_KEY);
            this.repository = RepositoryFactory.getUserRepository(this.getName(), cls_name, res_uri, null);
            try {
                this.repository.addUser(this.getComponentId());
            }
            catch (UserExistsException e) {
                // empty catch block
            }
            this.loadTasksFromRepository();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize repository: ", e);
        }
        String[] tasks_list = (String[])props.get(TASKS_LIST_PROP_KEY);
        if (tasks_list != null && tasks_list.length > 0) {
            for (String task_name : tasks_list) {
                String task_type = (String)props.get(task_name + "/" + "task-type");
                LinkedHashMap<String, Object> task_params = new LinkedHashMap<String, Object>();
                String prep = task_name + "/props/";
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(prep)) continue;
                    task_params.put(entry.getKey().substring(prep.length()), entry.getValue());
                }
                this.addTaskInstance(this.createTask(task_type, task_name + "@" + this.my_hostname, task_params));
            }
        }
        this.defaultMaxTasksNo = (Integer)props.get(CREATION_MAX_NO_PROP_KEY);
        for (String task_t : task_types_arr = (String[])props.get(TASK_TYPES_PROP_KEY)) {
            TaskType tt = this.task_types.get(task_t);
            if (tt == null) continue;
            String policy_str = (String)props.get(task_t + "/" + CREATION_POLICY_PROP_KEY);
            TaskCreationPolicy policy = TaskCreationPolicy.valueOf(policy_str);
            tt.setCreationPolicy(policy);
            int max_inst = (Integer)props.get(task_t + "/" + CREATION_MAX_NO_PROP_KEY);
            tt.setMaxInstancesNo(max_inst);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        LinkedList<String> conf_tasks = new LinkedList<String>();
        conf_tasks.addAll(Arrays.asList(TASKS_LIST_PROP_VAL));
        if (params.get("--gen-ssend-forum-task") != null) {
            String[] forum_ids;
            for (String id : forum_ids = ((String)params.get("--gen-ssend-forum-task")).split(",")) {
                String task_name = "forum-" + id;
                conf_tasks.add(task_name);
                defs.put(task_name + "/" + TASK_ACTIVE_PROP_KEY, true);
                defs.put(task_name + "/" + "task-type", TASK_TYPE_PROP_VAL);
                Map<String, PropertyItem> default_props = this.task_types.get(TASK_TYPE_PROP_VAL).getTaskType().getDefaultParams();
                for (Map.Entry<String, PropertyItem> entry : default_props.entrySet()) {
                    defs.put(task_name + "/props/" + entry.getKey(), entry.getValue().toString());
                    if (entry.getKey().equals("allowed-senders")) {
                        defs.put(task_name + "/props/" + entry.getKey(), PropertyConstants.SenderRestrictions.OWNER.toString());
                    }
                    if (entry.getKey().equals("message-type")) {
                        defs.put(task_name + "/props/" + entry.getKey(), PropertyConstants.MessageType.NORMAL.toString());
                    }
                    if (entry.getKey().equals("replace-sender")) {
                        defs.put(task_name + "/props/" + entry.getKey(), PropertyConstants.SenderAddress.REMOVE.toString());
                    }
                    if (!entry.getKey().equals("task-owner")) continue;
                    defs.put(task_name + "/props/" + entry.getKey(), "drupal-forum-" + id + "@" + this.my_hostname);
                }
            }
        }
        for (String task_name : TASKS_LIST_PROP_VAL) {
            defs.put(task_name + "/" + TASK_ACTIVE_PROP_KEY, true);
            defs.put(task_name + "/" + "task-type", TASK_TYPE_PROP_VAL);
            Map<String, PropertyItem> default_props = this.task_types.get(TASK_TYPE_PROP_VAL).getTaskType().getDefaultParams();
            for (Map.Entry<String, PropertyItem> entry : default_props.entrySet()) {
                defs.put(task_name + "/props/" + entry.getKey(), entry.getValue().toString());
            }
        }
        if (((Boolean)params.get("--test")).booleanValue()) {
            conf_tasks.add(TESTER_TASK_NAME);
            defs.put("tester_1/active", true);
            defs.put("tester_1/task-type", TESTER_TASK_TYPE);
            defs.put("tester_1/props/allowed-senders", PropertyConstants.SenderRestrictions.ALL.toString());
            defs.put("tester_1/props/message-type", PropertyConstants.MessageType.NORMAL.toString());
        }
        defs.put(TASKS_LIST_PROP_KEY, conf_tasks.toArray(new String[0]));
        String srec_repo_class = "tigase.db.jdbc.JDBCRepository";
        String srec_repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        String conf_srec_db = null;
        if (params.get("--gen-srec-db") != null) {
            conf_srec_db = (String)params.get("--gen-srec-db");
        } else if (params.get("--user-db") != null) {
            conf_srec_db = (String)params.get("--user-db");
        }
        if (conf_srec_db != null) {
            if (conf_srec_db.equals("mysql")) {
                srec_repo_class = "tigase.db.jdbc.JDBCRepository";
                srec_repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_srec_db.equals("pgsql")) {
                srec_repo_class = "tigase.db.jdbc.JDBCRepository";
                srec_repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
        }
        if (params.get("--gen-srec-db-uri") != null) {
            srec_repo_uri = (String)params.get("--gen-srec-db-uri");
        } else if (params.get("--user-db-uri") != null) {
            srec_repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(SREC_REPO_CLASS_PROP_KEY, srec_repo_class);
        defs.put(SREC_REPO_URL_PROP_KEY, srec_repo_uri);
        if (params.get("--gen-srec-admins") != null) {
            ADMINS_PROP_VAL = ((String)params.get("--gen-srec-admins")).split(",");
        } else if (params.get("--admins") != null) {
            ADMINS_PROP_VAL = ((String)params.get("--admins")).split(",");
        } else {
            ADMINS_PROP_VAL = new String[1];
            StanzaReceiver.ADMINS_PROP_VAL[0] = "admin@" + this.getDefHostName();
        }
        defs.put("admins", ADMINS_PROP_VAL);
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        defs.put(MY_DOMAIN_NAME_PROP_KEY, "srecv." + local_domains[0]);
        defs.put(TASK_TYPES_PROP_KEY, TASK_TYPES_PROP_VAL);
        defs.put(CREATION_POLICY_PROP_KEY, CREATION_POLICY_PROP_VAL.toString());
        defs.put(CREATION_MAX_NO_PROP_KEY, 1);
        defs.put("News Distribution/task-types/default-policy", TaskCreationPolicy.ALL.toString());
        defs.put("News Distribution/task-types/default-max-number", 100);
        return defs;
    }

    private boolean processIQPacket(Packet packet) {
        boolean processed = false;
        Element iq = packet.getElement();
        Element query = iq.getChild("query", "http://jabber.org/protocol/disco#info");
        Element query_rep = null;
        if (query != null && packet.getType() == StanzaType.get) {
            query_rep = this.serviceEntity.getDiscoInfo(JIDUtils.getNodeNick((String)packet.getElemTo()));
            processed = true;
        }
        if ((query = iq.getChild("query", "http://jabber.org/protocol/disco#items")) != null && packet.getType() == StanzaType.get) {
            query_rep = query.clone();
            List<Element> items = this.serviceEntity.getDiscoItems(JIDUtils.getNodeNick((String)packet.getElemTo()), packet.getElemTo());
            if (items != null && items.size() > 0) {
                query_rep.addChildren(items);
            }
            processed = true;
        }
        if (query_rep != null) {
            this.addOutPacket(packet.okResult(query_rep, 0));
        }
        return processed;
    }

    protected boolean isAdmin(String jid) {
        return Arrays.binarySearch(this.admins, JIDUtils.getNodeID((String)jid)) >= 0;
    }

    @Override
    public void processPacket(Packet packet) {
        String resource;
        if (packet.isCommand()) {
            TaskCommandIfc command2;
            String[] arr_command;
            Command.Action action = Command.getAction(packet);
            if (action == Command.Action.cancel) {
                Packet result = packet.commandResult(null);
                this.addOutPacket(result);
                return;
            }
            Packet result = packet.commandResult(Command.DataType.result);
            String str_command = packet.getStrCommand();
            if (str_command != null && (arr_command = str_command.split("/")).length > 1 && (command2 = this.commands.get(arr_command[1])) != null) {
                log.fine("Processing task command: " + arr_command[1]);
                command2.processCommand(packet, result, this);
            }
            this.addOutPacket(result);
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (packet.getElemName().equals("iq")) {
            this.processIQPacket(packet);
            return;
        }
        ReceiverTaskIfc task = this.getTask(packet.getElemTo());
        if (task == null) {
            task = this.getTask(JIDUtils.getNodeNick((String)packet.getElemTo()));
        }
        if (task == null && (resource = JIDUtils.getNodeResource((String)packet.getElemTo())) != null) {
            task = this.getTask(resource);
        }
        if (task != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found a task for packet: " + task.getJID());
            }
            LinkedList<Packet> results = new LinkedList<Packet>();
            task.processPacket(packet, results);
            this.addOutPackets(results);
        }
    }

    public ReceiverTaskIfc getTask(String jidOrName) {
        ReceiverTaskIfc task = this.task_instances.get(jidOrName.toLowerCase());
        if (task == null) {
            task = this.task_instances.get(jidOrName + "@" + this.my_hostname);
        }
        return task;
    }

    @Override
    public Element getDiscoInfo(String node, String jid) {
        if (jid != null && jid.startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, String jid) {
        if (jid.startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoItems(node, null);
        }
        if (node == null) {
            return Arrays.asList(this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid));
        }
        return null;
    }

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }
}

