/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.conf.Configurable;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.ReceiverEventHandler;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.util.DNSResolver;
import tigase.util.JIDUtils;
import tigase.util.PriorityQueue;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;

public abstract class AbstractMessageReceiver
implements StatisticsContainer,
MessageReceiver,
Configurable,
VHostListener {
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private String DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 400000L).intValue();
    private static final Logger log = Logger.getLogger("tigase.abstract.AbstractMessageReceiver");
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private String defHostname = this.DEF_HOSTNAME_PROP_VAL;
    private MessageReceiver parent = null;
    private Priority[] pr_cache = Priority.values();
    private int in_queues_size = 1;
    private ArrayList<PriorityQueue<Packet>> in_queues = new ArrayList();
    private PriorityQueue<Packet> out_queue = new PriorityQueue(this.pr_cache.length, this.maxQueueSize);
    private Timer receiverTasks = null;
    private ConcurrentHashMap<String, ReceiverTask> waitingTasks = new ConcurrentHashMap(16, 0.75f, 4);
    private LinkedList<QueueListener> processingThreads = null;
    private QueueListener out_thread = null;
    private String name = null;
    protected VHostManagerIfc vHostManager = null;
    private Set<Pattern> regexRoutings = new CopyOnWriteArraySet<Pattern>();
    private long curr_second = 0L;
    private long curr_minute = 0L;
    private long curr_hour = 0L;
    private long[] seconds = new long[60];
    private int sec_idx = 0;
    private long[] minutes = new long[60];
    private int min_idx = 0;
    private String compId = null;
    private long[] processPacketTimings = new long[100];
    private int pptIdx = 0;
    private long statReceivedMessagesOk = 0L;
    private long statSentMessagesOk = 0L;
    private long statReceivedMessagesEr = 0L;
    private long statSentMessagesEr = 0L;

    @Override
    public String getComponentId() {
        return this.compId;
    }

    @Override
    public void initializationCompleted() {
    }

    @Override
    public boolean addPacketNB(Packet packet) {
        boolean result;
        int queueIdx = Math.abs(packet.getTo().hashCode() % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toString());
        }
        if (result = this.in_queues.get(queueIdx).offer(packet, packet.getPriority().ordinal())) {
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        } else {
            ++this.statReceivedMessagesEr;
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addPacket(Packet packet) {
        int queueIdx = Math.abs(packet.getTo().hashCode() % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toString());
        }
        try {
            this.in_queues.get(queueIdx).put(packet, packet.getPriority().ordinal());
            ++this.statReceivedMessagesOk;
            ++this.curr_second;
        }
        catch (InterruptedException e) {
            ++this.statReceivedMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        boolean result = false;
        result = this.out_queue.offer(packet, packet.getPriority().ordinal());
        if (result) {
            ++this.statSentMessagesOk;
        } else {
            ++this.statSentMessagesEr;
        }
        return result;
    }

    protected boolean addOutPacketWithTimeout(Packet packet, ReceiverEventHandler handler, long delay, TimeUnit unit) {
        new ReceiverTask(handler, delay, unit, packet);
        return this.addOutPacket(packet);
    }

    protected boolean addOutPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toString());
        }
        try {
            this.out_queue.put(packet, packet.getPriority().ordinal());
            ++this.statSentMessagesOk;
        }
        catch (InterruptedException e) {
            ++this.statSentMessagesEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    public abstract void processPacket(Packet var1);

    @Override
    public List<StatRecord> getStatistics() {
        LinkedList<StatRecord> stats = new LinkedList<StatRecord>();
        long tmp = this.seconds[this.sec_idx == 0 ? 59 : this.sec_idx - 1];
        if (tmp > 0L) {
            stats.add(new StatRecord(this.getName(), "Last second packets", "int", tmp, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), "Last second packets", "int", tmp, Level.FINEST));
        }
        tmp = this.minutes[this.min_idx == 0 ? 59 : this.min_idx - 1];
        if (tmp > 0L) {
            stats.add(new StatRecord(this.getName(), "Last minute packets", "int", tmp, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), "Last minute packets", "int", tmp, Level.FINEST));
        }
        if (this.curr_hour > 0L) {
            stats.add(new StatRecord(this.getName(), "Last hour packets", "int", this.curr_hour, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), "Last hour packets", "int", this.curr_hour, Level.FINEST));
        }
        if (this.statReceivedMessagesOk > 0L) {
            stats.add(new StatRecord(this.getName(), StatisticType.MSG_RECEIVED_OK, this.statReceivedMessagesOk, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), StatisticType.MSG_RECEIVED_OK, this.statReceivedMessagesOk, Level.FINEST));
        }
        if (this.statSentMessagesOk > 0L) {
            stats.add(new StatRecord(this.getName(), StatisticType.MSG_SENT_OK, this.statSentMessagesOk, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), StatisticType.MSG_SENT_OK, this.statSentMessagesOk, Level.FINEST));
        }
        int[] in_priority_sizes = this.in_queues.get(0).size();
        for (int i = 1; i < this.in_queues.size(); ++i) {
            int[] tmp_pr_sizes = this.in_queues.get(i).size();
            for (int j = 0; j < tmp_pr_sizes.length; ++j) {
                int n = j;
                in_priority_sizes[n] = in_priority_sizes[n] + tmp_pr_sizes[j];
            }
        }
        int in_queue_size = 0;
        int[] out_priority_sizes = this.out_queue.size();
        int out_queue_size = 0;
        for (Priority queue : Priority.values()) {
            stats.add(new StatRecord(this.getName(), "In queue: " + queue.name(), "int", in_priority_sizes[queue.ordinal()], Level.FINEST));
            stats.add(new StatRecord(this.getName(), "Out queue: " + queue.name(), "int", out_priority_sizes[queue.ordinal()], Level.FINEST));
            in_queue_size += in_priority_sizes[queue.ordinal()];
            out_queue_size += out_priority_sizes[queue.ordinal()];
        }
        if (in_queue_size > 10) {
            stats.add(new StatRecord(this.getName(), "Total In queues wait", "int", in_queue_size, Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), "Total In queues wait", "int", in_queue_size, Level.FINEST));
        }
        if (out_queue_size > 10) {
            stats.add(new StatRecord(this.getName(), "Total Out queues wait", "int", out_queue_size, Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), "Total Out queues wait", "int", out_queue_size, Level.FINEST));
        }
        stats.add(new StatRecord(this.getName(), StatisticType.MAX_QUEUE_SIZE, this.maxQueueSize, Level.FINEST));
        if (this.statReceivedMessagesEr > 0L) {
            stats.add(new StatRecord(this.getName(), StatisticType.IN_QUEUE_OVERFLOW, this.statReceivedMessagesEr, Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), StatisticType.IN_QUEUE_OVERFLOW, this.statReceivedMessagesEr, Level.FINEST));
        }
        if (this.statSentMessagesEr > 0L) {
            stats.add(new StatRecord(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW, this.statSentMessagesEr, Level.INFO));
        } else {
            stats.add(new StatRecord(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW, this.statSentMessagesEr, Level.FINEST));
        }
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        long prcessingTime = res / (long)this.processPacketTimings.length;
        if (prcessingTime > 10L) {
            stats.add(new StatRecord(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", "long", prcessingTime, Level.FINE));
        } else {
            stats.add(new StatRecord(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", "long", prcessingTime, Level.FINEST));
        }
        return stats;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        int queueSize = (Integer)props.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.setMaxQueueSize(queueSize);
        this.defHostname = (String)props.get("def-hostname");
        this.compId = (String)props.get("component-id");
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (this.maxQueueSize != maxQueueSize || this.in_queues.size() == 0) {
            this.maxQueueSize = maxQueueSize / this.processingThreads();
            if (this.in_queues.size() == 0) {
                for (int i = 0; i < this.in_queues_size; ++i) {
                    this.in_queues.add(new PriorityQueue(this.pr_cache.length, maxQueueSize));
                }
            } else {
                for (int i = 0; i < this.in_queues.size(); ++i) {
                    this.in_queues.get(i).setMaxSize(maxQueueSize);
                }
            }
            this.out_queue.setMaxSize(maxQueueSize);
        }
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        String queueSize = (String)params.get("--max-queue-size");
        int queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
        if (queueSize != null) {
            try {
                queueSizeInt = Integer.parseInt(queueSize);
            }
            catch (NumberFormatException e) {
                queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
            }
        }
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getMaxQueueSize(queueSizeInt));
        this.DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        defs.put("component-id", this.compId);
        return defs;
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.compId = JIDUtils.getNodeID((String)name, (String)this.defHostname);
        this.in_queues_size = this.processingThreads();
        this.setMaxQueueSize(this.maxQueueSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void stopThreads() {
        try {
            if (this.processingThreads != null) {
                for (QueueListener in_thread : this.processingThreads) {
                    in_thread.threadStopped = true;
                    in_thread.interrupt();
                    while (in_thread.isAlive()) {
                        Thread.sleep(100L);
                    }
                }
            }
            if (this.out_thread != null) {
                this.out_thread.threadStopped = true;
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.processingThreads = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
    }

    public synchronized void everySecond() {
        this.curr_minute -= this.seconds[this.sec_idx];
        this.seconds[this.sec_idx] = this.curr_second;
        this.curr_second = 0L;
        this.curr_minute += this.seconds[this.sec_idx];
        this.sec_idx = this.sec_idx >= 59 ? 0 : ++this.sec_idx;
    }

    public synchronized void everyMinute() {
        this.curr_hour -= this.minutes[this.min_idx];
        this.minutes[this.min_idx] = this.curr_minute;
        this.curr_hour += this.minutes[this.min_idx];
        this.min_idx = this.min_idx >= 59 ? 0 : ++this.min_idx;
    }

    private void startThreads() {
        if (this.processingThreads == null) {
            this.processingThreads = new LinkedList();
            for (int i = 0; i < this.in_queues_size; ++i) {
                QueueListener in_thread = new QueueListener(this.in_queues.get(i), QueueType.IN_QUEUE);
                in_thread.setName("in_" + i + "-" + this.name);
                in_thread.start();
                this.processingThreads.add(in_thread);
            }
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.out_thread = new QueueListener(this.out_queue, QueueType.OUT_QUEUE);
            this.out_thread.setName("out_" + this.name);
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
    }

    @Override
    public void start() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.getName() + ": starting queue management threads ...");
        }
        this.startThreads();
    }

    public void stop() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.getName() + ": stopping queue management threads ...");
        }
        this.stopThreads();
    }

    @Override
    public String getDefHostName() {
        return this.defHostname;
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    public VHostItem getVHostItem(String domain) {
        return this.vHostManager != null ? this.vHostManager.getVHostItem(domain) : null;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    public void addRegexRouting(String address) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - attempt to add regex routing: " + address);
        }
        this.regexRoutings.add(Pattern.compile(address, 2));
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - success adding regex routing: " + address);
        }
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (!pat.matcher(address).matches()) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " matched against pattern: " + pat.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    public int processingThreads() {
        return 1;
    }

    private class ReceiverTask
    extends TimerTask {
        private ReceiverEventHandler handler = null;
        private Packet packet = null;
        private String id = null;

        private ReceiverTask(ReceiverEventHandler handler, long delay, TimeUnit unit, Packet packet) {
            this.handler = handler;
            this.packet = packet;
            this.id = packet.getFrom() + packet.getId();
            AbstractMessageReceiver.this.waitingTasks.put(this.id, this);
            AbstractMessageReceiver.this.receiverTasks.schedule((TimerTask)this, unit.toMillis(delay));
        }

        @Override
        public void run() {
            this.handleTimeout();
        }

        public void handleTimeout() {
            AbstractMessageReceiver.this.waitingTasks.remove(this.packet.getFrom() + this.packet.getId());
            this.handler.timeOutExpired(this.packet);
        }

        public void handleResponse(Packet response) {
            this.cancel();
            this.handler.responseReceived(this.packet, response);
        }
    }

    private class QueueListener
    extends Thread {
        private PriorityQueue<Packet> queue;
        private QueueType type = null;
        private boolean threadStopped = false;

        private QueueListener(PriorityQueue<Packet> q, QueueType type) {
            this.queue = q;
            this.type = type;
        }

        @Override
        public void run() {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " starting queue processing.");
            }
            Packet packet = null;
            block7: while (!this.threadStopped) {
                try {
                    packet = this.queue.take();
                    switch (this.type) {
                        case IN_QUEUE: {
                            String id = packet.getTo() + packet.getId();
                            ReceiverTask task = (ReceiverTask)AbstractMessageReceiver.this.waitingTasks.remove(id);
                            if (task != null) {
                                task.handleResponse(packet);
                                continue block7;
                            }
                            long startPPT = System.currentTimeMillis();
                            AbstractMessageReceiver.this.processPacket(packet);
                            ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[((AbstractMessageReceiver)AbstractMessageReceiver.this).pptIdx] = System.currentTimeMillis() - startPPT;
                            AbstractMessageReceiver.this.pptIdx = (AbstractMessageReceiver.this.pptIdx + 1) % AbstractMessageReceiver.this.processPacketTimings.length;
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            if (AbstractMessageReceiver.this.parent != null) {
                                AbstractMessageReceiver.this.parent.addPacket(packet);
                                continue block7;
                            }
                            AbstractMessageReceiver.this.addPacketNB(packet);
                            continue block7;
                        }
                    }
                    log.severe("Unknown queue element type: " + (Object)((Object)this.type));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "[" + this.getName() + "] Exception during packet processing: " + packet.toString(), e);
                }
            }
        }
    }

    private static enum QueueType {
        IN_QUEUE,
        OUT_QUEUE;

    }
}

