/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1681 $
 * Last modified by $Author: kobit $
 * $Date: 2009-05-25 13:13:04 +0100 (Mon, 25 May 2009) $
 */
package tigase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

/**
 * Describe interface IOInterface here.
 *
 *
 * Created: Sat May 14 08:07:38 2005
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1681 $
 */
public interface IOInterface {

  SocketChannel getSocketChannel();

  void stop() throws IOException;

  boolean isConnected();

  int write(final ByteBuffer buff) throws IOException;

  ByteBuffer read(final ByteBuffer buff) throws IOException;

  int bytesRead();

	int getInputPacketSize() throws IOException;

	boolean waitingToSend();

	int waitingToSendSize();

} // IOInterface
