/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.util.JIDUtils;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;

public class Roster
extends RosterAbstract {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Roster");

    public String[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getDataGroups("roster");
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        return session.getData(this.groupNode(buddy), "name", null);
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, String buddy, String name) throws NotAuthorizedException, TigaseDBException {
        session.setData(this.groupNode(buddy), "name", name);
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, String buddy) throws NotAuthorizedException, TigaseDBException {
        session.setData(this.groupNode(buddy), "subscription", subscription.toString());
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        String subscr = session.getData(this.groupNode(buddy), "subscription", null);
        if (subscr != null) {
            return RosterAbstract.SubscriptionType.valueOf(subscr);
        }
        return null;
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, String jid) throws NotAuthorizedException, TigaseDBException {
        session.removeDataGroup(this.groupNode(jid));
        return true;
    }

    @Override
    public void addBuddy(XMPPResourceConnection session, String jid, String name, String[] groups) throws NotAuthorizedException, TigaseDBException {
        String nick = JIDUtils.getNodeNick((String)jid);
        if (nick == null) {
            nick = jid;
        }
        session.setData(this.groupNode(jid), "name", nick);
        session.setData(this.groupNode(jid), "subscription", RosterAbstract.SubscriptionType.none.toString());
        session.setDataList(this.groupNode(jid), "groups", groups);
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        return session.getDataList(this.groupNode(buddy), "groups");
    }

    @Override
    public boolean containsBuddy(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addBuddyGroup(XMPPResourceConnection session, String buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getBuddies(XMPPResourceConnection session, boolean onlineOnly) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBuddyOnline(XMPPResourceConnection session, String buddy, boolean online) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isBuddyOnline(XMPPResourceConnection session, String buddy) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

