/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;

public class DomainFilter
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPPreprocessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.DomainFilter");
    public static final String ALLOWED_DOMAINS_LIST_KEY = "allowed-domains-list";
    public static final String ALLOWED_DOMAINS_KEY = "allowed-domains";
    private static final String ID = "domain-filter";
    private static final String[] ELEMENTS = new String[]{"*"};
    private static final String[] XMLNSS = new String[]{"*"};

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public String id() {
        return ID;
    }

    private DOMAINS getDomains(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        DOMAINS domains = (DOMAINS)((Object)session.getCommonSessionData(ALLOWED_DOMAINS_KEY));
        if (log.isLoggable(Level.FINEST)) {
            log.finest("domains read from user session: " + (Object)((Object)domains));
        }
        if (domains == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_KEY, null);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Domains read from database: " + dbDomains);
            }
            if ((domains = DOMAINS.valueof(dbDomains)) == null) {
                domains = session.isAnonymous() ? DOMAINS.LOCAL : DOMAINS.ALL;
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_KEY, (Object)domains);
        }
        return domains;
    }

    private String[] getDomainsList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String[] allowedDomains = (String[])session.getCommonSessionData(ALLOWED_DOMAINS_LIST_KEY);
        if (allowedDomains == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_KEY, null);
            allowedDomains = dbDomains.split(",");
            for (int i = 0; i < allowedDomains.length; ++i) {
                allowedDomains[i] = allowedDomains[i].intern();
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_LIST_KEY, allowedDomains);
        }
        return allowedDomains;
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || results == null || results.size() == 0) {
            return;
        }
        try {
            DOMAINS domains = this.getDomains(session);
            if (domains == DOMAINS.ALL) {
                return;
            }
            LinkedList<Packet> errors = new LinkedList<Packet>();
            Iterator<Packet> it = results.iterator();
            while (it.hasNext()) {
                Packet res = (Packet)it.next();
                if (domains == DOMAINS.BLOCK) {
                    if (res.getType() == StanzaType.error || (res.getElemFrom() == null || JIDUtils.getNodeID((String)res.getElemFrom()).equals(session.getUserId())) && (res.getElemTo() == null || JIDUtils.getNodeID((String)res.getElemTo()).equals(session.getUserId()))) continue;
                    this.removePacket(it, res, errors, "Communication blocked.");
                    continue;
                }
                String outDomain = res.getElemTo();
                if (outDomain != null) {
                    outDomain = JIDUtils.getNodeHost((String)outDomain).intern();
                }
                switch (domains) {
                    case LOCAL: {
                        if (outDomain == null || session.isLocalDomain(outDomain, true)) break;
                        this.removePacket(it, res, errors, "You can only communicate within the server local domains.");
                        break;
                    }
                    case OWN: {
                        if (outDomain == null || outDomain.equals(session.getDomain())) break;
                        this.removePacket(it, res, errors, "You can only communicate within your own domain.");
                        break;
                    }
                    case LIST: {
                        String[] allowedDomains = this.getDomainsList(session);
                        boolean found = false;
                        for (String domain : allowedDomains) {
                            if (domain != outDomain) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                        this.removePacket(it, res, errors, "You can only communicate within selected list of domains.");
                    }
                }
            }
            results.addAll(errors);
        }
        catch (NotAuthorizedException ex) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can't access user repository.", ex);
        }
    }

    private void removePacket(Iterator<Packet> it, Packet res, Queue<Packet> errors, String msg) {
        if (it != null) {
            it.remove();
        }
        try {
            errors.add(Authorization.FORBIDDEN.getResponseMessage(res, msg, true));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINE, "Already error packet, dropping it..: " + res.toString());
        }
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing: " + packet.toString());
        }
        boolean stop = false;
        if (session == null) {
            return stop;
        }
        try {
            DOMAINS domains = this.getDomains(session);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("DOMAINS setting is: " + domains.name());
            }
            if (domains == DOMAINS.ALL) {
                return stop;
            }
            String outDomain = packet.getElemFrom();
            if (session.getConnectionId().equals(packet.getFrom())) {
                outDomain = packet.getElemTo();
            }
            if (outDomain != null) {
                outDomain = JIDUtils.getNodeHost((String)outDomain).intern();
            }
            switch (domains) {
                case BLOCK: {
                    if (packet.getType() == StanzaType.error || (packet.getElemFrom() == null || JIDUtils.getNodeID((String)packet.getElemFrom()).equals(session.getUserId())) && (packet.getElemTo() == null || JIDUtils.getNodeID((String)packet.getElemTo()).equals(session.getUserId()))) {
                        return stop;
                    }
                    this.removePacket(null, packet, results, "Communication blocked.");
                    stop = true;
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("BLOCK, blocking packet: " + packet.toString());
                    break;
                }
                case LOCAL: {
                    if (outDomain != null && !session.isLocalDomain(outDomain, true)) {
                        this.removePacket(null, packet, results, "You can only communicate within the server local domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.finest("LOCAL Domains only, blocking packet: " + packet.toString());
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("LOCAL Domains only, packet not blocked: " + packet.toString());
                    break;
                }
                case OWN: {
                    if (outDomain != null && !outDomain.equals(session.getDomain())) {
                        this.removePacket(null, packet, results, "You can only communicate within your own domain.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.finest("OWN Domain only, blocking packet: " + packet.toString());
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("OWN Domain only, packet not blocked: " + packet.toString());
                    break;
                }
                case LIST: {
                    String[] allowedDomains = this.getDomainsList(session);
                    boolean found = false;
                    for (String domain : allowedDomains) {
                        if (domain != outDomain) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.removePacket(null, packet, results, "You can only communicate within selected list of domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.finest("LISTED Domains only, blocking packet: " + packet.toString());
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.finest("LISTED Domain only, packet not blocked: " + packet.toString());
                }
            }
        }
        catch (NotAuthorizedException ex) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can't access user repository.", ex);
        }
        return stop;
    }

    public static enum DOMAINS {
        ALL,
        LOCAL,
        OWN,
        BLOCK,
        LIST;


        public static DOMAINS valueof(String domains) {
            if (domains == null) {
                return null;
            }
            try {
                return DOMAINS.valueOf(domains);
            }
            catch (Exception e) {
                return LIST;
            }
        }
    }
}

