/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.logging.Logger;
import tigase.xml.Element;

public class VHostItem {
    private static final Logger log = Logger.getLogger("tigase.vhosts.VHostItem");
    public static final String VHOST_ELEM = "vhost";
    public static final String COMPONENTS_ELEM = "comps";
    public static final String OTHER_PARAMS_ELEM = "other";
    public static final String HOSTNAME_ATT = "hostname";
    public static final String ENABLED_ATT = "enabled";
    public static final String ANONYMOUS_ENABLED_ATT = "anon";
    public static final String REGISTER_ENABLED_ATT = "register";
    public static final String MAX_USERS_NUMBER_ATT = "max-users";
    private String vhost = null;
    private String[] comps = null;
    private boolean enabled = true;
    private boolean anonymousEnabled = true;
    private boolean registerEnabled = true;
    private long maxUsersNumber = 0L;
    private String otherDomainParams = null;
    private VHostItem unmodifiableItem = null;

    private VHostItem() {
    }

    public VHostItem(String vhost) {
        this.vhost = vhost;
    }

    public VHostItem(Element elem) {
        this.vhost = elem.getAttribute(HOSTNAME_ATT);
        this.enabled = Boolean.parseBoolean(elem.getAttribute(ENABLED_ATT));
        this.anonymousEnabled = Boolean.parseBoolean(elem.getAttribute(ANONYMOUS_ENABLED_ATT));
        this.registerEnabled = Boolean.parseBoolean(elem.getAttribute(REGISTER_ENABLED_ATT));
        try {
            this.maxUsersNumber = Long.parseLong(elem.getAttribute(MAX_USERS_NUMBER_ATT));
        }
        catch (Exception e) {
            log.warning("Can not parse max users number: " + elem.getAttribute(MAX_USERS_NUMBER_ATT));
        }
        String comps_str = elem.getCData("/vhost/comps");
        if (comps_str != null && !comps_str.isEmpty()) {
            this.comps = comps_str.split(",");
        }
        this.otherDomainParams = elem.getCData("/vhost/other");
    }

    public VHostItem getUnmodifiableVHostItem() {
        if (this.unmodifiableItem == null) {
            this.unmodifiableItem = new UnmodifiableVHostItem();
        }
        return this.unmodifiableItem;
    }

    public Element toXML() {
        String comps_str = "";
        if (this.comps != null && this.comps.length > 0) {
            for (String comp : this.comps) {
                if (!comps_str.isEmpty()) {
                    comps_str = comps_str + ",";
                }
                comps_str = comps_str + comp;
            }
        }
        String other_params = this.otherDomainParams != null ? this.otherDomainParams : "";
        Element elem = new Element(VHOST_ELEM, new Element[]{new Element(COMPONENTS_ELEM, comps_str), new Element(OTHER_PARAMS_ELEM, other_params)}, new String[]{HOSTNAME_ATT, ENABLED_ATT, ANONYMOUS_ENABLED_ATT, REGISTER_ENABLED_ATT, MAX_USERS_NUMBER_ATT}, new String[]{this.vhost, "" + this.enabled, "" + this.anonymousEnabled, "" + this.registerEnabled, "" + this.maxUsersNumber});
        return elem;
    }

    public String[] getComps() {
        return this.comps;
    }

    public void setComps(String[] comps) {
        this.comps = comps;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean enabled) {
        this.registerEnabled = enabled;
    }

    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public void setAnonymousEnabled(boolean enabled) {
        this.anonymousEnabled = enabled;
    }

    public long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public void setMaxUsersNumber(long maxUsersNumber) {
        this.maxUsersNumber = maxUsersNumber;
    }

    public String getOtherDomainParams() {
        return this.otherDomainParams;
    }

    public void setOtherDomainParams(String otherParams) {
        this.otherDomainParams = otherParams;
    }

    public String getVhost() {
        return this.vhost;
    }

    private class UnmodifiableVHostItem
    extends VHostItem {
        private UnmodifiableVHostItem() {
        }

        @Override
        public VHostItem getUnmodifiableVHostItem() {
            return this;
        }

        @Override
        public Element toXML() {
            return VHostItem.this.toXML();
        }

        @Override
        public String[] getComps() {
            return VHostItem.this.getComps();
        }

        @Override
        public void setComps(String[] comps) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isEnabled() {
            return VHostItem.this.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isRegisterEnabled() {
            return VHostItem.this.isRegisterEnabled();
        }

        @Override
        public void setRegisterEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isAnonymousEnabled() {
            return VHostItem.this.isAnonymousEnabled();
        }

        @Override
        public void setAnonymousEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public long getMaxUsersNumber() {
            return VHostItem.this.getMaxUsersNumber();
        }

        @Override
        public void setMaxUsersNumber(long maxUsersNumber) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getOtherDomainParams() {
            return VHostItem.this.getOtherDomainParams();
        }

        @Override
        public void setOtherDomainParams(String otherParams) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getVhost() {
            return VHostItem.this.getVhost();
        }
    }
}

