/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;
import tigase.util.OSUtils;

public class DiskMonitor
extends AbstractMonitor {
    private static final Logger log = Logger.getLogger("tigase.server.sreceiver.sysmon.DiskMonitor");
    private File[] roots = null;

    @Override
    public void init(String jid, double treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.roots = File.listRoots();
        this.findAllRoots();
    }

    private void findAllRoots() {
        switch (OSUtils.getOSType()) {
            case windows: {
                File[] winRoots = File.listRoots();
                this.roots = winRoots;
                break;
            }
            case linux: {
                File[] linRoots = this.getLinuxRoots();
                this.roots = linRoots;
                break;
            }
            case sunos: 
            case solaris: {
                File[] solRoots = this.getSolarisRoots();
                this.roots = solRoots;
                break;
            }
            case mac: {
                File[] macRoots = this.getMacRoots();
                this.roots = macRoots;
                break;
            }
            default: {
                File[] otherRoots = File.listRoots();
                if (otherRoots.length != 1) break;
                File[] mtabRoots = this.getLinuxRoots();
                if (mtabRoots != null && mtabRoots.length > 1) {
                    otherRoots = mtabRoots;
                }
                this.roots = otherRoots;
            }
        }
    }

    @Override
    public void check1Min(Queue<Packet> results) {
        for (File file : this.roots) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            if (format instanceof DecimalFormat) {
                DecimalFormat decf = (DecimalFormat)format;
                decf.applyPattern(decf.toPattern() + " KB");
            }
            NumberFormat formp = NumberFormat.getPercentInstance();
            formp.setMaximumFractionDigits(2);
            double percent = new Long(file.getUsableSpace()).doubleValue() / new Long(file.getTotalSpace()).doubleValue();
            if ((double)file.getUsableSpace() < (double)file.getTotalSpace() * (1.0 - this.treshold)) {
                this.prepareWarning("Available space on volume: " + file.toString() + " is low: " + format.format(file.getUsableSpace() / 1024L) + " of " + format.format(file.getTotalSpace() / 1024L) + " - " + formp.format(percent), results, file.toString());
                continue;
            }
            this.prepareCalmDown("Available space on volume: " + file.toString() + " is OK now: " + format.format(file.getUsableSpace() / 1024L) + " of " + format.format(file.getTotalSpace() / 1024L) + " - " + formp.format(percent), results, file.toString());
        }
    }

    @Override
    public void check1Hour(Queue<Packet> results) {
        this.findAllRoots();
    }

    @Override
    public String getState() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        String format_s = "%1$20s%2$12s%3$12s%4$12s%5$12s\n";
        formatter.format(format_s, "Filesystem", "Size", "Used", "Avail", "Free%");
        String format_n = "%1$20s%2$,12dM%3$,12dM%4$,12dM%5$12.2f%%\n";
        long MEGA = 0x100000L;
        for (File file : this.roots) {
            double percent = new Long(file.getUsableSpace()).doubleValue() / new Long(file.getTotalSpace()).doubleValue();
            formatter.format(format_n, file.toString(), file.getTotalSpace() / MEGA, (file.getTotalSpace() - file.getUsableSpace()) / MEGA, file.getUsableSpace() / MEGA, percent * 100.0);
        }
        return formatter.toString();
    }

    private File[] getLinuxRoots() {
        try {
            String mtab = "/etc/mtab";
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Reading mtab: " + mtab);
            }
            BufferedReader buffr = new BufferedReader(new FileReader(mtab));
            String line = null;
            ArrayList<File> results = new ArrayList<File>();
            while ((line = buffr.readLine()) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Analyzing line: " + line);
                }
                if (line.contains("proc") || line.contains("devfs") || line.contains("tmpfs") || line.contains("sysfs") || line.contains("devpts") || line.contains("securityfs")) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("Found virtual fs line, omitting...");
                    continue;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Splitting line...");
                }
                String[] parts = line.split("\\s");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found file system: " + parts[1]);
                }
                results.add(new File(parts[1]));
            }
            return results.toArray(new File[results.size()]);
        }
        catch (Exception e) {
            log.warning("Can not read filesystems from /etc/mtab file" + e);
            return File.listRoots();
        }
    }

    private File[] getMacRoots() {
        File volumes = new File("/Volumes");
        return volumes.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
    }

    private File[] getSolarisRoots() {
        return File.listRoots();
    }

    @Override
    public void destroy() {
    }
}

