/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.AbstractMonitor;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;

public class CPUMonitor
extends AbstractMonitor {
    private static final Logger log = Logger.getLogger(CPUMonitor.class.getName());
    private int historySize = 100;
    private long lastCpuUsage = 0L;
    private long lastCpuChecked = 0L;
    private double[] cpuUsage = new double[this.historySize];
    private int cpuUsageIdx = 0;
    private double[] loadAverage = new double[this.historySize];
    private int loadAverageIdx = 0;
    private ThreadMXBean thBean = null;
    private OperatingSystemMXBean osBean = null;
    private NumberFormat format = NumberFormat.getPercentInstance();

    private String checkForDeadLock() {
        long[] tids = this.thBean.findDeadlockedThreads();
        if (tids != null && tids.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Locked threads " + tids.length + ":\n");
            LinkedHashSet<Long> tidSet = new LinkedHashSet<Long>();
            for (long tid : tids) {
                tidSet.add(tid);
            }
            ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
            while (rootGroup.getParent() != null) {
                rootGroup = rootGroup.getParent();
            }
            int allThreadsCount = this.thBean.getThreadCount();
            Thread[] allThreads = new Thread[allThreadsCount];
            rootGroup.enumerate(allThreads, true);
            for (Thread thread : allThreads) {
                StackTraceElement[] ste;
                if (!tidSet.contains(thread.getId())) continue;
                ThreadInfo threadInfo = this.thBean.getThreadInfo(thread.getId());
                sb.append("Locked thread [" + thread.getId() + "] " + threadInfo.getThreadName() + " on " + threadInfo.getLockInfo().toString() + ", locked synchronizers: " + Arrays.toString(threadInfo.getLockedSynchronizers()) + ", locked monitors: " + Arrays.toString(threadInfo.getLockedMonitors()) + " by [" + threadInfo.getLockOwnerId() + "] " + threadInfo.getLockOwnerName()).append('\n');
                for (StackTraceElement stackTraceElement : ste = thread.getStackTrace()) {
                    sb.append("  " + stackTraceElement.toString()).append('\n');
                }
            }
            return sb.toString();
        }
        return null;
    }

    private String getStackTrace(Map<Thread, StackTraceElement[]> map, long id) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            if (entry.getKey().getId() != id) continue;
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement stelem : entry.getValue()) {
                sb.append(stelem.toString() + "\n");
            }
            return sb.toString();
        }
        return null;
    }

    private String getThreadInfo(long thid, boolean stack) {
        ThreadInfo ti = this.thBean.getThreadInfo(thid);
        if (ti != null) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            long maxCpu = this.thBean.getThreadCpuTime(thid);
            double totalUsage = new Long(maxCpu).doubleValue() / 1000000.0 / new Long(System.currentTimeMillis()).doubleValue();
            StringBuilder sb = new StringBuilder("Thread: " + ti.getThreadName() + ", ID: " + ti.getThreadId());
            sb.append(", CPU usage: " + this.format.format(totalUsage) + "\n");
            if (stack) {
                sb.append(ti.toString());
                sb.append(this.getStackTrace(map, thid));
            }
            return sb.toString();
        }
        return "ThreadInfo is null...";
    }

    @Override
    public String runCommand(String[] com) {
        command comm = command.valueOf(com[0].substring(2));
        switch (comm) {
            case mth: 
            case maxthread: {
                if (com.length > 1) {
                    try {
                        long thid = Long.parseLong(com[1]);
                        return this.getThreadInfo(thid, true);
                    }
                    catch (Exception e) {
                        return "Incorrect Thread ID";
                    }
                }
                long maxCpu = 0L;
                long id = 0L;
                for (long thid : this.thBean.getAllThreadIds()) {
                    if (this.thBean.getThreadCpuTime(thid) < maxCpu) continue;
                    maxCpu = this.thBean.getThreadCpuTime(thid);
                    id = thid;
                }
                return this.getThreadInfo(id, true);
            }
            case allthreads: {
                boolean extend = false;
                if (com.length > 1 && com[1].equals("ex")) {
                    extend = true;
                }
                StringBuilder sb = new StringBuilder("All threads information:\n");
                for (long thid : this.thBean.getAllThreadIds()) {
                    sb.append(this.getThreadInfo(thid, extend));
                }
                return sb.toString();
            }
        }
        return null;
    }

    @Override
    public String commandsHelp() {
        StringBuilder sb = new StringBuilder();
        for (command comm : command.values()) {
            sb.append("//" + comm.name() + comm.getHelp() + "\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isMonitorCommand(String com) {
        if (com != null) {
            for (command comm : command.values()) {
                if (!com.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void init(String jid, double treshold, SystemMonitorTask smTask) {
        super.init(jid, treshold, smTask);
        this.thBean = ManagementFactory.getThreadMXBean();
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.format.setMaximumFractionDigits(2);
        if (this.thBean.isCurrentThreadCpuTimeSupported()) {
            this.thBean.setThreadCpuTimeEnabled(true);
        } else {
            log.warning("Current thread CPU Time is NOT supported.");
        }
        if (this.thBean.isThreadContentionMonitoringSupported()) {
            this.thBean.setThreadContentionMonitoringEnabled(true);
        } else {
            log.warning("Thread contention monitoring is NOT supported.");
        }
    }

    @Override
    public void check10Secs(Queue<Packet> results) {
        long cpuTime = 0L;
        for (long thid : this.thBean.getAllThreadIds()) {
            cpuTime += this.thBean.getThreadCpuTime(thid);
        }
        long tmpCPU = this.lastCpuUsage;
        this.lastCpuUsage = cpuTime;
        double totalUsage = new Long(cpuTime -= tmpCPU).doubleValue() / 1000000.0 / new Long(System.currentTimeMillis() - this.lastCpuChecked).doubleValue();
        this.lastCpuChecked = System.currentTimeMillis();
        this.cpuUsageIdx = this.setValueInArr(this.cpuUsage, this.cpuUsageIdx, totalUsage);
        this.loadAverageIdx = this.setValueInArr(this.loadAverage, this.loadAverageIdx, this.osBean.getSystemLoadAverage());
        if (totalUsage > this.treshold && this.recentCpu(6) > this.treshold) {
            this.prepareWarning("High CPU usage, current: " + this.format.format(totalUsage) + ", last minute: " + this.format.format(this.recentCpu(6)), results, this);
        } else if (totalUsage < this.treshold * 0.75) {
            this.prepareCalmDown("CPU usage is now low again, current: " + this.format.format(totalUsage) + ", last minute: " + this.format.format(this.recentCpu(6)), results, this);
        }
        String result = this.checkForDeadLock();
        if (result != null) {
            System.out.println("Dead-locked threads:\n" + result);
            this.prepareWarning("Dead-locked threads:\n" + result, results, this);
        }
    }

    private double recentCpu(int histCheck) {
        double recentCpu = 0.0;
        int start = this.cpuUsageIdx - histCheck;
        if (start < 0) {
            start = this.cpuUsage.length - start;
        }
        for (int i = 0; i < histCheck; ++i) {
            int idx = (start + i) % this.cpuUsage.length;
            recentCpu += this.cpuUsage[idx];
        }
        return recentCpu / (double)histCheck;
    }

    @Override
    public String getState() {
        int idx = this.cpuUsageIdx - 1;
        if (idx < 0) {
            idx = this.cpuUsage.length - 1;
        }
        NumberFormat formd = NumberFormat.getNumberInstance();
        formd.setMaximumFractionDigits(4);
        return "Current CPU usage is: " + this.format.format(this.cpuUsage[idx]) + ", Last minute CPU usage is: " + this.format.format(this.recentCpu(6)) + ", Load average is: " + formd.format(this.loadAverage[idx]) + "\n";
    }

    @Override
    public void destroy() {
    }

    private static enum command {
        maxthread(" - Returns information about the most active thread."),
        mth(" - Short version of the command above."),
        allthreads(" [ex] - display all threads information, with 'ex' parameters it prints extended information.");

        private String helpText = null;

        private command(String helpText) {
            this.helpText = helpText;
        }

        public String getHelp() {
            return this.helpText;
        }
    }
}

