/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.BufferUnderflowException;
import tigase.io.IOInterface;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;

public class TLSIO
implements IOInterface {
    private static Logger log = Logger.getLogger("tigase.io.TLSIO");
    private IOInterface io = null;
    private TLSWrapper tlsWrapper = null;
    private ByteBuffer tlsInput = null;

    public TLSIO(IOInterface ioi, TLSWrapper wrapper) throws IOException {
        this.io = ioi;
        this.tlsWrapper = wrapper;
        this.tlsInput = ByteBuffer.allocate(this.tlsWrapper.getAppBuffSize());
        if (log.isLoggable(Level.FINER)) {
            log.finer("TLS Socket created, connected: " + this.io.isConnected());
        }
        if (this.tlsWrapper.isClientMode()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("TLS - client mode, starting handshaking now...");
            }
            this.write(ByteBuffer.allocate(0));
            if (log.isLoggable(Level.FINER)) {
                log.finer("Handshaking completed, you can send data now.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ByteBuffer decodeData(ByteBuffer input) throws IOException {
        TLSStatus stat = null;
        input.flip();
        block5: do {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Decoding data: " + input.remaining());
            }
            this.tlsInput = this.tlsWrapper.unwrap(input, this.tlsInput);
            switch (this.tlsWrapper.getStatus()) {
                case NEED_WRITE: {
                    this.write(ByteBuffer.allocate(0));
                    break;
                }
                case UNDERFLOW: {
                    int netSize = this.tlsWrapper.getPacketBuffSize();
                    if (!log.isLoggable(Level.FINER)) throw new BufferUnderflowException();
                    log.finer("tlsWrapper.getStatus() = UNDERFLOW");
                    log.finer("PacketBuffSize=" + netSize);
                    log.finer("input.capacity()=" + input.capacity());
                    log.finer("tlsInput.capacity()=" + this.tlsInput.capacity());
                    log.finer("input.remaining()=" + input.remaining());
                    log.finer("tlsInput.remaining()=" + this.tlsInput.remaining());
                    throw new BufferUnderflowException();
                }
                case CLOSED: {
                    if (this.tlsWrapper.getStatus() != TLSStatus.CLOSED) break block5;
                    if (!log.isLoggable(Level.FINER)) throw new EOFException("Socket has been closed.");
                    log.finer("TLS Socket closed...");
                    throw new EOFException("Socket has been closed.");
                }
            }
        } while (((stat = this.tlsWrapper.getStatus()) == TLSStatus.NEED_READ || stat == TLSStatus.OK) && input.hasRemaining());
        if (input.hasRemaining()) {
            input.rewind();
            return this.tlsInput;
        }
        input.clear();
        return this.tlsInput;
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        buff = this.io.read(buff);
        if (this.io.bytesRead() > 0) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Read bytes: " + this.bytesRead());
            }
            return this.decodeData(buff);
        }
        return null;
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        if (buff == null) {
            return this.io.write(null);
        }
        int result = 0;
        if (log.isLoggable(Level.FINER)) {
            log.finer("TLS - Writing data, remaining: " + buff.remaining());
        }
        int wr = 0;
        do {
            ByteBuffer tlsOutput = ByteBuffer.allocate(this.tlsWrapper.getNetBuffSize());
            tlsOutput.clear();
            this.tlsWrapper.wrap(buff, tlsOutput);
            if (this.tlsWrapper.getStatus() == TLSStatus.CLOSED) {
                throw new EOFException("Socket has been closed.");
            }
            tlsOutput.flip();
            wr = this.io.write(tlsOutput);
            result += wr;
        } while (buff.hasRemaining() && wr > 0);
        if (this.tlsWrapper.getStatus() == TLSStatus.NEED_WRITE) {
            this.write(ByteBuffer.allocate(0));
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        return this.io.isConnected();
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called...");
        }
        this.io.stop();
        this.tlsWrapper.close();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    @Override
    public int bytesRead() {
        return this.io.bytesRead();
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.tlsWrapper.getPacketBuffSize();
    }

    @Override
    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    @Override
    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }
}

