/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.cluster.ClusteringStrategyIfc;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClusteredOld
extends SessionManager
implements ClusteredComponent {
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_KEY = "cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.SMNonCachingAllNodes";
    private static final Logger log = Logger.getLogger(SessionManagerClusteredOld.class.getName());
    private static final String USER_ID = "userId";
    private static final String SM_ID = "smId";
    private static final String CREATION_TIME = "creationTime";
    private static final String ERROR_CODE = "errorCode";
    private static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final String RESOURCE = "resource";
    private static final String CONNECTION_ID = "connectionId";
    private static final String PRIORITY = "priority";
    private static final String TOKEN = "token";
    private static final String TRANSFER = "transfer";
    private static final String AUTH_TIME = "auth-time";
    private Timer delayedTasks = null;
    private ClusteringStrategyIfc strategy = null;

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            this.processClusterPacket(packet);
            return;
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet) || this.sentToNextNode(packet))) {
            return;
        }
        if (conn != null) {
            switch (conn.getConnectionStatus()) {
                case ON_HOLD: {
                    LinkedList<Packet> packets = (LinkedList<Packet>)conn.getSessionData("session-packets");
                    if (packets == null) {
                        packets = new LinkedList<Packet>();
                        conn.putSessionData("session-packets", packets);
                    }
                    packets.offer(packet);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Packet put on hold: " + packet.toString());
                    }
                    return;
                }
                case REDIRECT: {
                    this.sendPacketRedirect(packet, (String)conn.getSessionData("redirect-to"));
                    return;
                }
            }
        }
        this.processPacket(packet, conn);
    }

    protected void processPacket(ClusterElement packet) {
        List<Element> elems = packet.getDataPackets();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                Packet el_packet = new Packet(elem);
                XMPPResourceConnection conn = this.getXMPPResourceConnection(el_packet);
                if (conn == null && this.sentToNextNode(packet)) continue;
                if (conn != null) {
                    switch (conn.getConnectionStatus()) {
                        case ON_HOLD: {
                            LinkedList<Packet> packets = (LinkedList<Packet>)conn.getSessionData("session-packets");
                            if (packets == null) {
                                packets = new LinkedList<Packet>();
                                conn.putSessionData("session-packets", packets);
                            }
                            packets.offer(el_packet);
                            log.finest("Packet put on hold: " + el_packet.toString());
                            return;
                        }
                        case REDIRECT: {
                            this.sendPacketRedirect(el_packet, (String)conn.getSessionData("redirect-to"));
                            return;
                        }
                    }
                }
                this.processPacket(el_packet, conn);
            }
        } else {
            log.finest("Empty packets list in the cluster packet: " + packet.toString());
        }
    }

    private void sendPacketRedirect(Packet packet, String destination) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("to", destination);
        params.put("from", packet.getFrom());
        ClusterElement redirect = ClusterElement.createClusterMethodCall(this.getComponentId(), destination, StanzaType.set, ClusterMethods.PACKET_REDIRECT.toString(), params);
        redirect.addDataPacket(packet);
        Packet pack_red = new Packet(redirect.getClusterElement());
        this.fastAddOutPacket(pack_red);
        log.finest("Packet redirected: " + pack_red.toString());
    }

    protected void processClusterPacket(Packet packet) {
        ClusterElement clel = new ClusterElement(packet.getElement());
        switch (packet.getType()) {
            case set: {
                if (clel.getMethodName() == null) {
                    this.processPacket(clel);
                }
                if (ClusterMethods.PACKET_REDIRECT.toString().equals(clel.getMethodName())) {
                    for (Element elem : clel.getDataPackets()) {
                        Packet pack = new Packet(elem);
                        pack.setTo(clel.getMethodParam("to"));
                        pack.setFrom(clel.getMethodParam("from"));
                        XMPPResourceConnection conn = this.getXMPPResourceConnection(pack);
                        if (conn == null) {
                            ClusterElement response = clel.createMethodResponse(packet.getTo(), packet.getFrom(), StanzaType.error.toString(), null);
                            Packet resp_pack = new Packet(response.getClusterElement());
                            this.fastAddOutPacket(resp_pack);
                            log.info("No local session for redirected packet, sending error back: " + resp_pack.toString());
                            continue;
                        }
                        this.processPacket(pack, conn);
                    }
                    return;
                }
                if (!ClusterMethods.SESSION_TRANSFER.toString().equals(clel.getMethodName())) break;
                LinkedHashSet<String> cancel_nodes = new LinkedHashSet<String>();
                String node_found = null;
                String userId = clel.getMethodParam(USER_ID);
                XMPPSession session = this.getSession(userId);
                String connectionId = clel.getMethodParam(CONNECTION_ID);
                XMPPResourceConnection conn = null;
                if (session != null) {
                    conn = session.getResourceForConnectionId(connectionId);
                }
                if (this.getComponentId().equals(clel.getFirstNode())) {
                    LinkedHashMap<String, String> res_vals;
                    log.finest("Session transfer request came back to me....");
                    long time = 0L;
                    long hash = 0L;
                    for (String node : clel.getVisitedNodes()) {
                        if (clel.getMethodResultVal(node + "-CREATED") == null) continue;
                        long tmp_time = clel.getMethodResultVal(node + "-" + AUTH_TIME, 0L);
                        long tmp_hash = clel.getMethodResultVal(node + "-HASH-" + XMPP_SESSION_ID, 0L);
                        log.finest("Node: " + node + " responded with: " + clel.getMethodResultVal(node + "-CREATED") + ", tmp_time: " + tmp_time + ", tmp_hash: " + tmp_hash);
                        boolean replace_node = false;
                        if (tmp_time == time) {
                            if (tmp_hash > hash) {
                                replace_node = true;
                            }
                        } else if (tmp_time > time) {
                            replace_node = true;
                        }
                        if (replace_node) {
                            if (node_found != null) {
                                log.finest("Addeding node to cancel_nodes: " + node_found);
                                cancel_nodes.add(node_found);
                            }
                            node_found = node;
                            hash = tmp_hash;
                            time = tmp_time;
                            continue;
                        }
                        log.finest("Addeding node to cancel_nodes: " + node);
                        cancel_nodes.add(node);
                    }
                    if (node_found != null) {
                        if (session != null) {
                            if (conn != null) {
                                res_vals = new LinkedHashMap<String, String>();
                                res_vals.put(TRANSFER, "accept");
                                ClusterElement result = clel.createMethodResponse(this.getComponentId(), node_found, "result", res_vals);
                                this.fastAddOutPacket(new Packet(result.getClusterElement()));
                                conn.putSessionData("redirect-to", node_found);
                                this.sendAllOnHold(conn);
                                String xmpp_sessionId = clel.getMethodParam(XMPP_SESSION_ID);
                                Packet redirect = Command.REDIRECT.getPacket(node_found, connectionId, StanzaType.set, "1", Command.DataType.submit);
                                Command.addFieldValue(redirect, "session-id", xmpp_sessionId);
                                this.fastAddOutPacket(redirect);
                            } else {
                                log.finest("Addeding node to cancel_nodes: " + node_found);
                                cancel_nodes.add(node_found);
                                log.fine("The user connection doesn't exist: " + userId + ", connectionId: " + connectionId);
                            }
                        } else {
                            log.finest("Addeding node to cancel_nodes: " + node_found);
                            cancel_nodes.add(node_found);
                            log.fine("The user session doesn't exist: " + userId);
                        }
                    } else if (conn != null) {
                        log.finest("Set status to NORMAL and send all ON_HOLD");
                        conn.setConnectionStatus(ConnectionStatus.NORMAL);
                        this.sendAllOnHold(conn);
                    } else {
                        log.fine("The user connection doesn't exist: " + userId + ", connectionId: " + connectionId);
                    }
                    if (cancel_nodes.size() <= 0) break;
                    res_vals = new LinkedHashMap();
                    res_vals.put(TRANSFER, "cancel");
                    for (String node : cancel_nodes) {
                        ClusterElement result = clel.createMethodResponse(this.getComponentId(), node, "result", res_vals);
                        log.finest("Sending sesstion transfer CANCEL to node: " + node);
                        this.fastAddOutPacket(new Packet(result.getClusterElement()));
                    }
                    break;
                }
                ClusterElement result = ClusterElement.createForNextNode(clel, this.strategy.getNodesForJid(userId), this.getComponentId());
                if (session != null) {
                    conn = session.getOldestConnection();
                    boolean transfer_in = false;
                    switch (conn.getConnectionStatus()) {
                        case ON_HOLD: {
                            long local_auth_time = conn.getAuthTime();
                            long remote_auth_time = clel.getMethodParam(AUTH_TIME, 0L);
                            if (local_auth_time == remote_auth_time) {
                                transfer_in = conn.getSessionId().hashCode() > clel.getMethodParam(XMPP_SESSION_ID).hashCode();
                                break;
                            }
                            transfer_in = local_auth_time > remote_auth_time;
                            break;
                        }
                        case REDIRECT: {
                            transfer_in = false;
                            break;
                        }
                        case NORMAL: {
                            transfer_in = true;
                            break;
                        }
                    }
                    if (transfer_in) {
                        this.addTempSession(clel);
                        result.addMethodResult(this.getComponentId() + "-" + AUTH_TIME, "" + conn.getAuthTime());
                        result.addMethodResult(this.getComponentId() + "-HASH-" + XMPP_SESSION_ID, "" + conn.getSessionId().hashCode());
                        result.addMethodResult(this.getComponentId() + "-STATUS", "" + (Object)((Object)conn.getConnectionStatus()));
                        result.addMethodResult(this.getComponentId() + "-CREATED", "true");
                    }
                }
                this.fastAddOutPacket(new Packet(result.getClusterElement()));
                break;
            }
            case result: {
                if (!ClusterMethods.SESSION_TRANSFER.toString().equals(clel.getMethodName())) break;
                String transfer = clel.getMethodResultVal(TRANSFER);
                if (transfer == null) {
                    log.warning("Incorrect response for the session transfer: " + packet.toString());
                    return;
                }
                if (transfer.equals("accept")) {
                    String userId = clel.getMethodParam(USER_ID);
                    XMPPSession session = this.getSession(userId);
                    if (session == null) {
                        log.warning("User session does not exist for the request to complete the user transfer: " + packet.toString());
                        return;
                    }
                    String connectionId = clel.getMethodParam(CONNECTION_ID);
                    XMPPResourceConnection conn = session.getResourceForConnectionId(connectionId);
                    if (conn == null) {
                        log.warning("User connection does not exist for the request to complete the user transfer: " + packet.toString());
                        return;
                    }
                    String token = (String)conn.getSessionData(TOKEN);
                    String xmpp_sessionId = conn.getSessionId();
                    Authorization auth_res = null;
                    try {
                        auth_res = conn.loginToken(userId, xmpp_sessionId, token);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Token authentication unsuccessful.", e);
                        auth_res = Authorization.NOT_AUTHORIZED;
                    }
                    if (auth_res == Authorization.AUTHORIZED) {
                        log.finest("SESSION_TRANSFER received SET request, userId: " + userId + ", xmpp_sessionId: " + xmpp_sessionId + ", connectionId: " + connectionId + ", auth_res: " + (Object)((Object)auth_res));
                    } else {
                        log.finest("SESSION_TRANSFER authorization failed: " + (Object)((Object)auth_res) + ", userId: " + userId);
                        this.closeConnection(conn.getConnectionId(), true);
                        Packet close = Command.CLOSE.getPacket(this.getComponentId(), connectionId, StanzaType.set, "1");
                        this.fastAddOutPacket(close);
                    }
                    conn.setConnectionStatus(ConnectionStatus.NORMAL);
                    return;
                }
                if (transfer.equals("cancel")) {
                    String connectionId = clel.getMethodParam(CONNECTION_ID);
                    this.closeConnection(connectionId, true);
                    return;
                }
                log.warning("Incorrect response for the session transfer: " + packet.toString());
                break;
            }
            case error: {
                if (ClusterMethods.PACKET_REDIRECT.toString().equals(clel.getMethodName())) {
                    for (Element elem : clel.getDataPackets()) {
                        Packet pack = new Packet(elem);
                        pack.setTo(clel.getMethodParam("to"));
                        pack.setFrom(clel.getMethodParam("from"));
                        XMPPResourceConnection conn = this.getXMPPResourceConnection(pack);
                        if (conn == null) {
                            log.info("No local session for redirect error packet, ignoring: " + packet.toString());
                            continue;
                        }
                        log.info("Packet redirect error, removing local session: " + packet.toString());
                        this.closeConnection(conn.getConnectionId(), true);
                    }
                    return;
                }
                String from = packet.getElemFrom();
                clel.addVisitedNode(from);
                this.processPacket(clel);
                break;
            }
        }
    }

    private void addTempSession(ClusterElement clel) {
        String connectionId = clel.getMethodParam(CONNECTION_ID);
        String userId = clel.getMethodParam(USER_ID);
        String domain = JIDUtils.getNodeHost((String)userId);
        XMPPResourceConnection res_con = this.createUserSession(connectionId, domain);
        res_con.setConnectionStatus(ConnectionStatus.TEMP);
        String xmpp_sessionId = clel.getMethodParam(XMPP_SESSION_ID);
        res_con.setSessionId(xmpp_sessionId);
        String token = clel.getMethodParam(TOKEN);
        res_con.putSessionData(TOKEN, token);
    }

    protected boolean sentToNextNode(ClusterElement clel) {
        String userId = clel.getMethodParam(USER_ID);
        ClusterElement next_clel = ClusterElement.createForNextNode(clel, this.strategy.getNodesForJid(userId), this.getComponentId());
        if (next_clel != null) {
            this.fastAddOutPacket(new Packet(next_clel.getClusterElement()));
            return true;
        }
        return false;
    }

    protected boolean sentToNextNode(Packet packet) {
        String userId = JIDUtils.getNodeID((String)packet.getElemTo());
        String cluster_node = this.getFirstClusterNode(userId);
        if (cluster_node != null) {
            String sess_man_id = this.getComponentId();
            ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
            clel.addVisitedNode(sess_man_id);
            this.fastAddOutPacket(new Packet(clel.getClusterElement()));
            return true;
        }
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
        try {
            ClusteringStrategyIfc strategy_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            strategy_tmp.setProperties(props);
            this.strategy = strategy_tmp;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create VHost repository instance for class: " + strategy_class, e);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate VHosts repository for class: " + strategy_class, e);
        }
        return props;
    }

    @Override
    public void nodesConnected(Set<String> node_hostnames) {
        log.fine("Nodes connected: " + node_hostnames.toString());
        for (String host : node_hostnames) {
            String jid = this.getName() + "@" + host;
            this.strategy.nodeConnected(jid);
            this.addTrusted(jid);
        }
    }

    @Override
    public void nodesDisconnected(Set<String> node_hostnames) {
        log.fine("Nodes disconnected: " + node_hostnames.toString());
        for (String host : node_hostnames) {
            String jid = this.getName() + "@" + host;
            this.strategy.nodeDisconnected(jid);
            this.delTrusted(jid);
        }
    }

    protected String getFirstClusterNode(String userId) {
        String[] nodes;
        String cluster_node = null;
        for (String node : nodes = this.strategy.getNodesForJid(userId)) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    @Override
    public void handleLogin(String userName, XMPPResourceConnection conn) {
        String userId;
        String cluster_node;
        super.handleLogin(userName, conn);
        if (!conn.isAnonymous() && (cluster_node = this.getFirstClusterNode(userId = JIDUtils.getNodeID((String)userName, (String)conn.getDomain()))) != null) {
            try {
                String xmpp_sessionId = conn.getSessionId();
                String token = conn.getAuthenticationToken(xmpp_sessionId);
                String connectionId = conn.getConnectionId();
                String resource = conn.getResource();
                int priority = conn.getPriority();
                long authTime = conn.getAuthTime();
                log.finest("Sending user: " + userId + " session, resource: " + resource + ", xmpp_sessionId: " + xmpp_sessionId + ", connectionId: " + connectionId);
                conn.setConnectionStatus(ConnectionStatus.ON_HOLD);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put(USER_ID, userId);
                params.put(XMPP_SESSION_ID, xmpp_sessionId);
                params.put(CONNECTION_ID, connectionId);
                params.put(PRIORITY, "" + priority);
                params.put(TOKEN, token);
                params.put(AUTH_TIME, "" + authTime);
                Element check_session_el = ClusterElement.createClusterMethodCall(this.getComponentId(), cluster_node, StanzaType.set, ClusterMethods.SESSION_TRANSFER.toString(), params).getClusterElement();
                this.fastAddOutPacket(new Packet(check_session_el));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with session transfer process, ", e);
            }
        }
    }

    @Override
    public void release() {
        this.delayedTasks.cancel();
        super.release();
    }

    @Override
    public void start() {
        super.start();
        this.delayedTasks = new Timer("SM Cluster Delayed Tasks", true);
    }
}

