/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.cluster.ClusteringStrategyIfc;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClustered
extends SessionManager
implements ClusteredComponent {
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_KEY = "cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.SMNonCachingAllNodes";
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private static final String USER_ID = "userId";
    private static final String SM_ID = "smId";
    private static final String CREATION_TIME = "creationTime";
    private static final String ERROR_CODE = "errorCode";
    private static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final String RESOURCE = "resource";
    private static final String CONNECTION_ID = "connectionId";
    private static final String PRIORITY = "priority";
    private static final String TOKEN = "token";
    private static final String TRANSFER = "transfer";
    private static final String AUTH_TIME = "auth-time";
    private static final String CLUSTER_BROADCAST = "cluster-broadcast";
    private Timer delayedTasks = null;
    private ClusteringStrategyIfc strategy = null;

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            if (this.isTrusted(packet.getElemFrom())) {
                this.processClusterPacket(packet);
            } else if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Cluster packet from untrusted source: " + packet.toString());
            }
            return;
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet) || this.sendToNextNode(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    protected void processPacket(ClusterElement packet) {
        List<Element> elems = packet.getDataPackets();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                Packet el_packet = new Packet(elem);
                XMPPResourceConnection conn = this.getXMPPResourceConnection(el_packet);
                if (conn == null && this.sendToNextNode(packet, el_packet.getElemTo())) continue;
                this.processPacket(el_packet, conn);
            }
        } else {
            log.finest("Empty packets list in the cluster packet: " + packet.toString());
        }
    }

    protected void processClusterPacket(Packet packet) {
        LinkedList<Packet> results = new LinkedList<Packet>();
        ClusterElement clel = new ClusterElement(packet.getElement());
        switch (packet.getType()) {
            case set: {
                String connectionId;
                XMPPSession session;
                String resource;
                String userId;
                if (clel.getMethodName() == null) {
                    this.processPacket(clel);
                }
                if (ClusterMethods.USER_CONNECTED.name().equals(clel.getMethodName())) {
                    userId = clel.getMethodParam(USER_ID);
                    resource = clel.getMethodParam(RESOURCE);
                    session = this.getSession(userId);
                    if (session != null && session.getResourceForResource(resource) == null) {
                        connectionId = clel.getMethodParam(CONNECTION_ID);
                        String xmpp_sessionId = clel.getMethodParam(XMPP_SESSION_ID);
                        String domain = JIDUtils.getNodeHost((String)userId);
                        XMPPResourceConnection res_con = this.loginUserSession(connectionId, domain, userId, resource, ConnectionStatus.REMOTE, xmpp_sessionId);
                        if (res_con != null) {
                            List<Element> packs = clel.getDataPackets();
                            for (Element elem : packs) {
                                if (elem.getName() != "presence") continue;
                                res_con.setPresence(elem);
                            }
                            res_con.putSessionData(SM_ID, packet.getElemFrom());
                            this.updateUserResources(res_con, results);
                            for (XMPPResourceConnection xrc : session.getActiveResources()) {
                                if (xrc.getConnectionStatus() == ConnectionStatus.REMOTE) continue;
                                this.broadcastUserConnected(xrc, packet.getElemFrom());
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Added remote session for: " + userId + ", from: " + packet.getElemFrom());
                            }
                        } else if (log.isLoggable(Level.INFO)) {
                            log.info("Couldn't create user session for: " + userId + ", resource: " + resource + ", connectionId: " + connectionId);
                        }
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.finest("Ignoring USER_CONNECTED for: " + userId + ", from: " + packet.getElemFrom());
                    }
                    this.strategy.userConnected(userId + "/" + resource, packet.getElemFrom(), results);
                }
                if (!ClusterMethods.USER_DISCONNECTED.name().equals(clel.getMethodName())) break;
                userId = clel.getMethodParam(USER_ID);
                resource = clel.getMethodParam(RESOURCE);
                session = this.getSession(userId);
                if (session != null) {
                    connectionId = clel.getMethodParam(CONNECTION_ID);
                    this.closeConnection(connectionId, true);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Removed remote session for: " + userId + ", from: " + packet.getElemFrom());
                    }
                }
                this.strategy.userDisconnected(userId + "/" + resource, packet.getElemFrom(), results);
                break;
            }
            case result: {
                break;
            }
            case error: {
                String from = packet.getElemFrom();
                clel.addVisitedNode(from);
                this.processPacket(clel);
                break;
            }
        }
        this.addOutPackets(results);
    }

    protected void updateUserResources(XMPPResourceConnection session, Queue<Packet> results) {
        try {
            Element pres_update = session.getPresence();
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn.getJID());
                }
                if (conn != session && conn.isResourceSet() && conn.getConnectionStatus() != ConnectionStatus.REMOTE) {
                    pres_update = pres_update != null ? pres_update.clone() : new Element("presence");
                    pres_update.setAttribute("from", session.getJID());
                    pres_update.setAttribute("to", conn.getUserId());
                    Packet pack_update = new Packet(pres_update);
                    pack_update.setTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
        }
        catch (NotAuthorizedException ex) {
            log.warning("This should not happen, unless the connection has been stopped in a concurrent thread: " + session.getConnectionId());
        }
    }

    protected boolean sendToNextNode(ClusterElement clel, String userId) {
        ClusterElement next_clel = ClusterElement.createForNextNode(clel, this.strategy.getNodesForJid(userId), this.getComponentId());
        if (next_clel != null) {
            this.fastAddOutPacket(new Packet(next_clel.getClusterElement()));
            return true;
        }
        return false;
    }

    protected boolean sendToNextNode(Packet packet) {
        String userId = JIDUtils.getNodeID((String)packet.getElemTo());
        String cluster_node = this.getFirstClusterNode(userId);
        if (cluster_node != null) {
            String sess_man_id = this.getComponentId();
            ClusterElement clel = new ClusterElement(sess_man_id, cluster_node, StanzaType.set, packet);
            clel.addVisitedNode(sess_man_id);
            this.fastAddOutPacket(new Packet(clel.getClusterElement()));
            return true;
        }
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
        try {
            ClusteringStrategyIfc strategy_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            strategy_tmp.setProperties(props);
            this.strategy = strategy_tmp;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not clustering strategy instance for class: " + strategy_class, e);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate clustering strategy for class: " + strategy_class, e);
        }
        return props;
    }

    @Override
    public void nodesConnected(Set<String> node_hostnames) {
        log.fine("Nodes connected: " + node_hostnames.toString());
        for (String host : node_hostnames) {
            String jid = this.getName() + "@" + host;
            this.addTrusted(jid);
            this.strategy.nodeConnected(jid);
        }
    }

    @Override
    public void nodesDisconnected(Set<String> node_hostnames) {
        log.fine("Nodes disconnected: " + node_hostnames.toString());
        for (String host : node_hostnames) {
            String jid = this.getName() + "@" + host;
            this.strategy.nodeDisconnected(jid);
        }
    }

    protected String getFirstClusterNode(String userId) {
        String[] nodes;
        String cluster_node = null;
        for (String node : nodes = this.strategy.getNodesForJid(userId)) {
            if (node.equals(this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && conn.isAuthorized()) {
            try {
                String[] cl_nodes;
                String connectionId = conn.getConnectionId();
                String userId = conn.getUserId();
                String resource = conn.getResource();
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put(CONNECTION_ID, connectionId);
                params.put(USER_ID, userId);
                params.put(RESOURCE, resource);
                for (String node : cl_nodes = this.strategy.getAllNodes()) {
                    if (node.equals(this.getComponentId())) continue;
                    Element check_session_el = ClusterElement.createClusterMethodCall(this.getComponentId(), node, StanzaType.set, ClusterMethods.USER_DISCONNECTED.toString(), params).getClusterElement();
                    this.fastAddOutPacket(new Packet(check_session_el));
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem sending user disconnect broadcast for: " + conn.getConnectionId(), ex);
            }
        }
        XMPPSession parentSession = conn.getParentSession();
        super.closeSession(conn, closeOnly);
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && parentSession != null && parentSession.getActiveResourcesSize() == parentSession.getResSizeForConnStatus(ConnectionStatus.REMOTE)) {
            List<XMPPResourceConnection> conns = parentSession.getActiveResources();
            for (XMPPResourceConnection xrc : conns) {
                String connId = xrc.getConnectionId();
                super.closeConnection(xrc.getConnectionId(), true);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Closed remote connection: " + connId);
            }
        }
    }

    private void broadcastUserConnected(XMPPResourceConnection conn, String ... cl_nodes) {
        try {
            String userId = conn.getUserId();
            String xmpp_sessionId = conn.getSessionId();
            String connectionId = conn.getConnectionId();
            String resource = conn.getResource();
            long authTime = conn.getAuthTime();
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put(USER_ID, userId);
            params.put(XMPP_SESSION_ID, xmpp_sessionId);
            params.put(RESOURCE, resource);
            params.put(CONNECTION_ID, connectionId);
            params.put(AUTH_TIME, "" + authTime);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending user: " + userId + " session, resource: " + resource + ", xmpp_sessionId: " + xmpp_sessionId + ", connectionId: " + connectionId);
            }
            Element presence = conn.getPresence();
            for (String node : cl_nodes) {
                if (node.equals(this.getComponentId())) continue;
                ClusterElement clel = ClusterElement.createClusterMethodCall(this.getComponentId(), node, StanzaType.set, ClusterMethods.USER_CONNECTED.toString(), params);
                if (presence != null) {
                    clel.addDataPacket(presence);
                }
                Element check_session_el = clel.getClusterElement();
                this.fastAddOutPacket(new Packet(check_session_el));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user connected message for: " + conn.getConnectionId(), e);
        }
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
        super.handlePresenceSet(conn);
        if (conn.getConnectionStatus() == ConnectionStatus.REMOTE) {
            return;
        }
        if (conn.getSessionData(CLUSTER_BROADCAST) == null) {
            String[] cl_nodes = this.strategy.getAllNodes();
            this.broadcastUserConnected(conn, cl_nodes);
            conn.putSessionData(CLUSTER_BROADCAST, CLUSTER_BROADCAST);
        }
    }

    @Override
    public void release() {
        this.delayedTasks.cancel();
        super.release();
    }

    @Override
    public void start() {
        super.start();
        this.delayedTasks = new Timer("SM Cluster Delayed Tasks", true);
    }
}

