/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2008 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 * 
 * $Rev: 1670 $
 * Last modified by $Author: kobit $
 * $Date: 2009-05-23 12:33:59 +0100 (Sat, 23 May 2009) $
 */

package tigase.cluster;

import java.util.Map;
import java.util.Queue;
import tigase.server.Packet;

/**
 * Created: May 2, 2009 4:36:03 PM
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1670 $
 */
public interface ClusteringStrategyIfc {

	//void init(String smName);

	Map<String, Object> getDefaults(Map<String, Object> params);

	void setProperties(Map<String, Object> props);

	String[] getNodesForJid(String jid);

	String[] getAllNodes();

	void nodeConnected(String jid);

	void nodeDisconnected(String jid);

	void userConnected(String jid, String sm, Queue<Packet> results);

	void userDisconnected(String jid, String sm, Queue<Packet> results);

}
