/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class UrnXmppPing
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String XMLNS = "urn:xmpp:ping";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:ping"})};
    private static final String[] ELEMENTS = new String[]{"ping"};
    private static final String ID = "urn:xmpp:ping";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.UrnXmppPing");
    private static final String[] XMLNSS = new String[]{"urn:xmpp:ping"};

    @Override
    public String id() {
        return "urn:xmpp:ping";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            try {
                results.offer(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true));
            }
            catch (PacketErrorTypeException e) {
                log.fine("This is already ping error packet, ignoring... " + packet.toString());
            }
            return;
        }
        String id = session.getDomain();
        if (packet.getElemTo() != null) {
            id = JIDUtils.getNodeID((String)packet.getElemTo());
        }
        if (id == null || id.equals("") || id.equalsIgnoreCase(session.getDomain()) || session.getConnectionId() == "NULL") {
            results.offer(packet.okResult((Element)null, 0));
            return;
        }
        try {
            if (id.equals(session.getUserId())) {
                Element elem = packet.getElement().clone();
                Packet result = new Packet(elem);
                result.setTo(session.getConnectionId(packet.getElemTo()));
                result.setFrom(packet.getTo());
                results.offer(result);
            } else {
                Element result = packet.getElement().clone();
                results.offer(new Packet(result));
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.getStringData());
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

